/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FlsIntTest {
    static final int DOC_COUNT = 200;
    static final TestData TEST_DATA;
    static final String INDEX_NAME_PREFIX = "logs";
    static final String INDEX_PATTERN = "logs*";
    static final String INDEX_NORMAL_MODE = "logs_normal_index_mode";
    static final String INDEX_LOGS_DB_MODE = "logs_logs_db_index_mode";
    static final TestSgConfig.User ADMIN;
    static final TestSgConfig.User EXCLUDE_IP_USER;
    static final TestSgConfig.User INCLUDE_LOC_USER;
    static final TestSgConfig.User MULTI_ROLE_USER;
    static final TestSgConfig.Authc AUTHC;
    static final TestSgConfig.DlsFls DLSFLS;
    @ClassRule
    public static LocalCluster.Embedded cluster;
    private final String indexName;

    @Parameterized.Parameters(name="{0}")
    public static Object[] parameters() {
        return new Object[]{INDEX_NORMAL_MODE, INDEX_LOGS_DB_MODE};
    }

    public FlsIntTest(String indexName) {
        this.indexName = indexName;
    }

    @BeforeClass
    public static void setupTestData() throws IOException {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            Settings settings = Settings.builder().put("index.number_of_shards", 5).build();
            String indexMode = TEST_DATA.createIndex(client, INDEX_NORMAL_MODE, settings);
            MatcherAssert.assertThat((Object)indexMode, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"normal"), (Matcher)Matchers.nullValue()));
            settings = Settings.builder().put("index.number_of_shards", 5).put("index.mode", "logsdb").build();
            indexMode = TEST_DATA.createIndex(client, INDEX_LOGS_DB_MODE, settings);
            MatcherAssert.assertThat((Object)indexMode, (Matcher)Matchers.equalTo((Object)"logsdb"));
        }
    }

    @Test
    public void search_exclude() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)EXCLUDE_IP_USER, new Header[0]);){
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_ip)]").size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!@._source.source_ip)]").size() == 10 ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_ip)]").size() != 0 ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_include() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)INCLUDE_LOC_USER, new Header[0]);){
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_ip)]").size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!@._source.source_ip)]").size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_loc)]").size() == 10 ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_ip)]").size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_loc)]").size() == 10 ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_onFilteredField() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument testDocument = TEST_DATA.anyDocument();
        DocNode searchBody = DocNode.of((String)"query.term.source_ip.value", testDocument.getContent().get("source_ip"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)INCLUDE_LOC_USER, new Header[0]);){
            response = client.postJson("/" + this.indexName + "/_search?pretty", (Map)searchBody, new Header[0]);
            System.out.println(response.getBody());
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)0, (Object)response.getBodyAsDocNode().get("hits", new String[]{"total", "value"}));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.postJson("/" + this.indexName + "/_search?pretty", (Map)searchBody, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)1, (Object)response.getBodyAsDocNode().get("hits", new String[]{"total", "value"}));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_multiRole() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)MULTI_ROLE_USER, new Header[0]);){
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_ip)]").size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dest_ip)]").size() == 0 ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.source_ip)]").size() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dest_ip)]").size() != 0 ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void get_exclude() throws Exception {
        GenericRestClient.HttpResponse response;
        String docId = TEST_DATA.anyDocument().getId();
        String docUrl = "/" + this.indexName + "/_doc/" + docId + "?pretty";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)EXCLUDE_IP_USER, new Header[0]);){
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_ip") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_loc") != null ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(docUrl, new Header[0]);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_loc") != null ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void get_include() throws Exception {
        GenericRestClient.HttpResponse response;
        String docId = TEST_DATA.anyDocument().getId();
        String docUrl = "/" + this.indexName + "/_doc/" + docId + "?pretty";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)INCLUDE_LOC_USER, new Header[0]);){
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_ip") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_loc") != null ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(docUrl, new Header[0]);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_loc") != null ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void get_multiRole() throws Exception {
        GenericRestClient.HttpResponse response;
        String docId = TEST_DATA.anyDocument().getId();
        String docUrl = "/" + this.indexName + "/_doc/" + docId + "?pretty";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)MULTI_ROLE_USER, new Header[0]);){
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("dest_ip") == null ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(docUrl, new Header[0]);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("_source").get("dest_ip") != null ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void mapping() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)EXCLUDE_IP_USER, new Header[0]);){
            response = client.get("/" + this.indexName + "/_mapping?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode(this.indexName).getAsNode("mappings").getAsNode("properties").get("source_ip") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode(this.indexName).getAsNode("mappings").getAsNode("properties").get("source_loc") != null ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/" + this.indexName + "/_mapping?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode(this.indexName).getAsNode("mappings").getAsNode("properties").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode(this.indexName).getAsNode("mappings").getAsNode("properties").get("source_loc") != null ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void fieldCaps() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)EXCLUDE_IP_USER, new Header[0]);){
            response = client.get("/" + this.indexName + "/_field_caps?fields=*&pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_ip") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_ip.keyword") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_loc") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_loc.keyword") != null ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/" + this.indexName + "/_field_caps?fields=*&pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_ip.keyword") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_loc") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("fields").get("source_loc.keyword") != null ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void termvectors() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument doc = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        String docUrl = "/" + this.indexName + "/_termvectors/" + doc.getId() + "?pretty=true&fields=*";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)EXCLUDE_IP_USER, new Header[0]);){
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_ip") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_ip.keyword") == null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_loc") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_loc.keyword") != null ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_ip") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_ip.keyword") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_loc") != null ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().getAsNode("term_vectors").get("source_loc.keyword") != null ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){

            public JsonProvider jsonProvider() {
                return BasicJsonPathDefaultConfiguration.defaultConfiguration().jsonProvider();
            }

            public Set<Option> options() {
                return BasicJsonPathDefaultConfiguration.defaultConfiguration().getOptions();
            }

            public MappingProvider mappingProvider() {
                return BasicJsonPathDefaultConfiguration.defaultConfiguration().mappingProvider();
            }
        });
        TEST_DATA = TestData.documentCount((int)200).timestampColumnName("@timestamp").get();
        ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
        EXCLUDE_IP_USER = new TestSgConfig.User("exclude_ip").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("exclude_ip").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).fls(new String[]{"~*_ip"}).on(new String[]{INDEX_PATTERN}).clusterPermissions(new String[]{"*"})});
        INCLUDE_LOC_USER = new TestSgConfig.User("include_loc").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("include_loc").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).fls(new String[]{"*_loc", "timestamp"}).on(new String[]{INDEX_PATTERN}).clusterPermissions(new String[]{"*"})});
        MULTI_ROLE_USER = new TestSgConfig.User("multi_role").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role1").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).fls(new String[]{"~*_ip"}).on(new String[]{INDEX_PATTERN}).clusterPermissions(new String[]{"*"}), new TestSgConfig.Role("role2").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).fls(new String[]{"source_ip"}).on(new String[]{INDEX_PATTERN}).clusterPermissions(new String[]{"*"})});
        AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
        DLSFLS = new TestSgConfig.DlsFls();
        cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).users(new TestSgConfig.User[]{ADMIN, EXCLUDE_IP_USER, INCLUDE_LOC_USER, MULTI_ROLE_USER}).resources("dlsfls").embedded().build();
    }
}

