/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FlsKeywordTest {
    private static final Logger log = LogManager.getLogger(FlsKeywordTest.class);
    public static final String DOCUMENTS_INDEX_NAME = "documents";
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_AUTHOR_KEYWORD = "author.keyword";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_TITLE_KEYWORD = "title.keyword";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_CONTENT_KEYWORD = "content.keyword";
    public static final String AUTHOR_AGGREGATION_NAME = "author-aggregation";
    public static final String MATCH_ALL_QUERY_WITH_FIELDS = DocNode.of((String)"query", (Object)DocNode.of((String)"match_all", (Object)DocNode.EMPTY), (String)"fields", Arrays.asList("title", "title.keyword", "content", "content.keyword", "author", "author.keyword"), (String)"_source", (Object)false).toJsonString();
    public static final String AGGREGATION_BY_AUTHOR_QUERY = DocNode.of((String)"size", (Object)0, (String)"aggs", (Object)DocNode.of((String)"author-aggregation", (Object)DocNode.of((String)"terms", (Object)DocNode.of((String)"field", (Object)"author.keyword")))).toJsonString();
    public static final String AUTHOR_GOETHE = "Goethe";
    static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    private static TestSgConfig.Role DOCUMENT_READER_ROLE = new TestSgConfig.Role("document_reader_role").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"indices:data/read/search"}).on(new String[]{"documents"});
    private static TestSgConfig.Role DOCUMENT_READER_EXCEPT_AUTHOR_ROLE = new TestSgConfig.Role("document_reader_except_author_role").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"indices:data/read/search"}).fls(new String[]{"~author"}).on(new String[]{"documents"});
    private static TestSgConfig.Role DOCUMENT_TITLE_READER_ROLE = new TestSgConfig.Role("document_title_reader_role").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"indices:data/read/search"}).fls(new String[]{"title"}).on(new String[]{"documents"});
    private static TestSgConfig.User DOCUMENT_READER_USER = new TestSgConfig.User("document_reader_user").roles(new String[]{DOCUMENT_READER_ROLE.getName()});
    private static TestSgConfig.User DOCUMENT_READER_EXCEPT_AUTHOR_USER = new TestSgConfig.User("document_reader_except_author_user").roles(new String[]{DOCUMENT_READER_EXCEPT_AUTHOR_ROLE.getName()});
    private static TestSgConfig.User DOCUMENT_TITLE_READER_USER = new TestSgConfig.User("document_title_reader_user").roles(new String[]{DOCUMENT_TITLE_READER_ROLE.getName()});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).roles(new TestSgConfig.Role[]{DOCUMENT_READER_ROLE, DOCUMENT_READER_EXCEPT_AUTHOR_ROLE, DOCUMENT_TITLE_READER_ROLE}).users(new TestSgConfig.User[]{DOCUMENT_READER_USER, DOCUMENT_READER_EXCEPT_AUTHOR_USER, DOCUMENT_TITLE_READER_USER}).embedded().build();

    @BeforeClass
    public static void populateData() {
        Client client = cluster.getPrivilegedInternalNodeClient();
        client.index(((IndexRequest)new IndexRequest(DOCUMENTS_INDEX_NAME).id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(DocNode.of((String)FIELD_TITLE, (Object)"accessible document title", (String)FIELD_CONTENT, (Object)"document content", (String)FIELD_AUTHOR, (Object)AUTHOR_GOETHE).toJsonString(), XContentType.JSON)).actionGet();
    }

    @Test
    public void shouldAccessAuthorFieldDuringRegularSearch() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/documents/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0]._source", (String)FIELD_AUTHOR));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"hits.hits[0]._source.author", (Object)AUTHOR_GOETHE));
        }
    }

    @Test
    public void shouldNotAccessAuthorFieldWhenUserIsLackingFlPermission() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_EXCEPT_AUTHOR_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/documents/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0]._source", (String)FIELD_AUTHOR)));
        }
    }

    @Test
    public void shouldReadWholeDocument() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/documents/_search", MATCH_ALL_QUERY_WITH_FIELDS, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_TITLE));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_TITLE_KEYWORD));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_CONTENT));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_CONTENT_KEYWORD));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"hits.hits[0].fields", (int)6));
        }
    }

    @Test
    public void shouldReadOnlyTitleFromDocument() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_TITLE_READER_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/documents/_search", MATCH_ALL_QUERY_WITH_FIELDS, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_TITLE));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_TITLE_KEYWORD));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_CONTENT)));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_CONTENT_KEYWORD)));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"hits.hits[0].fields", (int)2));
        }
    }

    @Test
    public void shouldReadEverythingBesidesAuthor() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_EXCEPT_AUTHOR_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/documents/_search", MATCH_ALL_QUERY_WITH_FIELDS, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_TITLE));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_TITLE_KEYWORD));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_CONTENT));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_CONTENT_KEYWORD));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_AUTHOR)));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"hits.hits[0].fields", (String)FIELD_AUTHOR_KEYWORD)));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"hits.hits[0].fields", (int)4));
        }
    }

    @Test
    public void shouldPerformAggregationByAuthorKeyword() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/documents/_search", AGGREGATION_BY_AUTHOR_QUERY, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            log.info("Response should contain value of field author '{}'", (Object)response.getBody());
            String jsonPathFirstAggregationBucket = "aggregations.author-aggregation.buckets[0]";
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)jsonPathFirstAggregationBucket, (String)"key"));
        }
    }

    @Test
    public void shouldNotPerformAggregationByAuthorKeywordWhenAccessToTheFieldIsLacking() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_TITLE_READER_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/documents/_search", AGGREGATION_BY_AUTHOR_QUERY, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            log.info("Response should NOT contain value of field author '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"aggregations.author-aggregation.buckets[0]", (String)"key")));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"aggregations.author-aggregation.buckets", (int)0));
        }
    }

    @Test
    public void shouldNotPerformAggregationByAuthorKeywordWhenAccessToTheFieldIsNegated() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_EXCEPT_AUTHOR_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/documents/_search", AGGREGATION_BY_AUTHOR_QUERY, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            log.info("Response should NOT contain value of field author '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"aggregations.author-aggregation.buckets[0]", (String)"key")));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"aggregations.author-aggregation.buckets", (int)0));
        }
    }

    @Test
    public void shouldCheckFlsForEachRequestForEachUser() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_USER, new Header[0]);){
            response = client.postJson("/documents/_search", AGGREGATION_BY_AUTHOR_QUERY, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            log.info("Response should contain value of field author '{}'", (Object)response.getBody());
            String jsonPathFirstAggregationBucket = "aggregations.author-aggregation.buckets[0]";
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)jsonPathFirstAggregationBucket, (String)"key"));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DOCUMENT_READER_EXCEPT_AUTHOR_USER, new Header[0]);
        try {
            response = client.postJson("/documents/_search", AGGREGATION_BY_AUTHOR_QUERY, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"aggregations.author-aggregation.buckets[0]", (String)"key")));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"aggregations.author-aggregation.buckets", (int)0));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

