/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestDataStream;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FmIntTest {
    static final int DOC_COUNT = 200;
    public static final String SOURCE_IP = "102.101.145.140";
    static final TestData TEST_DATA = TestData.documentCount((int)200).timestampColumnName("@timestamp").deletedDocumentFraction(0.0).get();
    static final String INDEX = "index_logs";
    static final TestIndex TEST_INDEX = new TestIndex("index_logs", Settings.builder().put("index.number_of_shards", 5).build(), TEST_DATA);
    static final TestAlias TEST_ALIAS = new TestAlias("alias_logs", new TestIndexLike[]{TEST_INDEX});
    static final TestDataStream TEST_DATA_STREAM = new TestDataStream("web_data_stream_logs", TEST_DATA);
    static final Pattern HEX_HASH_PATTERN = Pattern.compile("[0-9a-f]{64}");
    static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+");
    static final Pattern LOCATION_PATTERN = Pattern.compile("[A-Za-z\u00f6\u00fc]+");
    static final TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).dataStreamPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})}).addFieldValueMatcher("hits.hits[*]._source.source_ip", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("_source.source_ip", false, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("hits.hits[*]._source.source_loc", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("aggregations.test_agg.buckets[*].key", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)LOCATION_PATTERN)}).addFieldValueMatcher("hits.total.value", false, new Matcher[]{Matchers.equalTo((Object)1)});
    static final TestSgConfig.User HASHED_IP_INDEX_USER = new TestSgConfig.User("hashed_ip_index_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hashed_ip_index_role").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).maskedFields(new String[]{"*_ip"}).on(new String[]{"index_logs"}).clusterPermissions(new String[]{"*"})}).addFieldValueMatcher("hits.hits[*]._source.source_ip", true, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN))}).addFieldValueMatcher("_source.source_ip", false, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN))}).addFieldValueMatcher("aggregations.test_agg.buckets[*].key", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)LOCATION_PATTERN)}).addFieldValueMatcher("hits.total.value", false, new Matcher[]{Matchers.equalTo((Object)0)});
    static final TestSgConfig.User HASHED_IP_ALIAS_USER = new TestSgConfig.User("hashed_ip_alias_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hashed_ip_alias_role").aliasPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get", "indices:data/read/get", "indices:data/read/search"}).maskedFields(new String[]{"*_ip"}).on(new String[]{TEST_ALIAS.getName()}).clusterPermissions(new String[]{"*"})}).addFieldValueMatcher("hits.hits[*]._source.source_ip", true, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN))}).addFieldValueMatcher("_source.source_ip", false, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN))}).addFieldValueMatcher("aggregations.test_agg.buckets[*].key", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)LOCATION_PATTERN)}).addFieldValueMatcher("hits.total.value", false, new Matcher[]{Matchers.equalTo((Object)0)});
    static final TestSgConfig.User HASHED_IP_DATA_STREAM_USER = new TestSgConfig.User("hashed_ip_data_stream_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hashed_ip_data_stream_role").dataStreamPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get", "indices:data/read/get"}).maskedFields(new String[]{"*_ip"}).on(new String[]{TEST_DATA_STREAM.getName()}).clusterPermissions(new String[]{"*"})}).addFieldValueMatcher("hits.hits[*]._source.source_ip", true, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN))}).addFieldValueMatcher("_source.source_ip", false, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN))}).addFieldValueMatcher("aggregations.test_agg.buckets[*].key", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)LOCATION_PATTERN)}).addFieldValueMatcher("hits.total.value", false, new Matcher[]{Matchers.equalTo((Object)0)});
    static final TestSgConfig.User HASHED_LOC_USER = new TestSgConfig.User("hashed_loc").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hashed_ip").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).maskedFields(new String[]{"*_loc"}).on(new String[]{"index_logs"}).dataStreamPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get", "indices:data/read/get"}).maskedFields(new String[]{"*_loc"}).on(new String[]{TEST_DATA_STREAM.getName()}).clusterPermissions(new String[]{"*"})}).addFieldValueMatcher("hits.hits[*]._source.source_ip", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("_source.source_ip", false, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("aggregations.test_agg.buckets[*].key", true, new Matcher[]{Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)LOCATION_PATTERN))}).addFieldValueMatcher("hits.total.value", false, new Matcher[]{Matchers.equalTo((Object)1)});
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().addFieldValueMatcher("hits.hits[*]._source.source_ip", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("_source.source_ip", false, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("hits.hits[*]._source.source_loc", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)IP_ADDRESS_PATTERN)}).addFieldValueMatcher("aggregations.test_agg.buckets[*].key", true, new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.matchesPattern((Pattern)LOCATION_PATTERN)}).addFieldValueMatcher("hits.total.value", false, new Matcher[]{Matchers.equalTo((Object)1)});
    static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls();
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).users(new TestSgConfig.User[]{ADMIN, HASHED_IP_INDEX_USER, HASHED_LOC_USER, HASHED_IP_ALIAS_USER, HASHED_IP_DATA_STREAM_USER, SUPER_UNLIMITED_USER}).indices(new TestIndex[]{TEST_INDEX}).aliases(new TestAlias[]{TEST_ALIAS}).indexTemplates(new TestIndexTemplate[]{new TestIndexTemplate("ds_test", new String[]{TEST_DATA_STREAM.getName() + "*"}).dataStream().composedOf(new TestComponentTemplate[]{TestComponentTemplate.DATA_STREAM_MINIMAL})}).dataStreams(new TestDataStream[]{TEST_DATA_STREAM}).resources("dlsfls").useExternalProcessCluster().build();
    private final TestIndexLike testIndexLike;
    private final TestSgConfig.User user;

    @Parameterized.Parameters(name="{0} {1}")
    public static Collection<Object[]> params() {
        return ImmutableList.of((Object)new Object[]{TEST_INDEX, HASHED_IP_INDEX_USER}, (Object)new Object[]{TEST_INDEX, ADMIN}, (Object)new Object[]{TEST_INDEX, SUPER_UNLIMITED_USER}, (Object[])new Object[][]{{TEST_INDEX, HASHED_LOC_USER}, {TEST_DATA_STREAM, HASHED_IP_DATA_STREAM_USER}, {TEST_DATA_STREAM, ADMIN}, {TEST_DATA_STREAM, SUPER_UNLIMITED_USER}, {TEST_DATA_STREAM, HASHED_LOC_USER}, {TEST_ALIAS, HASHED_IP_ALIAS_USER}, {TEST_ALIAS, ADMIN}, {TEST_ALIAS, SUPER_UNLIMITED_USER}, {TEST_ALIAS, HASHED_LOC_USER}});
    }

    public FmIntTest(TestIndexLike testIndexLike, TestSgConfig.User user) {
        this.testIndexLike = testIndexLike;
        this.user = user;
    }

    @Test
    public void search_hashed() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/" + this.testIndexLike.getName() + "/_search?pretty", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)this.user.matcherForField("hits.hits[*]._source.source_ip"));
        }
    }

    @Test
    public void get_hashed() throws Exception {
        String docId = TEST_DATA.anyDocument().getId();
        String docUrl = "/" + this.testIndexLike.getName() + "/_doc/" + docId + "?pretty";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get(docUrl, new Header[0]);
            if (this.testIndexLike instanceof TestDataStream) {
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isNotFound());
            } else {
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, (Matcher)this.user.matcherForField("_source.source_ip"));
            }
        }
    }

    @Test
    public void terms_aggregation() throws Exception {
        String query = "{\"query\" : {\"match_all\": {}},\"aggs\" : {\"test_agg\" : { \"terms\" : { \"field\" : \"source_loc.keyword\" } }}}";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/" + this.testIndexLike.getName() + "/_search?size=0&pretty", query, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)this.user.matcherForField("aggregations.test_agg.buckets[*].key"));
        }
    }

    @Test
    public void search_masked_terms() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/" + this.testIndexLike.getName() + "/_search?pretty&q=source_ip:102.101.145.140", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)this.user.matcherForField("hits.total.value"));
        }
    }
}

