/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchguard.enterprise.dlsfls.filter.DlsFilterLevelActionHandler;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class DlsFlsValve
implements SyncAuthorizationFilter,
ComponentStateProvider {
    private static final String MAP_EXECUTION_HINT = "map";
    private static final String DIRECT_EXECUTION_HINT = "direct";
    private static final Logger log = LogManager.getLogger(DlsFlsValve.class);
    private final Client nodeClient;
    private final ClusterService clusterService;
    private final GuiceDependencies guiceDependencies;
    private final ThreadContext threadContext;
    private final IndexNameExpressionResolver resolver;
    private final AtomicReference<DlsFlsProcessedConfig> config;
    private final ComponentState componentState = new ComponentState(0, null, "dls_fls_valve", DlsFlsValve.class).initialized();
    private final TimeAggregation applyTimeAggregation = new TimeAggregation.Nanoseconds();

    public DlsFlsValve(Client nodeClient, ClusterService clusterService, IndexNameExpressionResolver resolver, GuiceDependencies guiceDependencies, ThreadContext threadContext, AtomicReference<DlsFlsProcessedConfig> config) {
        this.nodeClient = nodeClient;
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.guiceDependencies = guiceDependencies;
        this.threadContext = threadContext;
        this.config = config;
        this.componentState.addMetrics("filter_request", (Measurement)this.applyTimeAggregation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncAuthorizationFilter.Result apply(PrivilegesEvaluationContext context, ActionListener<?> listener) {
        if (this.threadContext.getHeader("_sg_filter_level_dls_done") != null) {
            if (!log.isDebugEnabled()) return SyncAuthorizationFilter.Result.OK;
            log.debug("DLS is already done for: " + this.threadContext.getHeader("_sg_filter_level_dls_done"));
            return SyncAuthorizationFilter.Result.OK;
        }
        DlsFlsProcessedConfig config = this.config.get();
        try (Meter meter = Meter.detail((MetricsLevel)config.getMetricsLevel(), (Measurement)this.applyTimeAggregation);){
            SyncAuthorizationFilter.Result result;
            SearchSourceBuilder source;
            boolean doFilterLevelDls;
            RoleBasedDocumentAuthorization documentAuthorization = config.getDocumentAuthorization();
            RoleBasedFieldAuthorization fieldAuthorization = config.getFieldAuthorization();
            RoleBasedFieldMasking fieldMasking = config.getFieldMasking();
            DlsFlsConfig.Mode mode = config.getDlsFlsConfig().getDlsMode();
            this.blockAccessInCaseOfRoleOrMappingsConfigurationErrors();
            if (log.isDebugEnabled()) {
                log.debug("DlsFlsValveImpl.invoke()\nrequest: " + context.getRequest() + "\nresolved: " + context.getRequestInfo().getResolvedIndices() + "\nmode: " + mode);
            }
            ResolvedIndices resolvedIndices = context.getRequestInfo().getMainResolvedIndices();
            if (context.getSpecialPrivilegesEvaluationContext() != null && context.getSpecialPrivilegesEvaluationContext().getRolesConfig() != null) {
                SgDynamicConfiguration roles = context.getSpecialPrivilegesEvaluationContext().getRolesConfig();
                documentAuthorization = new RoleBasedDocumentAuthorization((SgDynamicConfiguration<Role>)roles, null, MetricsLevel.NONE);
                fieldAuthorization = new RoleBasedFieldAuthorization((SgDynamicConfiguration<Role>)roles, null, MetricsLevel.NONE);
                fieldMasking = new RoleBasedFieldMasking((SgDynamicConfiguration<Role>)roles, fieldMasking.getFieldMaskingConfig(), null, MetricsLevel.NONE);
            }
            boolean hasDlsRestrictions = documentAuthorization.hasRestrictions(context, resolvedIndices, meter);
            boolean hasFlsRestrictions = fieldAuthorization.hasRestrictions(context, resolvedIndices, meter);
            boolean hasFieldMasking = fieldMasking.hasRestrictions(context, resolvedIndices, meter);
            if (!(hasDlsRestrictions || hasFlsRestrictions || hasFieldMasking)) {
                SyncAuthorizationFilter.Result result2 = SyncAuthorizationFilter.Result.OK;
                return result2;
            }
            DlsRestriction.IndexMap restrictionMap = DlsRestriction.IndexMap.NONE;
            if (mode == DlsFlsConfig.Mode.FILTER_LEVEL) {
                doFilterLevelDls = true;
                restrictionMap = documentAuthorization.getRestriction(context, (Collection<Meta.Index>)Meta.IndexLikeObject.resolveDeep((ImmutableSet)resolvedIndices.getLocal().getUnion()), meter);
            } else if (mode == DlsFlsConfig.Mode.LUCENE_LEVEL) {
                doFilterLevelDls = false;
            } else {
                DlsFlsConfig.Mode modeByHeader = this.getDlsModeHeader();
                if (modeByHeader == DlsFlsConfig.Mode.FILTER_LEVEL) {
                    doFilterLevelDls = true;
                    restrictionMap = documentAuthorization.getRestriction(context, (Collection<Meta.Index>)Meta.IndexLikeObject.resolveDeep((ImmutableSet)resolvedIndices.getLocal().getUnion()), meter);
                    log.debug("Doing filter-level DLS due to header");
                } else {
                    restrictionMap = documentAuthorization.getRestriction(context, (Collection<Meta.Index>)Meta.IndexLikeObject.resolveDeep((ImmutableSet)resolvedIndices.getLocal().getUnion()), meter);
                    doFilterLevelDls = restrictionMap.containsTermLookupQuery();
                    if (doFilterLevelDls) {
                        this.setDlsModeHeader(DlsFlsConfig.Mode.FILTER_LEVEL);
                        log.debug("Doing filter-level DLS because query contains TLQ");
                    } else {
                        log.debug("Doing lucene-level DLS because query does not contain TLQ");
                    }
                }
            }
            Object request = context.getRequest();
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
            }
            if (request instanceof SearchRequest) {
                SearchRequest searchRequest = (SearchRequest)request;
                if (searchRequest.source() != null && searchRequest.source().aggregations() != null) {
                    for (AggregationBuilder factory : searchRequest.source().aggregations().getAggregatorFactories()) {
                        if (!(factory instanceof TermsAggregationBuilder) || ((TermsAggregationBuilder)factory).minDocCount() != 0L) continue;
                        if (!config.getDlsFlsConfig().isForceMinDocCountToOne()) {
                            SyncAuthorizationFilter.Result result3 = SyncAuthorizationFilter.Result.DENIED.reason("min_doc_count 0 is not supported when DLS is activated");
                            return result3;
                        }
                        log.debug("Forcing terms aggregation min doc count to 1");
                        ((TermsAggregationBuilder)factory).minDocCount(1L);
                    }
                }
                if (hasFieldMasking && searchRequest.source() != null && searchRequest.source().aggregations() != null) {
                    for (AggregationBuilder aggregationBuilder : searchRequest.source().aggregations().getAggregatorFactories()) {
                        if (aggregationBuilder instanceof TermsAggregationBuilder) {
                            ((TermsAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                        }
                        if (aggregationBuilder instanceof SignificantTermsAggregationBuilder) {
                            ((SignificantTermsAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                        }
                        if (aggregationBuilder instanceof DiversifiedAggregationBuilder) {
                            ((DiversifiedAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                        }
                        if (!(aggregationBuilder instanceof CardinalityAggregationBuilder)) continue;
                        ((CardinalityAggregationBuilder)aggregationBuilder).executionHint(DIRECT_EXECUTION_HINT);
                    }
                }
                searchRequest.requestCache(Boolean.FALSE);
            }
            if (hasDlsRestrictions && request instanceof SearchRequest && (source = ((SearchRequest)request).source()) != null && source.profile()) {
                SyncAuthorizationFilter.Result result4 = SyncAuthorizationFilter.Result.DENIED.reason("Profiling is not supported when DLS is activated");
                return result4;
            }
            if (doFilterLevelDls && !restrictionMap.isUnrestricted()) {
                result = DlsFilterLevelActionHandler.handle(context.getAction(), (ActionRequest)request, listener, restrictionMap, context.getRequestInfo().getResolvedIndices(), this.nodeClient, this.clusterService, this.guiceDependencies.getIndicesService(), this.resolver, this.threadContext);
                return result;
            }
            result = SyncAuthorizationFilter.Result.OK;
            return result;
        }
        catch (PrivilegesEvaluationException e) {
            log.error("Error while evaluating DLS/FLS privileges", (Throwable)e);
            this.componentState.addLastException("filter_request", (Throwable)e);
            return SyncAuthorizationFilter.Result.DENIED.reason(e.getMessage()).cause((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            log.error("Error while evaluating DLS/FLS privileges", (Throwable)e);
            this.componentState.addLastException("filter_request_u", (Throwable)e);
            throw e;
        }
    }

    private void blockAccessInCaseOfRoleOrMappingsConfigurationErrors() {
        DlsFlsProcessedConfig dlsFlsProcessedConfig = this.config.get();
        if (dlsFlsProcessedConfig != null && dlsFlsProcessedConfig.containsValidationError()) {
            log.error(dlsFlsProcessedConfig.getValidationErrorDescription());
            throw new ElasticsearchStatusException("Incorrect configuration of SearchGuard roles or roles mapping, please check the log file for more details. (" + dlsFlsProcessedConfig.getUniqueValidationErrorToken() + ")", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
    }

    private void setDlsModeHeader(DlsFlsConfig.Mode mode) {
        String modeString = mode.name();
        if (this.threadContext.getHeader("_sg_dls_mode") != null) {
            if (!modeString.equals(this.threadContext.getHeader("_sg_dls_mode"))) {
                log.warn("Cannot update DLS mode to " + mode + "; current: " + this.threadContext.getHeader("_sg_dls_mode"));
            }
        } else {
            this.threadContext.putHeader("_sg_dls_mode", modeString);
        }
    }

    private DlsFlsConfig.Mode getDlsModeHeader() {
        String modeString = this.threadContext.getHeader("_sg_dls_mode");
        if (modeString != null) {
            return DlsFlsConfig.Mode.valueOf(modeString);
        }
        return null;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

