/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.PitHolder;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DlsIntTest {
    static final int DOC_COUNT = 200;
    static final TestData TEST_DATA = TestData.documentCount((int)200).timestampColumnName("@timestamp").get();
    static final String INDEX_NAME_PREFIX = "logs";
    static final String INDEX_PATTERN = "logs*";
    static final String INDEX_NORMAL_MODE = "logs_normal_index_mode";
    static final String INDEX_LOGS_DB_MODE = "logs_logs_db_index_mode";
    static final TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_A_USER = new TestSgConfig.User("dept_a").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_a").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"logs*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_D_USER = new TestSgConfig.User("dept_d").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_d").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_d")).on(new String[]{"logs*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_D_TERMS_LOOKUP_USER = new TestSgConfig.User("dept_d_terms_lookup_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_d").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"terms", (Object)DocNode.of((String)"dept", (Object)DocNode.of((String)"index", (Object)"user_dept_terms_lookup", (String)"id", (Object)"${user.name}", (String)"path", (Object)"dept")))).on(new String[]{"logs*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).users(new TestSgConfig.User[]{ADMIN, DEPT_A_USER, DEPT_D_USER, DEPT_D_TERMS_LOOKUP_USER}).resources("dlsfls").useExternalProcessCluster().build();
    private final String indexName;

    @BeforeClass
    public static void setupTestData() throws Exception {
        Settings settings = Settings.builder().put("index.number_of_shards", 5).build();
        try (GenericRestClient adminCertRestClient = cluster.getAdminCertRestClient();){
            TEST_DATA.createIndex(adminCertRestClient, INDEX_NORMAL_MODE, settings);
            settings = Settings.builder().put("index.number_of_shards", 5).put("index.mode", "logsdb").build();
            TEST_DATA.createIndex(adminCertRestClient, INDEX_LOGS_DB_MODE, settings);
            adminCertRestClient.postJson("/user_dept_terms_lookup/_doc/dept_d_terms_lookup_user?refresh=true", (Map)DocNode.of((String)"dept", (Object)"dept_d"), new Header[0]);
            String indexMode = TestData.getIndexMode((GenericRestClient)adminCertRestClient, (String)INDEX_NORMAL_MODE);
            MatcherAssert.assertThat((Object)indexMode, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"normal"), (Matcher)Matchers.nullValue()));
            indexMode = TestData.getIndexMode((GenericRestClient)adminCertRestClient, (String)INDEX_LOGS_DB_MODE);
            MatcherAssert.assertThat((Object)indexMode, (Matcher)Matchers.equalTo((Object)"logsdb"));
        }
    }

    public DlsIntTest(String indexName) {
        this.indexName = indexName;
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[] parameters() {
        return new Object[]{INDEX_NORMAL_MODE, INDEX_LOGS_DB_MODE};
    }

    @Test
    public void get() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument testDocumentA1 = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        String documentUriA1 = "/" + this.indexName + "/_doc/" + testDocumentA1.getId();
        TestData.TestDocument testDocumentD = TEST_DATA.anyDocumentForDepartment("dept_d");
        String documentUriD = "/" + this.indexName + "/_doc/" + testDocumentD.getId();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);){
            response = client.get(documentUriA1, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)404L, (long)response.getStatusCode());
            response = client.get(documentUriD, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(documentUriA1, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void get_termsLookup() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument testDocumentA1 = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        TestData.TestDocument testDocumentD = TEST_DATA.anyDocumentForDepartment("dept_d");
        String documentUriA1 = "/" + this.indexName + "/_doc/" + testDocumentA1.getId();
        String documentUriD = "/" + this.indexName + "/_doc/" + testDocumentD.getId();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_TERMS_LOOKUP_USER, new Header[0]);){
            response = client.get(documentUriA1, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)404L, (long)response.getStatusCode());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_TERMS_LOOKUP_USER, new Header[0]);
        try {
            response = client.get(documentUriD, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(documentUriA1, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void mget() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument testDocumentA1 = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        TestData.TestDocument testDocumentD = TEST_DATA.anyDocumentForDepartment("dept_d");
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);){
            response = client.postJson("/" + this.indexName + "/_mget", (Map)DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_id", (Object)testDocumentA1.getId()), DocNode.of((String)"_id", (Object)testDocumentD.getId())})), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_a.*/)]").size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_d.*/)]").size() == 1 ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.postJson("/" + this.indexName + "/_mget", (Map)DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_id", (Object)testDocumentA1.getId()), DocNode.of((String)"_id", (Object)testDocumentD.getId())})), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_a.*/)]").size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_d.*/)]").size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void mget_termsLookup() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument testDocumentA1 = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        TestData.TestDocument testDocumentD = TEST_DATA.anyDocumentForDepartment("dept_d");
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_TERMS_LOOKUP_USER, new Header[0]);){
            response = client.postJson("/" + this.indexName + "/_mget", (Map)DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_id", (Object)testDocumentA1.getId()), DocNode.of((String)"_id", (Object)testDocumentD.getId())})), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_a.*/)]").size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_d.*/)]").size() == 1 ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.postJson("/" + this.indexName + "/_mget", (Map)DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_id", (Object)testDocumentA1.getId()), DocNode.of((String)"_id", (Object)testDocumentD.getId())})), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_a.*/)]").size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("docs[?(@._source.dept =~ /dept_d.*/)]").size() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_A_USER, new Header[0]);){
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_a.*/)]").size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_a.*/))]").size() == 0 ? 1 : 0) != 0);
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_a.*/))]").size() != 0 ? 1 : 0) != 0);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_withPit() throws Exception {
        GenericRestClient.HttpResponse response;
        PitHolder pitHolder;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_A_USER, new Header[0]);){
            pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");
            try {
                response = client.postJson("/_search?pretty", (Map)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId()), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_a.*/)]").size() == 10 ? 1 : 0) != 0);
                Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_a.*/))]").size() == 0 ? 1 : 0) != 0);
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");
            try {
                response = client.postJson("/_search?pretty", (Map)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId()), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_a.*/))]").size() != 0 ? 1 : 0) != 0);
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_termsLookup() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_TERMS_LOOKUP_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/" + this.indexName + "/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_d.*/)]").size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_d.*/))]").size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void search_suggest() throws Exception {
        GenericRestClient.HttpResponse response;
        DocNode query = DocNode.of((String)"suggest", (Object)DocNode.of((String)"suggestion", (Object)DocNode.of((String)"text", (Object)"rahnsthla", (String)"term.field", (Object)"source_loc")));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);){
            response = client.postJson("/" + this.indexName + "/_search?pretty", (Map)query, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.postJson("/" + this.indexName + "/_search?pretty", (Map)query, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_suggest_withPit() throws Exception {
        GenericRestClient.HttpResponse response;
        PitHolder pitHolder;
        DocNode query = DocNode.of((String)"suggest", (Object)DocNode.of((String)"suggestion", (Object)DocNode.of((String)"text", (Object)"rahnsthla", (String)"term.field", (Object)"source_loc")));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);){
            pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");
            try {
                response = client.postJson("/_search?pretty", (Map)query.with((Document)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId())), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");
            try {
                response = client.postJson("/_search?pretty", (Map)query.with((Document)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId())), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void scroll() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_A_USER, new Header[0]);){
            GenericRestClient.HttpResponse scrollResponse;
            int hits;
            GenericRestClient.HttpResponse response = client.get("/" + this.indexName + "/_search?scroll=1m&pretty=true&size=5", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_a.*/)]").size() == 5 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_a.*/))]").size() == 0 ? 1 : 0) != 0);
            System.out.println(response.getBody());
            String scrollId = response.getBodyAsDocNode().getAsString("_scroll_id");
            while ((hits = (scrollResponse = client.postJson("/_search/scroll?pretty=true", (Map)DocNode.of((String)"scroll", (Object)"1m", (String)"scroll_id", (Object)scrollId), new Header[0])).getBodyAsDocNode().getAsNode("hits").getAsListOfNodes("hits").size()) != 0) {
                Assert.assertTrue((String)scrollResponse.getBody(), (scrollResponse.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_a.*/)]").size() == hits ? 1 : 0) != 0);
                Assert.assertTrue((String)scrollResponse.getBody(), (scrollResponse.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_a.*/))]").size() == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void scroll_withPit() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_A_USER, new Header[0]);
             PitHolder pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");){
            GenericRestClient.HttpResponse response = client.postJson("/_search?scroll=1m&pretty=true&size=5", (Map)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId()), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)400L, (long)response.getStatusCode());
        }
    }

    @Test
    public void scroll_termsLookup() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_TERMS_LOOKUP_USER, new Header[0]);){
            GenericRestClient.HttpResponse scrollResponse;
            int hits;
            GenericRestClient.HttpResponse response = client.get("/" + this.indexName + "/_search?scroll=1m&pretty=true&size=5", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_d.*/)]").size() == 5 ? 1 : 0) != 0);
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_d.*/))]").size() == 0 ? 1 : 0) != 0);
            System.out.println(response.getBody());
            String scrollId = response.getBodyAsDocNode().getAsString("_scroll_id");
            while ((hits = (scrollResponse = client.postJson("/_search/scroll?pretty=true", (Map)DocNode.of((String)"scroll", (Object)"1m", (String)"scroll_id", (Object)scrollId), new Header[0])).getBodyAsDocNode().getAsNode("hits").getAsListOfNodes("hits").size()) != 0) {
                Assert.assertTrue((String)scrollResponse.getBody(), (scrollResponse.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(@._source.dept =~ /dept_d.*/)]").size() == hits ? 1 : 0) != 0);
                Assert.assertTrue((String)response.getBody(), (scrollResponse.getBodyAsDocNode().findNodesByJsonPath("hits.hits[?(!(@._source.dept =~ /dept_d.*/))]").size() == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void terms_aggregation() throws Exception {
        int a2count;
        int a1count;
        GenericRestClient.HttpResponse response;
        String query = "{\"query\" : {\"match_all\": {}},\"aggs\" : {\"test_agg\" : { \"terms\" : { \"field\" : \"dept.keyword\" } }}}";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            response = client.postJson("/" + this.indexName + "/_search?pretty", query, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("aggregations.test_agg.buckets[?(@.key == 'dept_d')]").size() == 1 ? 1 : 0) != 0);
            a1count = DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_1')].doc_count");
            a2count = DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_2')].doc_count");
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_A_USER, new Header[0]);
        try {
            response = client.postJson("/" + this.indexName + "/_search?pretty", query, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("aggregations.test_agg.buckets[?(@.key == 'dept_d')]").size() == 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)response.getBody(), (long)a1count, (long)DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_1')].doc_count"));
            Assert.assertEquals((String)response.getBody(), (long)a2count, (long)DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_2')].doc_count"));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void terms_aggregation_withPit() throws Exception {
        int a2count;
        int a1count;
        GenericRestClient.HttpResponse response;
        PitHolder pitHolder;
        DocNode query = DocNode.parse((Format)Format.JSON).from("{\"query\" : {\"match_all\": {}},\"aggs\" : {\"test_agg\" : { \"terms\" : { \"field\" : \"dept.keyword\" } }}}");
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");
            try {
                response = client.postJson("/_search?pretty", (Map)query.with((Document)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId())), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("aggregations.test_agg.buckets[?(@.key == 'dept_d')]").size() == 1 ? 1 : 0) != 0);
                a1count = DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_1')].doc_count");
                a2count = DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_2')].doc_count");
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_A_USER, new Header[0]);
        try {
            pitHolder = PitHolder.of((GenericRestClient)client).post("/" + this.indexName + "/_pit?keep_alive=1m");
            try {
                response = client.postJson("/_search?pretty", (Map)query.with((Document)DocNode.of((String)"pit.id", (Object)pitHolder.getPitId())), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertTrue((String)response.getBody(), (response.getBodyAsDocNode().findNodesByJsonPath("aggregations.test_agg.buckets[?(@.key == 'dept_d')]").size() == 0 ? 1 : 0) != 0);
                Assert.assertEquals((String)response.getBody(), (long)a1count, (long)DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_1')].doc_count"));
                Assert.assertEquals((String)response.getBody(), (long)a2count, (long)DlsIntTest.getInt(response, "aggregations.test_agg.buckets[?(@.key == 'dept_a_2')].doc_count"));
            }
            finally {
                if (pitHolder != null) {
                    pitHolder.close();
                }
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void termvectors() throws Exception {
        GenericRestClient.HttpResponse response;
        TestData.TestDocument doc = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        String docUrl = "/" + this.indexName + "/_termvectors/" + doc.getId() + "?pretty=true";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)true, (Object)response.getBodyAsDocNode().get("found"));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);
        try {
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)false, (Object)response.getBodyAsDocNode().get("found"));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        TestData.TestDocument allowedDoc = TEST_DATA.anyDocumentForDepartment("dept_d");
        String allowedDocUrl = "/" + this.indexName + "/_termvectors/" + allowedDoc.getId() + "?pretty=true";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);){
            GenericRestClient.HttpResponse response2 = client.get(allowedDocUrl, new Header[0]);
            Assert.assertEquals((String)response2.getBody(), (long)200L, (long)response2.getStatusCode());
            Assert.assertEquals((String)response2.getBody(), (Object)true, (Object)response2.getBodyAsDocNode().get("found"));
        }
    }

    @AfterClass
    public static void clusterState() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            System.out.println(client.get("/_searchguard/component/dlsfls/_health?pretty=true", new Header[0]).getBody());
        }
    }

    private static int getInt(GenericRestClient.HttpResponse response, String jsonPath) throws DocumentParseException, Format.UnknownDocTypeException {
        Object object = response.getBodyAsDocNode().findSingleNodeByJsonPath("aggregations.test_agg.buckets[?(@.key == 'dept_a_1')].doc_count").toBasicObject();
        if (object instanceof Collection) {
            object = ((Collection)object).iterator().next();
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new RuntimeException("Invalid value for " + jsonPath + ": " + object);
    }
}

