/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FmLogsDbIntTest {
    static final int DOC_COUNT = 200;
    static final TestData TEST_DATA;
    static final String INDEX_NAME = "logs";
    static final String INDEX_PATTERN = "logs*";
    static final Pattern HEX_HASH_PATTERN;
    static final Pattern IP_ADDRESS_PATTERN;
    static final TestSgConfig.User ADMIN;
    static final TestSgConfig.User HASHED_IP_USER;
    static final TestSgConfig.User HASHED_LOC_USER;
    static final TestSgConfig.Authc AUTHC;
    static final TestSgConfig.DlsFls DLSFLS;
    @ClassRule
    public static LocalCluster cluster;

    @BeforeClass
    public static void setupTestData() throws IOException {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            Settings settings = Settings.builder().put("index.number_of_shards", 5).put("index.mode", "logsdb").build();
            String indexMode = TEST_DATA.createIndex(client, INDEX_NAME, settings);
            MatcherAssert.assertThat((Object)indexMode, (Matcher)Matchers.equalTo((Object)"logsdb"));
        }
    }

    @Test
    public void search_hashed() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)HASHED_IP_USER, new Header[0]);){
            response = client.get("/logs/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[*]._source.source_ip").map(n -> n.toString()).forAllApplies(s -> HEX_HASH_PATTERN.matcher((CharSequence)s).matches()));
            Assert.assertFalse((String)response.getBody(), (boolean)response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[*]._source.source_ip").map(n -> n.toString()).forAllApplies(s -> IP_ADDRESS_PATTERN.matcher((CharSequence)s).matches()));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get("/logs/_search?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertFalse((String)response.getBody(), (boolean)response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[*]._source.source_ip").map(n -> n.toString()).forAllApplies(s -> HEX_HASH_PATTERN.matcher((CharSequence)s).matches()));
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[*]._source.source_ip").map(n -> n.toString()).forAllApplies(s -> IP_ADDRESS_PATTERN.matcher((CharSequence)s).matches()));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void get_hashed() throws Exception {
        GenericRestClient.HttpResponse response;
        String docId = TEST_DATA.anyDocument().getId();
        String docUrl = "/logs/_doc/" + docId + "?pretty";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)HASHED_IP_USER, new Header[0]);){
            response = client.get(docUrl, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)HEX_HASH_PATTERN.matcher(response.getBodyAsDocNode().getAsNode("_source").getAsString("source_ip")).matches());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(docUrl, new Header[0]);
            Assert.assertTrue((String)response.getBody(), (boolean)IP_ADDRESS_PATTERN.matcher(response.getBodyAsDocNode().getAsNode("_source").getAsString("source_ip")).matches());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void terms_aggregation() throws Exception {
        ImmutableList keys;
        GenericRestClient.HttpResponse response;
        String query = "{\"query\" : {\"match_all\": {}},\"aggs\" : {\"test_agg\" : { \"terms\" : { \"field\" : \"source_loc.keyword\" } }}}";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)HASHED_LOC_USER, new Header[0]);){
            response = client.postJson("/logs/_search?pretty", query, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            keys = response.getBodyAsDocNode().findNodesByJsonPath("aggregations.test_agg.buckets[*].key").map(docNode -> (String)docNode.toBasicObject());
            Assert.assertTrue((String)response.getBody(), (boolean)keys.forAllApplies(k -> k.matches("[0-9a-f]{64}")));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.postJson("/logs/_search?pretty", query, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            keys = response.getBodyAsDocNode().findNodesByJsonPath("aggregations.test_agg.buckets[*].key").map(docNode -> (String)docNode.toBasicObject());
            Assert.assertFalse((String)response.getBody(), (boolean)keys.forAllApplies(k -> k.matches("[0-9a-f]{64}")));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void search_masked_terms() throws Exception {
        GenericRestClient.HttpResponse response;
        String sourceIp = TEST_DATA.anyDocument().getContent().get("source_ip").toString();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            response = client.get("/logs/_search?pretty&q=source_ip:" + sourceIp, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            System.out.println(response.getBody());
            Assert.assertFalse((String)response.getBody(), (boolean)response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[*]").isEmpty());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)HASHED_IP_USER, new Header[0]);
        try {
            response = client.get("/logs/_search?pretty&q=source_ip:" + sourceIp, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            System.out.println(response.getBody());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBodyAsDocNode().findNodesByJsonPath("hits.hits[*]").isEmpty());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){

            public JsonProvider jsonProvider() {
                return BasicJsonPathDefaultConfiguration.defaultConfiguration().jsonProvider();
            }

            public Set<Option> options() {
                return BasicJsonPathDefaultConfiguration.defaultConfiguration().getOptions();
            }

            public MappingProvider mappingProvider() {
                return BasicJsonPathDefaultConfiguration.defaultConfiguration().mappingProvider();
            }
        });
        TEST_DATA = TestData.documentCount((int)200).seed(1).timestampColumnName("@timestamp").get();
        HEX_HASH_PATTERN = Pattern.compile("[0-9a-f]+");
        IP_ADDRESS_PATTERN = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+");
        ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
        HASHED_IP_USER = new TestSgConfig.User("hashed_ip").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hashed_ip").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).maskedFields(new String[]{"*_ip"}).on(new String[]{INDEX_PATTERN}).clusterPermissions(new String[]{"*"})});
        HASHED_LOC_USER = new TestSgConfig.User("hashed_loc").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hashed_ip").indexPermissions(new String[]{"SGS_READ", "indices:admin/mappings/get"}).maskedFields(new String[]{"*_loc"}).on(new String[]{INDEX_PATTERN}).clusterPermissions(new String[]{"*"})});
        AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
        DLSFLS = new TestSgConfig.DlsFls();
        cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).users(new TestSgConfig.User[]{ADMIN, HASHED_IP_USER, HASHED_LOC_USER}).resources("dlsfls").useExternalProcessCluster().build();
    }
}

