/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.meta.Meta;
import com.floragunn.searchsupport.queries.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.BaseTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={IndicesAndAliases_getRestriction.class, IndicesAndAliases_hasRestriction.class, DataStreams_getRestriction.class})
public class RoleBasedDocumentAuthorizationTest {
    static NamedXContentRegistry xContentRegistry = new NamedXContentRegistry((List)ImmutableList.of((Object)new NamedXContentRegistry.Entry(QueryBuilder.class, new ParseField("term", new String[0]), p -> TermQueryBuilder.fromXContent((XContentParser)p))));
    static ConfigurationRepository.Context parserContext = new ConfigurationRepository.Context(null, null, null, xContentRegistry, null);

    static SgDynamicConfiguration<Role> roleConfig(TestSgConfig.Role ... roles) throws ConfigValidationException {
        return TestSgConfig.Role.toActualRole((ConfigurationRepository.Context)parserContext, (TestSgConfig.Role[])roles);
    }

    static DiagnosingMatcher<DlsRestriction> isUnrestricted() {
        return new DiagnosingMatcher<DlsRestriction>(){

            public void describeTo(Description description) {
                description.appendText("A DlsRestriction object that has no restrictions");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof DlsRestriction)) {
                    mismatchDescription.appendValue(item).appendText(" is not a DlsRestriction object");
                    return false;
                }
                DlsRestriction dlsRestriction = (DlsRestriction)item;
                if (dlsRestriction.isUnrestricted()) {
                    return true;
                }
                mismatchDescription.appendText("The DlsRestriction object is not unrestricted:").appendValue((Object)dlsRestriction);
                return false;
            }
        };
    }

    static DiagnosingMatcher<DlsRestriction> isRestricted() {
        return new DiagnosingMatcher<DlsRestriction>(){

            public void describeTo(Description description) {
                description.appendText("A DlsRestriction object that has at least one restrictions");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof DlsRestriction)) {
                    mismatchDescription.appendValue(item).appendText(" is not a DlsRestriction object");
                    return false;
                }
                DlsRestriction dlsRestriction = (DlsRestriction)item;
                if (!dlsRestriction.isUnrestricted()) {
                    return true;
                }
                mismatchDescription.appendText("The DlsRestriction object is not restricted:").appendValue((Object)dlsRestriction);
                return false;
            }
        };
    }

    @SafeVarargs
    static DiagnosingMatcher<DlsRestriction> isRestricted(final Matcher<QueryBuilder> ... queries) {
        return new DiagnosingMatcher<DlsRestriction>(){

            public void describeTo(Description description) {
                description.appendText("A DlsRestriction object that has the restrictions: ").appendList("", "", ", ", Arrays.asList(queries));
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof DlsRestriction)) {
                    mismatchDescription.appendValue(item).appendText(" is not a DlsRestriction object");
                    return false;
                }
                DlsRestriction dlsRestriction = (DlsRestriction)item;
                if (dlsRestriction.isUnrestricted()) {
                    mismatchDescription.appendText("The DlsRestriction object is not restricted:").appendValue((Object)dlsRestriction);
                    return false;
                }
                HashSet<Matcher> subMatchers = new HashSet<Matcher>(Arrays.asList(queries));
                HashSet unmatchedQueries = new HashSet(dlsRestriction.getQueries());
                block0: for (Query query : dlsRestriction.getQueries()) {
                    for (Matcher subMatcher : subMatchers) {
                        if (!subMatcher.matches((Object)query.getQueryBuilder())) continue;
                        unmatchedQueries.remove(query);
                        subMatchers.remove(subMatcher);
                        continue block0;
                    }
                }
                if (unmatchedQueries.isEmpty() && subMatchers.isEmpty()) {
                    return true;
                }
                if (!unmatchedQueries.isEmpty()) {
                    mismatchDescription.appendText("The DlsRestriction contains unexpected queries:").appendValue(unmatchedQueries).appendText("\n");
                }
                if (!subMatchers.isEmpty()) {
                    mismatchDescription.appendText("The DlsRestriction does not contain expected queries: ").appendValue(subMatchers).appendText("\n");
                }
                return false;
            }
        };
    }

    static DiagnosingMatcher<DlsRestriction> isFullyRestricted() {
        return new DiagnosingMatcher<DlsRestriction>(){

            public void describeTo(Description description) {
                description.appendText("A DlsRestriction object that has full restrictions");
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof DlsRestriction)) {
                    mismatchDescription.appendValue(item).appendText(" is not a DlsRestriction object");
                    return false;
                }
                DlsRestriction dlsRestriction = (DlsRestriction)item;
                if (dlsRestriction.getQueries().size() != 0) {
                    for (Query query : dlsRestriction.getQueries()) {
                        if (query.getQueryBuilder().equals((Object)Query.MATCH_NONE.getQueryBuilder())) continue;
                        mismatchDescription.appendText("The DlsRestriction object is not fully restricted:").appendValue((Object)dlsRestriction);
                        return false;
                    }
                    return true;
                }
                mismatchDescription.appendText("The DlsRestriction object is not fully restricted:").appendValue((Object)dlsRestriction);
                return false;
            }
        };
    }

    static BaseMatcher<QueryBuilder> termQuery(final String field, final Object value) {
        return new BaseMatcher<QueryBuilder>(){

            public void describeTo(Description description) {
                description.appendText("A TermQueryBuilder object with ").appendValue((Object)field).appendText("=").appendValue(value);
            }

            public boolean matches(Object item) {
                if (!(item instanceof BaseTermQueryBuilder)) {
                    return false;
                }
                BaseTermQueryBuilder queryBuilder = (BaseTermQueryBuilder)item;
                return queryBuilder.fieldName().equals(field) && queryBuilder.value().equals(value);
            }
        };
    }

    static enum Statefulness {
        STATEFUL,
        NON_STATEFUL;

    }

    public static class IndicesSpec {
        final ImmutableList<String> indices;

        IndicesSpec(String ... indices) {
            this.indices = ImmutableList.ofArray((Object[])indices);
        }

        public String toString() {
            return this.indices.toString();
        }
    }

    public static class IndexSpec {
        final String index;

        IndexSpec(String index) {
            this.index = index;
        }

        public String toString() {
            return this.index;
        }
    }

    public static class UserSpec {
        final List<String> roles;
        final String description;
        final Map<String, Object> attributes = new HashMap<String, Object>();

        UserSpec(String description, String ... roles) {
            this.description = description;
            this.roles = Arrays.asList(roles);
        }

        UserSpec attribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        User buildUser() {
            return new User.Builder().name("test_user_" + this.description).attributes(this.attributes).build();
        }

        public String toString() {
            return this.description;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class DataStreams_getRestriction {
        static final Meta BASIC = Meta.Mock.dataStream((String)"datastream_a1").of(new String[]{".ds-datastream_a1_backing_0001", ".ds-datastream_a1_backing_0002"}).dataStream("datastream_a2").of(new String[]{".ds-datastream_a2_backing_0001", ".ds-datastream_a2_backing_0002"}).dataStream("datastream_b1").of(new String[]{".ds-datastream_b1_backing_0001", ".ds-datastream_b1_backing_0002"}).dataStream("datastream_b2").of(new String[]{".ds-datastream_b2_backing_0001", ".ds-datastream_b2_backing_0002"}).alias("alias_a").of(new String[]{"datastream_a1", "datastream_a2"});
        static final Meta.Index datastream_a1_backing = (Meta.Index)BASIC.getIndexOrLike(".ds-datastream_a1_backing_0001");
        static final Meta.Index datastream_a2_backing = (Meta.Index)BASIC.getIndexOrLike(".ds-datastream_a2_backing_0001");
        static final Meta.Index datastream_b1_backing = (Meta.Index)BASIC.getIndexOrLike(".ds-datastream_b1_backing_0001");
        final Statefulness statefulness;
        final UserSpec userSpec;
        final User user;
        final IndexSpec indexSpec;
        final Meta.Index index;
        final PrivilegesEvaluationContext context;

        @Test
        public void wildcard() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*"}), new TestSgConfig.Role("non_dls_role").dataStreamPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
            } else if (this.userSpec.roles.contains("dls_role_1")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
            } else if (this.userSpec.roles.contains("dls_role_2")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
            } else {
                Assert.fail((String)("Unhandled case " + String.valueOf(this.userSpec)));
            }
        }

        @Test
        public void wildcard_negation() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*", "-datastream_b*"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*", "-datastream_a*"}), new TestSgConfig.Role("non_dls_role").dataStreamPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == datastream_a1_backing || this.index == datastream_a2_backing) {
                if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            } else if (this.index == datastream_b1_backing) {
                if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
        }

        @Test
        public void indexPattern() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"datastream_a*"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"datastream_b*"}), new TestSgConfig.Role("non_dls_role").dataStreamPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == datastream_a1_backing || this.index == datastream_a2_backing) {
                if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            } else if (this.index == datastream_b1_backing) {
                if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
        }

        @Test
        public void indexPattern_negation() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"datastream_*", "-datastream_b*"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"datastream_*", "-datastream_a*"}), new TestSgConfig.Role("non_dls_role").dataStreamPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == datastream_a1_backing || this.index == datastream_a2_backing) {
                if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            } else if (this.index == datastream_b1_backing) {
                if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
        }

        @Test
        public void template() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"datastream_${user.attrs.attr_a}1"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"datastream_a*"}), new TestSgConfig.Role("non_dls_role").dataStreamPermissions(new String[]{"*"}).on(new String[]{"datastream_${user.attrs.attr_a}1"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            try {
                DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
                if (this.userSpec.roles.isEmpty()) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                } else if (this.index == datastream_a1_backing) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else if (this.userSpec.roles.contains("dls_role_1")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                    } else {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                    }
                } else if (this.index == datastream_a2_backing) {
                    if (this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                    }
                } else if (this.index == datastream_b1_backing) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
            catch (PrivilegesEvaluationException e) {
                if ((this.userSpec.roles.contains("non_dls_role") || this.userSpec.roles.contains("dls_role_1")) && !this.userSpec.attributes.containsKey("attr_a")) {
                    MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExpressionEvaluationException.class)));
                }
                Assert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
            }
        }

        @Test
        public void alias_static() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"datastream_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_a"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == datastream_a1_backing) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == datastream_a2_backing) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == datastream_b1_backing) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            }
        }

        @Test
        public void alias_template() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_${user.attrs.attr_a}"}), new TestSgConfig.Role("dls_role_2").dataStreamPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"datastream_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_${user.attrs.attr_a}"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            try {
                DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
                if (this.userSpec.roles.isEmpty()) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                } else if (this.index == datastream_a1_backing) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    } else if (this.userSpec.roles.contains("dls_role_1")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                    } else {
                        Assert.fail((String)("Unhandled case " + String.valueOf(this.userSpec)));
                    }
                } else if (this.index == datastream_a2_backing) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else if (this.userSpec.roles.contains("dls_role_1")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                    } else if (this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else {
                        Assert.fail((String)("Unhandled case " + String.valueOf(this.userSpec)));
                    }
                } else if (this.index == datastream_b1_backing) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
            catch (PrivilegesEvaluationException e) {
                if ((this.userSpec.roles.contains("non_dls_role") || this.userSpec.roles.contains("dls_role_1")) && !this.userSpec.attributes.containsKey("attr_a")) {
                    MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExpressionEvaluationException.class)));
                }
                Assert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
            }
        }

        @Test
        public void wildcardOnIndices() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
            } else if (this.userSpec.roles.contains("dls_role_1")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
            } else if (this.userSpec.roles.contains("dls_role_2")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
            }
        }

        @Parameterized.Parameters(name="{0}; {1}; {2}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (UserSpec userSpec : Arrays.asList(new UserSpec("non_dls_role", "non_dls_role"), new UserSpec("dls_role_1", "dls_role_1"), new UserSpec("dls_role_1 and dls_role_2", "dls_role_1", "dls_role_2"), new UserSpec("dls_role_1 and non_dls_role", "dls_role_1", "non_dls_role"), new UserSpec("non_dls_role, attributes", "non_dls_role").attribute("attr_a", "a"), new UserSpec("dls_role_1, attributes", "dls_role_1").attribute("attr_a", "a"), new UserSpec("dls_role_1 and dls_role_2, attributes", "dls_role_1", "dls_role_2").attribute("attr_a", "a"), new UserSpec("dls_role_1 and non_dls_role, attributes", "dls_role", "non_dls_role").attribute("attr_a", "a"), new UserSpec("no roles", new String[0]))) {
                for (IndexSpec indexSpec : Arrays.asList(new IndexSpec(datastream_a1_backing.name()), new IndexSpec(datastream_a2_backing.name()), new IndexSpec(datastream_b1_backing.name()))) {
                    for (Statefulness statefulness : Statefulness.values()) {
                        result.add(new Object[]{userSpec, indexSpec, statefulness});
                    }
                }
            }
            return result;
        }

        private RoleBasedDocumentAuthorization createSubject(SgDynamicConfiguration<Role> roleConfig) {
            return new RoleBasedDocumentAuthorization(roleConfig, (Meta)(this.statefulness == Statefulness.STATEFUL ? BASIC : null), MetricsLevel.NONE);
        }

        public DataStreams_getRestriction(UserSpec userSpec, IndexSpec indexSpec, Statefulness statefulness) {
            this.userSpec = userSpec;
            this.indexSpec = indexSpec;
            this.user = userSpec.buildUser();
            this.index = (Meta.Index)BASIC.getIndexOrLike(indexSpec.index);
            this.context = new PrivilegesEvaluationContext(this.user, false, ImmutableSet.of(userSpec.roles), null, null, true, null, null);
            this.statefulness = statefulness;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class IndicesAndAliases_hasRestriction {
        static final Meta BASIC = Meta.Mock.indices((String[])new String[]{"index_a1", "index_a2", "index_b1", "index_b2"}).alias("alias_a").of(new String[]{"index_a1", "index_a2"});
        static final Meta.Index index_a1 = (Meta.Index)BASIC.getIndexOrLike("index_a1");
        static final Meta.Index index_a2 = (Meta.Index)BASIC.getIndexOrLike("index_a2");
        static final Meta.Index index_b1 = (Meta.Index)BASIC.getIndexOrLike("index_b1");
        static final Meta.Alias alias_a = (Meta.Alias)BASIC.getIndexOrLike("alias_a");
        final Statefulness statefulness;
        final UserSpec userSpec;
        final User user;
        final IndicesSpec indicesSpec;
        final ResolvedIndices resolvedIndices;
        final PrivilegesEvaluationContext context;

        @Test
        public void wildcard() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void wildcard_negation() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*", "-index_b*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*", "-index_a*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void indexPattern() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"index_a*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_b*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = new RoleBasedDocumentAuthorization(roleConfig, BASIC, MetricsLevel.NONE);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void indexPattern_negation() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"index_*", "-index_b*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_*", "-index_a*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void template() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"index_${user.attrs.attr_a}1"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"index_${user.attrs.attr_a}1"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            try {
                boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
                if (this.userSpec.roles.contains("non_dls_role") && this.resolvedIndices.getLocal().getUnion().equals((Object)ImmutableSet.of((Object)index_a1)) && this.userSpec.attributes.containsKey("attr_a")) {
                    Assert.assertFalse((boolean)result);
                } else {
                    Assert.assertTrue((boolean)result);
                }
            }
            catch (PrivilegesEvaluationException e) {
                if ((this.userSpec.roles.contains("non_dls_role") || this.userSpec.roles.contains("dls_role_1")) && !this.userSpec.attributes.containsKey("attr_a")) {
                    MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExpressionEvaluationException.class)));
                }
                Assert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
            }
        }

        @Test
        public void alias_static() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_a"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role") && this.resolvedIndices.getLocal().getUnion().forAllApplies(i -> i instanceof Meta.Alias || !i.parentAliases().isEmpty())) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void alias_static_wildcardNonDls() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role") && this.resolvedIndices.getLocal().getUnion().forAllApplies(i -> !i.parentAliases().isEmpty() || i instanceof Meta.Alias)) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void alias_wildcard() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_a*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role") && this.resolvedIndices.getLocal().getUnion().forAllApplies(i -> i == alias_a || i.parentAliases().contains((Object)alias_a))) {
                Assert.assertFalse((boolean)result);
            } else {
                Assert.assertTrue((boolean)result);
            }
        }

        @Test
        public void alias_template() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_${user.attrs.attr_a}"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_${user.attrs.attr_a}"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            try {
                boolean result = subject.hasRestrictions(this.context, this.resolvedIndices, Meter.NO_OP);
                if (this.userSpec.roles.contains("non_dls_role") && this.userSpec.attributes.containsKey("attr_a") && this.resolvedIndices.getLocal().getUnion().forAllApplies(i -> i == alias_a || i.parentAliases().contains((Object)alias_a))) {
                    Assert.assertFalse((boolean)result);
                } else {
                    Assert.assertTrue((boolean)result);
                }
            }
            catch (PrivilegesEvaluationException e) {
                if ((this.userSpec.roles.contains("non_dls_role") || this.userSpec.roles.contains("dls_role_1")) && !this.userSpec.attributes.containsKey("attr_a")) {
                    MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExpressionEvaluationException.class)));
                }
                Assert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
            }
        }

        @Parameterized.Parameters(name="{0}; {1}; {2}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (UserSpec userSpec : Arrays.asList(new UserSpec("non_dls_role", "non_dls_role"), new UserSpec("dls_role_1", "dls_role_1"), new UserSpec("dls_role_1 and dls_role_2", "dls_role_1", "dls_role_2"), new UserSpec("dls_role_1 and non_dls_role", "dls_role_1", "non_dls_role"), new UserSpec("non_dls_role, attributes", "non_dls_role").attribute("attr_a", "a"), new UserSpec("dls_role_1, attributes", "dls_role_1").attribute("attr_a", "a"), new UserSpec("dls_role_1 and dls_role_2, attributes", "dls_role_1", "dls_role_2").attribute("attr_a", "a"), new UserSpec("dls_role_1 and non_dls_role, attributes", "dls_role", "non_dls_role").attribute("attr_a", "a"), new UserSpec("no roles", new String[0]))) {
                for (IndicesSpec indicesSpec : Arrays.asList(new IndicesSpec("index_a1"), new IndicesSpec("index_a2"), new IndicesSpec("index_b1"), new IndicesSpec("alias_a"), new IndicesSpec("index_a1", "index_a2"), new IndicesSpec("index_a1", "index_b1"), new IndicesSpec("alias_a", "index_b1"))) {
                    for (Statefulness statefulness : Statefulness.values()) {
                        result.add(new Object[]{userSpec, indicesSpec, statefulness});
                    }
                }
            }
            return result;
        }

        public IndicesAndAliases_hasRestriction(UserSpec userSpec, IndicesSpec indicesSpec, Statefulness statefulness) {
            this.userSpec = userSpec;
            this.indicesSpec = indicesSpec;
            this.user = userSpec.buildUser();
            this.resolvedIndices = ResolvedIndices.of((Meta)BASIC, (String[])((String[])indicesSpec.indices.toArray((Object[])new String[0])));
            this.context = new PrivilegesEvaluationContext(this.user, false, ImmutableSet.of(userSpec.roles), null, null, true, null, null);
            this.statefulness = statefulness;
        }

        private RoleBasedDocumentAuthorization createSubject(SgDynamicConfiguration<Role> roleConfig) {
            return new RoleBasedDocumentAuthorization(roleConfig, (Meta)(this.statefulness == Statefulness.STATEFUL ? BASIC : null), MetricsLevel.NONE);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class IndicesAndAliases_getRestriction {
        static final Meta BASIC = Meta.Mock.indices((String[])new String[]{"index_a1", "index_a2", "index_b1", "index_b2"}).alias("alias_a").of(new String[]{"index_a1", "index_a2"});
        static final Meta.Index index_a1 = (Meta.Index)BASIC.getIndexOrLike("index_a1");
        static final Meta.Index index_a2 = (Meta.Index)BASIC.getIndexOrLike("index_a2");
        static final Meta.Index index_b1 = (Meta.Index)BASIC.getIndexOrLike("index_b1");
        final Statefulness statefulness;
        final UserSpec userSpec;
        final User user;
        final IndexSpec indexSpec;
        final Meta.Index index;
        final PrivilegesEvaluationContext context;

        @Test
        public void wildcard() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
            } else if (this.userSpec.roles.contains("dls_role_1")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
            } else if (this.userSpec.roles.contains("dls_role_2")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else {
                Assert.fail((String)("Missing case for " + String.valueOf(this.userSpec)));
            }
        }

        @Test
        public void wildcard_negation() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"*", "-index_b*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"*", "-index_a*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == index_a1 || this.index == index_a2) {
                if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            } else if (this.index == index_b1) {
                if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
        }

        @Test
        public void indexPattern() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"index_a*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_b*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == index_a1 || this.index == index_a2) {
                if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            } else if (this.index == index_b1) {
                if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
        }

        @Test
        public void indexPattern_negation() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"index_*", "-index_b*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_*", "-index_a*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.contains("non_dls_role")) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
            } else if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == index_a1 || this.index == index_a2) {
                if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            } else if (this.index == index_b1) {
                if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
        }

        @Test
        public void template() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"index_${user.attrs.attr_a}1"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a*"}), new TestSgConfig.Role("non_dls_role").indexPermissions(new String[]{"*"}).on(new String[]{"index_${user.attrs.attr_a}1"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            try {
                DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
                if (this.userSpec.roles.isEmpty()) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                } else if (this.index == index_a1) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else if (this.userSpec.roles.contains("dls_role_1")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                    } else {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    }
                } else if (this.index == index_a2) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                    } else if (this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                    }
                } else if (this.index == index_b1) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
            catch (PrivilegesEvaluationException e) {
                if ((this.userSpec.roles.contains("non_dls_role") || this.userSpec.roles.contains("dls_role_1")) && !this.userSpec.attributes.containsKey("attr_a")) {
                    MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExpressionEvaluationException.class)));
                }
                Assert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
            }
        }

        @Test
        public void alias_static() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_a"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == index_a1) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == index_a2) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == index_b1) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            }
        }

        @Test
        public void alias_static_wildcardNonDls() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == index_a1) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == index_a2) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == index_b1) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            }
        }

        @Test
        public void alias_wildcard() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_a*"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_a*"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
            if (this.userSpec.roles.isEmpty()) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            } else if (this.index == index_a1) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == index_a2) {
                if (this.userSpec.roles.contains("non_dls_role")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else if (this.userSpec.roles.contains("dls_role_1")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                } else if (this.userSpec.roles.contains("dls_role_2")) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                } else {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                }
            } else if (this.index == index_b1) {
                MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
            }
        }

        @Test
        public void alias_template() throws Exception {
            SgDynamicConfiguration<Role> roleConfig = RoleBasedDocumentAuthorizationTest.roleConfig(new TestSgConfig.Role("dls_role_1").aliasPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r1")).on(new String[]{"alias_${user.attrs.attr_a}"}), new TestSgConfig.Role("dls_role_2").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_r2")).on(new String[]{"index_a2"}), new TestSgConfig.Role("non_dls_role").aliasPermissions(new String[]{"*"}).on(new String[]{"alias_${user.attrs.attr_a}"}));
            RoleBasedDocumentAuthorization subject = this.createSubject(roleConfig);
            try {
                DlsRestriction dlsRestriction = (DlsRestriction)subject.getRestriction(this.context, this.index, Meter.NO_OP);
                if (this.userSpec.roles.isEmpty()) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                } else if (this.index == index_a1) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    } else if (this.userSpec.roles.contains("dls_role_1")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                    } else {
                        Assert.fail((String)("Unhandled case " + String.valueOf(this.userSpec)));
                    }
                } else if (this.index == index_a2) {
                    if (this.userSpec.roles.contains("non_dls_role")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isUnrestricted());
                    } else if (this.userSpec.roles.contains("dls_role_1") && this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1"), RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else if (this.userSpec.roles.contains("dls_role_1")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r1")}));
                    } else if (this.userSpec.roles.contains("dls_role_2")) {
                        MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isRestricted(new Matcher[]{RoleBasedDocumentAuthorizationTest.termQuery("dept", "dept_r2")}));
                    } else {
                        Assert.fail((String)("Unhandled case " + String.valueOf(this.userSpec)));
                    }
                } else if (this.index == index_b1) {
                    MatcherAssert.assertThat((Object)dlsRestriction, RoleBasedDocumentAuthorizationTest.isFullyRestricted());
                }
            }
            catch (PrivilegesEvaluationException e) {
                if ((this.userSpec.roles.contains("non_dls_role") || this.userSpec.roles.contains("dls_role_1")) && !this.userSpec.attributes.containsKey("attr_a")) {
                    MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExpressionEvaluationException.class)));
                }
                Assert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
            }
        }

        @Parameterized.Parameters(name="{0}; {1}; {2}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (UserSpec userSpec : Arrays.asList(new UserSpec("non_dls_role", "non_dls_role"), new UserSpec("dls_role_1", "dls_role_1"), new UserSpec("dls_role_1 and dls_role_2", "dls_role_1", "dls_role_2"), new UserSpec("dls_role_1 and non_dls_role", "dls_role_1", "non_dls_role"), new UserSpec("non_dls_role, attributes", "non_dls_role").attribute("attr_a", "a"), new UserSpec("dls_role_1, attributes", "dls_role_1").attribute("attr_a", "a"), new UserSpec("dls_role_1 and dls_role_2, attributes", "dls_role_1", "dls_role_2").attribute("attr_a", "a"), new UserSpec("dls_role_1 and non_dls_role, attributes", "dls_role", "non_dls_role").attribute("attr_a", "a"), new UserSpec("no roles", new String[0]))) {
                for (IndexSpec indexSpec : Arrays.asList(new IndexSpec("index_a1"), new IndexSpec("index_a2"), new IndexSpec("index_b1"))) {
                    for (Statefulness statefulness : Statefulness.values()) {
                        result.add(new Object[]{userSpec, indexSpec, statefulness});
                    }
                }
            }
            return result;
        }

        public IndicesAndAliases_getRestriction(UserSpec userSpec, IndexSpec indexSpec, Statefulness statefulness) {
            this.userSpec = userSpec;
            this.indexSpec = indexSpec;
            this.user = userSpec.buildUser();
            this.index = (Meta.Index)BASIC.getIndexOrLike(indexSpec.index);
            this.context = new PrivilegesEvaluationContext(this.user, false, ImmutableSet.of(userSpec.roles), null, null, true, null, null);
            this.statefulness = statefulness;
        }

        private RoleBasedDocumentAuthorization createSubject(SgDynamicConfiguration<Role> roleConfig) {
            return new RoleBasedDocumentAuthorization(roleConfig, (Meta)(this.statefulness == Statefulness.STATEFUL ? BASIC : null), MetricsLevel.NONE);
        }
    }
}

