/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.meta.Meta;
import java.util.Collection;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={FieldMaskingRule.class, IndicesAndAliases_getRestriction.class})
public class RoleBasedFieldMaskingTest {
    public static final DlsFlsConfig.FieldMasking CUSTOM_CONFIG = new DlsFlsConfig.FieldMasking(DocNode.EMPTY, new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}, new byte[]{0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 8}, "confidential");

    public static Matcher<RoleBasedFieldMasking.FieldMaskingRule> maskedFields(final String ... fields) {
        return new TypeSafeDiagnosingMatcher<RoleBasedFieldMasking.FieldMaskingRule>(){
            {
                if (fields == null || fields.length == 0) {
                    throw new IllegalArgumentException("At least one field must be provided");
                }
            }

            public void describeTo(Description description) {
                description.appendText("Fields ");
                for (String fieldName : fields) {
                    description.appendValue((Object)fieldName).appendText(" ");
                }
                description.appendValue((Object)"should be masked");
            }

            protected boolean matchesSafely(RoleBasedFieldMasking.FieldMaskingRule rule, Description description) {
                boolean result = true;
                for (String fieldName : fields) {
                    if (!Objects.isNull(rule.get(fieldName))) continue;
                    description.appendText("Field ").appendValue((Object)fieldName).appendText(" is not masked. ");
                    result = false;
                }
                return result;
            }
        };
    }

    public static Matcher<RoleBasedFieldMasking.FieldMaskingRule> notMaskedFields(final String ... fields) {
        return new TypeSafeDiagnosingMatcher<RoleBasedFieldMasking.FieldMaskingRule>(){
            {
                if (fields == null || fields.length == 0) {
                    throw new IllegalArgumentException("At least one field must be provided");
                }
            }

            public void describeTo(Description description) {
                description.appendText("Fields ");
                for (String fieldName : fields) {
                    description.appendValue((Object)fieldName).appendText(" ");
                }
                description.appendValue((Object)"should not be masked");
            }

            protected boolean matchesSafely(RoleBasedFieldMasking.FieldMaskingRule rule, Description description) {
                boolean result = true;
                for (String fieldName : fields) {
                    if (rule.get(fieldName) == null) continue;
                    description.appendText("Field ").appendValue((Object)fieldName).appendText(" is masked. ");
                    result = false;
                }
                return result;
            }
        };
    }

    @RunWith(value=Parameterized.class)
    public static class IndicesAndAliases_getRestriction {
        static final Meta META = Meta.Mock.indices((String[])new String[]{"index_a1", "hr", "it"});
        static final Meta.Index INDEX_A1 = (Meta.Index)META.getIndexOrLike("index_a1");
        static final Meta.Index INDEX_HR = (Meta.Index)META.getIndexOrLike("hr");
        private final DlsFlsConfig.FieldMasking fieldMaskingConfig;

        public IndicesAndAliases_getRestriction(DlsFlsConfig.FieldMasking fieldMaskingConfig) {
            this.fieldMaskingConfig = fieldMaskingConfig;
        }

        @Parameterized.Parameters
        public static Object[] data() {
            return new Object[]{new Object[]{DlsFlsConfig.FieldMasking.DEFAULT}, new Object[]{CUSTOM_CONFIG}};
        }

        @Test
        public void wildcard() throws Exception {
            RoleBasedFieldMasking subject = this.buildRoleBasedFieldMasking(new TestSgConfig.Role("restricted_role_1").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a"}).on(new String[]{"*"}), new TestSgConfig.Role("restricted_role_2").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"b"}).on(new String[]{"*"}), new TestSgConfig.Role("non_restricted_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_1"), INDEX_A1, Meter.NO_OP);
            Assert.assertNotNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("a"));
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_2"), INDEX_A1, Meter.NO_OP);
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("a"));
            Assert.assertNotNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_1", "restricted_role_2"), INDEX_A1, Meter.NO_OP);
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("a"));
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("non_restricted_role"), INDEX_A1, Meter.NO_OP);
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("a"));
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_1", "non_restricted_role"), INDEX_A1, Meter.NO_OP);
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("a"));
            Assert.assertNull((String)fieldMaskingRule.toString(), (Object)fieldMaskingRule.get("b"));
        }

        private RoleBasedFieldMasking buildRoleBasedFieldMasking(TestSgConfig.Role ... roles) throws ConfigValidationException {
            SgDynamicConfiguration roleConfig = TestSgConfig.Role.toActualRole((TestSgConfig.Role[])roles);
            return new RoleBasedFieldMasking(roleConfig, this.fieldMaskingConfig, META, MetricsLevel.NONE);
        }

        @Test
        public void combine() throws ConfigValidationException, PrivilegesEvaluationException {
            RoleBasedFieldMasking subject = this.buildRoleBasedFieldMasking(new TestSgConfig.Role("masked_a_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_b_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"b"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_c_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"c"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_ab_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a", "b"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_bc_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"b", "c"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_ac_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a", "c"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_abc_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a", "b", "c"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_all_on_hr").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"*"}).on(new String[]{"hr"}), new TestSgConfig.Role("non_masked_on_hr").indexPermissions(new String[]{"*"}).on(new String[]{"hr"}), new TestSgConfig.Role("masked_salary_on_it").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"salary*"}).on(new String[]{"it"}), new TestSgConfig.Role("non_restricted_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}));
            RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "masked_salary_on_it"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "non_masked_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "non_masked_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "masked_bc_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "masked_a_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("a"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_ab_on_hr", "masked_b_on_hr", "masked_bc_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "c"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_ab_on_hr", "masked_bc_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "c"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "masked_c_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "masked_bc_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_ab_on_hr", "masked_abc_on_hr", "masked_bc_on_hr", "masked_ac_on_hr", "masked_a_on_hr", "masked_b_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_all_on_hr", "non_masked_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_abc_on_hr", "non_masked_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_ab_on_hr", "masked_ac_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("b", "c"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("a"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_ab_on_hr", "masked_ac_on_hr", "masked_salary_on_it"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("b", "c"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("a"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_a_on_hr", "masked_b_on_hr", "masked_c_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b", "c"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_a_on_hr", "masked_ab_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("b", "c"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("a"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_b_on_hr", "masked_bc_on_hr", "masked_salary_on_it"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "c"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("b"));
            fieldMaskingRule = (RoleBasedFieldMasking.FieldMaskingRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("masked_c_on_hr", "masked_ac_on_hr"), INDEX_HR, Meter.NO_OP);
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.notMaskedFields("a", "b"));
            MatcherAssert.assertThat((Object)fieldMaskingRule, RoleBasedFieldMaskingTest.maskedFields("c"));
        }

        private static PrivilegesEvaluationContext ctx(String ... roles) {
            return new PrivilegesEvaluationContext(new User.Builder().name("test_user").build(), false, ImmutableSet.ofArray((Object[])roles), null, null, true, null, null);
        }
    }

    public static class FieldMaskingRule {
        @Test
        public void singleRole_empty() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.SingleRole subject = new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT);
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowAll());
        }

        @Test
        public void singleRole_simple() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a", "b"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.SingleRole subject = new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT);
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("a"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("b"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("c"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("aa"));
        }

        @Test
        public void singleRole_pattern() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a*::/[0-9]{1,3}$/::XXX::/^[0-9]{1,3}/::***", "b*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.SingleRole subject = new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT);
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("a"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("b"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("c"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("aa"));
        }

        @Test
        public void singleRole_pattern_alg() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a*::SHA-1", "b*::SHA-512"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.SingleRole subject = new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT);
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("a"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("b"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("c"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("aa"));
        }

        @Test
        public void singleRole_pattern_customConfig() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a*", "b*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.SingleRole subject = new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role.getIndexPermissions().get(0), CUSTOM_CONFIG);
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("a"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("b"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("c"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("aa"));
        }

        @Test
        public void multiRole_simple() throws Exception {
            Role role1 = new TestSgConfig.Role("role1").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a", "c"}).on(new String[]{"*"}).toActualRole();
            Role role2 = new TestSgConfig.Role("role2").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"b", "c"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.MultiRole subject = new RoleBasedFieldMasking.FieldMaskingRule.MultiRole((Collection)ImmutableList.of((Object)new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role1.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT), (Object)new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role2.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT)));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertNull((String)subject.toString(), (Object)subject.get("a"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("b"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("c"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("aa"));
        }

        @Test
        public void multiRole_pattern() throws Exception {
            Role role1 = new TestSgConfig.Role("role1").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"a*", "c*"}).on(new String[]{"*"}).toActualRole();
            Role role2 = new TestSgConfig.Role("role2").indexPermissions(new String[]{"*"}).maskedFields(new String[]{"b*", "c*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldMasking.FieldMaskingRule.MultiRole subject = new RoleBasedFieldMasking.FieldMaskingRule.MultiRole((Collection)ImmutableList.of((Object)new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role1.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT), (Object)new RoleBasedFieldMasking.FieldMaskingRule.SingleRole((Role.Index)role2.getIndexPermissions().get(0), DlsFlsConfig.FieldMasking.DEFAULT)));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertNull((String)subject.toString(), (Object)subject.get("a"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("b"));
            Assert.assertNotNull((String)subject.toString(), (Object)subject.get("c"));
            Assert.assertNull((String)subject.toString(), (Object)subject.get("aa"));
        }
    }
}

