/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedAuthorizationBase;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.meta.Meta;
import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.util.encoders.Hex;

public class RoleBasedFieldMasking
extends RoleBasedAuthorizationBase<FieldMaskingRule.SingleRole, FieldMaskingRule> {
    private final DlsFlsConfig.FieldMasking fieldMaskingConfig;

    public RoleBasedFieldMasking(SgDynamicConfiguration<Role> roles, DlsFlsConfig.FieldMasking fieldMaskingConfig, Meta indexMetadata, MetricsLevel metricsLevel) {
        super(roles, indexMetadata, metricsLevel, (Role.Index rolePermissions) -> RoleBasedFieldMasking.roleToRule(rolePermissions, fieldMaskingConfig));
        this.fieldMaskingConfig = fieldMaskingConfig;
    }

    static FieldMaskingRule.SingleRole roleToRule(Role.Index rolePermissions, DlsFlsConfig.FieldMasking fieldMaskingConfig) {
        ImmutableList fmExpressions = rolePermissions.getMaskedFields();
        if (fmExpressions != null && !fmExpressions.isEmpty()) {
            return new FieldMaskingRule.SingleRole(rolePermissions, fieldMaskingConfig);
        }
        return null;
    }

    @Override
    protected FieldMaskingRule unrestricted() {
        return FieldMaskingRule.ALLOW_ALL;
    }

    @Override
    protected FieldMaskingRule fullyRestricted() {
        return FieldMaskingRule.MASK_ALL;
    }

    @Override
    protected FieldMaskingRule compile(PrivilegesEvaluationContext context, Collection<FieldMaskingRule.SingleRole> rules) throws PrivilegesEvaluationException {
        return new FieldMaskingRule.MultiRole(rules);
    }

    @Override
    protected String hasRestrictionsMetricName() {
        return "has_fm_restriction";
    }

    @Override
    protected String evaluateRestrictionsMetricName() {
        return "evaluate_fm_restriction";
    }

    @Override
    protected String componentName() {
        return "role_based_field_masking";
    }

    public DlsFlsConfig.FieldMasking getFieldMaskingConfig() {
        return this.fieldMaskingConfig;
    }

    public static abstract class FieldMaskingRule {
        public static final FieldMaskingRule ALLOW_ALL = new SingleRole((ImmutableList<Field>)ImmutableList.empty());
        public static final FieldMaskingRule MASK_ALL = new SingleRole((ImmutableList<Field>)ImmutableList.of((Object)new Field(Role.Index.FieldMaskingExpression.MASK_ALL, DlsFlsConfig.FieldMasking.DEFAULT)));

        public static FieldMaskingRule of(DlsFlsConfig.FieldMasking fieldMaskingConfig, String ... rules) throws ConfigValidationException {
            ImmutableList.Builder patterns = new ImmutableList.Builder();
            for (String rule : rules) {
                patterns.add((Object)new Role.Index.FieldMaskingExpression(rule));
            }
            return new SingleRole((ImmutableList<Field>)patterns.build().map(e -> new Field((Role.Index.FieldMaskingExpression)e, fieldMaskingConfig)));
        }

        public abstract Field get(String var1);

        public boolean isNotMasked(String field) {
            return this.get(field) == null;
        }

        public abstract boolean isAllowAll();

        static String stripKeywordSuffix(String field) {
            if (field.endsWith(".keyword")) {
                return field.substring(0, field.length() - ".keyword".length());
            }
            return field;
        }

        public static class SingleRole
        extends FieldMaskingRule {
            final Role.Index sourceIndex;
            final ImmutableList<Field> expressions;

            SingleRole(Role.Index sourceIndex, DlsFlsConfig.FieldMasking fieldMaskingConfig) {
                this.sourceIndex = sourceIndex;
                this.expressions = ImmutableList.of((Collection)sourceIndex.getMaskedFields().stream().map(e -> new Field((Role.Index.FieldMaskingExpression)e, fieldMaskingConfig)).collect(Collectors.toList()));
            }

            SingleRole(ImmutableList<Field> expressions) {
                this.sourceIndex = null;
                this.expressions = expressions;
            }

            @Override
            public Field get(String field) {
                return this.internalGet(SingleRole.stripKeywordSuffix(field));
            }

            private Field internalGet(String field) {
                for (Field expression : this.expressions) {
                    if (!expression.getPattern().matches(field)) continue;
                    return expression;
                }
                return null;
            }

            @Override
            public boolean isAllowAll() {
                return this.expressions.isEmpty();
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FM:*";
                }
                return "FM:" + String.valueOf(this.expressions);
            }
        }

        public static class Field {
            private final Role.Index.FieldMaskingExpression expression;
            private final byte[] salt;
            private final byte[] personalization;
            private final byte[] prefix;

            Field(Role.Index.FieldMaskingExpression expression, DlsFlsConfig.FieldMasking fieldMaskingConfig) {
                this.expression = expression;
                this.salt = fieldMaskingConfig.getSalt();
                this.personalization = fieldMaskingConfig.getPersonalization();
                this.prefix = fieldMaskingConfig.getPrefix() != null ? fieldMaskingConfig.getPrefix().getBytes() : null;
            }

            public Pattern getPattern() {
                return this.expression.getPattern();
            }

            public byte[] apply(byte[] value) {
                if (this.isDefault()) {
                    return this.blake2bHash(value);
                }
                return this.customHash(value);
            }

            public String apply(String value) {
                if (this.isDefault()) {
                    return this.blake2bHash(value);
                }
                return this.customHash(value);
            }

            public BytesRef apply(BytesRef value) {
                if (value == null) {
                    return null;
                }
                if (this.isDefault()) {
                    return this.blake2bHash(value);
                }
                return this.customHash(value);
            }

            public String toString() {
                return this.expression.toString();
            }

            private boolean isDefault() {
                return this.expression.getAlgo() == null && this.expression.getRegexReplacements() == null;
            }

            private byte[] customHash(byte[] in) {
                MessageDigest algo = this.expression.getAlgo();
                if (algo != null) {
                    if (this.prefix != null) {
                        return Bytes.concat((byte[][])new byte[][]{this.prefix, Hex.encode((byte[])algo.digest(in))});
                    }
                    return Hex.encode((byte[])algo.digest(in));
                }
                if (this.expression.getRegexReplacements() != null) {
                    String string = new String(in, StandardCharsets.UTF_8);
                    for (Role.Index.FieldMaskingExpression.RegexReplacement rr : this.expression.getRegexReplacements()) {
                        string = rr.getRegex().matcher(string).replaceAll(rr.getReplacement());
                    }
                    if (this.prefix != null) {
                        return Bytes.concat((byte[][])new byte[][]{this.prefix, string.getBytes(StandardCharsets.UTF_8)});
                    }
                    return string.getBytes(StandardCharsets.UTF_8);
                }
                throw new IllegalArgumentException();
            }

            private BytesRef customHash(BytesRef in) {
                BytesRef copy = BytesRef.deepCopyOf((BytesRef)in);
                return new BytesRef(this.customHash(copy.bytes));
            }

            private String customHash(String in) {
                return new String(this.customHash(in.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }

            private byte[] blake2bHash(byte[] in) {
                Blake2bDigest hash = new Blake2bDigest(null, 32, this.salt, this.personalization);
                hash.update(in, 0, in.length);
                byte[] out = new byte[hash.getDigestSize()];
                hash.doFinal(out, 0);
                if (this.prefix != null) {
                    return Bytes.concat((byte[][])new byte[][]{this.prefix, Hex.encode((byte[])out)});
                }
                return Hex.encode((byte[])out);
            }

            private BytesRef blake2bHash(BytesRef in) {
                BytesRef copy = BytesRef.deepCopyOf((BytesRef)in);
                return new BytesRef(this.blake2bHash(copy.bytes));
            }

            private String blake2bHash(String in) {
                return new String(this.blake2bHash(in.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
        }

        public static class MultiRole
        extends FieldMaskingRule {
            final ImmutableList<SingleRole> parts;
            final boolean allowAll;

            MultiRole(Collection<SingleRole> parts) {
                this.parts = ImmutableList.of(parts);
                this.allowAll = this.parts.forAnyApplies(p -> p.isAllowAll());
            }

            @Override
            public Field get(String field) {
                field = MultiRole.stripKeywordSuffix(field);
                Field masking = null;
                for (SingleRole part : this.parts) {
                    masking = part.get(field);
                    if (masking != null) continue;
                    return null;
                }
                return masking;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FM:*";
                }
                return "FM:" + String.valueOf(this.parts.map(p -> p.expressions));
            }
        }
    }
}

