/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.ConfigurationUpdater;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class InvalidRolesAndMappingConfigurationWithDisabledDlsTest {
    private static final Logger log = LogManager.getLogger(InvalidRolesAndMappingConfigurationWithDisabledDlsTest.class);
    private static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    private static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    private static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(new String[]{TestSgConfig.Role.ALL_ACCESS.getName()});
    public static final String LIMITED_ROLE_NAME = "limited-role";
    private static final TestSgConfig.User USER_LIMITED = new TestSgConfig.User("limited-user").roles(new String[]{"limited-role"});
    @ClassRule
    public static LocalCluster.Embedded CLUSTER = new LocalCluster.Builder().singleNode().authc(AUTHC).dlsFls(DLSFLS).roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS}).user(USER_ADMIN).user(USER_LIMITED).sslEnabled().embedded().build();
    private ConfigurationUpdater configurationUpdater;

    @Before
    public void beforeEach() {
        this.configurationUpdater = new ConfigurationUpdater(CLUSTER, USER_ADMIN);
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsInvalidIndexPattern() throws Exception {
        TestSgConfig.Role roleInvalidIndexPattern = new TestSgConfig.Role("invalid-role-index").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).fls(new String[]{"~secret"}).on(new String[]{"/index-(.+/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleInvalidIndexPattern, client -> client.get("/*/_search", new Header[0]));
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
    }
}

