/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.meta.Meta;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={FlsRule.class, IndicesAndAliases_getRestriction.class})
public class RoleBasedFieldAuthorizationTest {

    public static class IndicesAndAliases_getRestriction {
        static final Meta META = Meta.Mock.indices((String[])new String[]{"index_a1"});
        static final Meta.Index index_a1 = (Meta.Index)META.getIndexOrLike("index_a1");

        @Test
        public void wildcard() throws Exception {
            SgDynamicConfiguration roleConfig = TestSgConfig.Role.toActualRole((TestSgConfig.Role[])new TestSgConfig.Role[]{new TestSgConfig.Role("restricted_role_1").indexPermissions(new String[]{"*"}).fls(new String[]{"a"}).on(new String[]{"*"}), new TestSgConfig.Role("restricted_role_2").indexPermissions(new String[]{"*"}).fls(new String[]{"b"}).on(new String[]{"*"}), new TestSgConfig.Role("non_restricted_role").indexPermissions(new String[]{"*"}).on(new String[]{"*"})});
            RoleBasedFieldAuthorization subject = new RoleBasedFieldAuthorization(roleConfig, META, MetricsLevel.NONE);
            RoleBasedFieldAuthorization.FlsRule flsRule = (RoleBasedFieldAuthorization.FlsRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_1"), index_a1, Meter.NO_OP);
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("a"));
            Assert.assertFalse((String)flsRule.toString(), (boolean)flsRule.isAllowed("b"));
            flsRule = (RoleBasedFieldAuthorization.FlsRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_2"), index_a1, Meter.NO_OP);
            Assert.assertFalse((String)flsRule.toString(), (boolean)flsRule.isAllowed("a"));
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("b"));
            flsRule = (RoleBasedFieldAuthorization.FlsRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_1", "restricted_role_2"), index_a1, Meter.NO_OP);
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("a"));
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("b"));
            flsRule = (RoleBasedFieldAuthorization.FlsRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("non_restricted_role"), index_a1, Meter.NO_OP);
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("a"));
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("b"));
            flsRule = (RoleBasedFieldAuthorization.FlsRule)subject.getRestriction(IndicesAndAliases_getRestriction.ctx("restricted_role_1", "non_restricted_role"), index_a1, Meter.NO_OP);
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("a"));
            Assert.assertTrue((String)flsRule.toString(), (boolean)flsRule.isAllowed("b"));
        }

        private static PrivilegesEvaluationContext ctx(String ... roles) {
            return new PrivilegesEvaluationContext(new User.Builder().name("test_user").build(), false, ImmutableSet.ofArray((Object[])roles), null, null, true, null, null);
        }
    }

    public static class FlsRule {
        @Test
        public void singleRole_empty() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowAll());
        }

        @Test
        public void singleRole_simple_positive() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"a", "b"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("b"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("c"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("aa"));
        }

        @Test
        public void singleRole_pattern_positive() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"a*", "b*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("b"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("c"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("aa"));
        }

        @Test
        public void singleRole_pattern_negation() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"~a*", "~b*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("b"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("c"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("aa"));
        }

        @Test
        public void singleRole_full_negation() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"~*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed(""));
        }

        @Test
        public void singleRole_mixed() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"a*", "~a1*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a2"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("b"));
        }

        @Test
        public void singleRole_mixed_objects() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"~object", "object.a*", "~object.a1*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.allowed"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.disallowed"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.a1_not_allowed"));
        }

        @Test
        public void singleRole_subobjects() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"object"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.allowed"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.also.allowed"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_not_allowed"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("objects"));
        }

        @Test
        public void singleRole_subobjects_not_grant_parent_access() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"object.child.grandchild"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild"));
        }

        @Test
        public void singleRole_subobjects_allow_parent_access_on_exclusion() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"~object.child.grandchild"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild"));
        }

        @Test
        public void singleRole_subobjects_exclusion_and_inclusions_on_various_levels_allowed_start() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"object*", "~object_top_secret*", "~object.child*", "object.child.grandchild*", "~object.child.grandchild.leaf*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("o"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.allowed_because_not_excluded"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret.child"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret.child1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret.child1.subchild"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child_1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child_2"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.child"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child_3.child"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grand"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grand"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild_1"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchildleaf"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.a.b"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.a.b.c"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf_1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf_2"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf_2.a.b.c"));
        }

        @Test
        public void singleRole_subobjects_exclusion_and_inclusions_on_various_levels_disallowed_start() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"~object*", "object_top_secret*", "object.child*", "~object.child.grandchild*", "object.child.grandchild.leaf*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("o"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.allowed_because_not_excluded"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object_top"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret1"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret1"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret.child"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret.child1"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object_top_secret.child1.subchild"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child_1"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child_2"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.child"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child_3.child"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grand"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grand"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild_1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchildleaf"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.a"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.a.b"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.a.b.c"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf_1"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf_2"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("object.child.grandchild.leaf_2.a.b.c"));
        }

        @Test
        public void singleRole_field_access_exceptions() throws Exception {
            Role role = new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).fls(new String[]{"a*", "~a1*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.SingleRole subject = new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role.getIndexPermissions().get(0));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("b"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("abc"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a123"));
        }

        @Test
        public void multiRole_simple_positive() throws Exception {
            Role role1 = new TestSgConfig.Role("role1").indexPermissions(new String[]{"*"}).fls(new String[]{"a"}).on(new String[]{"*"}).toActualRole();
            Role role2 = new TestSgConfig.Role("role2").indexPermissions(new String[]{"*"}).fls(new String[]{"b"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.MultiRole subject = new RoleBasedFieldAuthorization.FlsRule.MultiRole(ImmutableList.of((Object)new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role1.getIndexPermissions().get(0)), (Object)new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role2.getIndexPermissions().get(0))));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowAll());
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("b"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("c"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("aa"));
        }

        @Test
        public void multiRole_simple_negative_distinct() throws Exception {
            Role role1 = new TestSgConfig.Role("role1").indexPermissions(new String[]{"*"}).fls(new String[]{"~a"}).on(new String[]{"*"}).toActualRole();
            Role role2 = new TestSgConfig.Role("role2").indexPermissions(new String[]{"*"}).fls(new String[]{"~b"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.MultiRole subject = new RoleBasedFieldAuthorization.FlsRule.MultiRole(ImmutableList.of((Object)new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role1.getIndexPermissions().get(0)), (Object)new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role2.getIndexPermissions().get(0))));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("b"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("c"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("aa"));
        }

        @Test
        public void multiRole_pattern_negative_overlapping() throws Exception {
            Role role1 = new TestSgConfig.Role("role1").indexPermissions(new String[]{"*"}).fls(new String[]{"~a*"}).on(new String[]{"*"}).toActualRole();
            Role role2 = new TestSgConfig.Role("role2").indexPermissions(new String[]{"*"}).fls(new String[]{"~a1*"}).on(new String[]{"*"}).toActualRole();
            RoleBasedFieldAuthorization.FlsRule.MultiRole subject = new RoleBasedFieldAuthorization.FlsRule.MultiRole(ImmutableList.of((Object)new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role1.getIndexPermissions().get(0)), (Object)new RoleBasedFieldAuthorization.FlsRule.SingleRole((Role.Index)role2.getIndexPermissions().get(0))));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a"));
            Assert.assertTrue((String)subject.toString(), (boolean)subject.isAllowed("a2"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a1"));
            Assert.assertFalse((String)subject.toString(), (boolean)subject.isAllowed("a12"));
        }
    }
}

