/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import org.apache.lucene.util.BytesRef;
import org.junit.Assert;
import org.junit.Test;

public class FieldMaskingRuleTest {
    @Test
    public void field_defaultHash_bytes() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field"), DlsFlsConfig.FieldMasking.DEFAULT);
        Assert.assertArrayEquals((byte[])"45b7d14f1b22aedaf7ff3895b78b86511f5355e45a67f5206af56762fe8f5d30".getBytes(), (byte[])field.apply("foobar".getBytes()));
    }

    @Test
    public void field_defaultHash_bytesref() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field"), DlsFlsConfig.FieldMasking.DEFAULT);
        Assert.assertEquals((Object)new BytesRef("45b7d14f1b22aedaf7ff3895b78b86511f5355e45a67f5206af56762fe8f5d30".getBytes()), (Object)field.apply(new BytesRef("foobar".getBytes())));
    }

    @Test
    public void field_defaultHash_prefix() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field"), DlsFlsConfig.FieldMasking.parse((DocNode)DocNode.of((String)"prefix", (Object)"my_prefix_"), null));
        Assert.assertEquals((Object)"my_prefix_45b7d14f1b22aedaf7ff3895b78b86511f5355e45a67f5206af56762fe8f5d30", (Object)field.apply("foobar"));
    }

    @Test
    public void field_customHash() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field::SHA-512"), DlsFlsConfig.FieldMasking.DEFAULT);
        Assert.assertEquals((Object)"0a50261ebd1a390fed2bf326f2673c145582a6342d523204973d0219337f81616a8069b012587cf5635f6925f1b56c360230c19b273500ee013e030601bf2425", (Object)field.apply("foobar"));
    }

    @Test
    public void field_customHash_bytes() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field::SHA-512"), DlsFlsConfig.FieldMasking.DEFAULT);
        Assert.assertArrayEquals((byte[])"0a50261ebd1a390fed2bf326f2673c145582a6342d523204973d0219337f81616a8069b012587cf5635f6925f1b56c360230c19b273500ee013e030601bf2425".getBytes(), (byte[])field.apply("foobar".getBytes()));
    }

    @Test
    public void field_customHash_bytesref() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field::SHA-512"), DlsFlsConfig.FieldMasking.DEFAULT);
        Assert.assertEquals((Object)new BytesRef("0a50261ebd1a390fed2bf326f2673c145582a6342d523204973d0219337f81616a8069b012587cf5635f6925f1b56c360230c19b273500ee013e030601bf2425".getBytes()), (Object)field.apply(new BytesRef("foobar".getBytes())));
    }

    @Test
    public void field_customHash_prefix() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field::SHA-512"), DlsFlsConfig.FieldMasking.parse((DocNode)DocNode.of((String)"prefix", (Object)"my_prefix_"), null));
        Assert.assertEquals((Object)"my_prefix_0a50261ebd1a390fed2bf326f2673c145582a6342d523204973d0219337f81616a8069b012587cf5635f6925f1b56c360230c19b273500ee013e030601bf2425", (Object)field.apply("foobar"));
    }

    @Test
    public void field_customHash_prefixRegexpWithoutAlg() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("field::/ba.?/::***confidential***"), DlsFlsConfig.FieldMasking.parse((DocNode)DocNode.of((String)"prefix", (Object)"my_prefix_"), null));
        Assert.assertEquals((Object)"my_prefix_foo***confidential***", (Object)field.apply("foobar"));
    }

    @Test
    public void field_replace() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = new RoleBasedFieldMasking.FieldMaskingRule.Field(new Role.Index.FieldMaskingExpression("ip_source::/[0-9]{1,3}$/::XXX::/^[0-9]{1,3}/::***"), DlsFlsConfig.FieldMasking.DEFAULT);
        Assert.assertEquals((Object)"***.0.0.XXX", (Object)field.apply("127.0.0.1"));
    }
}

