/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.ConfigurationUpdater;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class InvalidRolesAndMappingConfigurationTest {
    private static final Logger log = LogManager.getLogger(InvalidRolesAndMappingConfigurationTest.class);
    private static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    private static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    private static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(new String[]{TestSgConfig.Role.ALL_ACCESS.getName()});
    public static final String LIMITED_ROLE_NAME = "limited-role";
    private static final TestSgConfig.User USER_LIMITED = new TestSgConfig.User("limited-user").roles(new String[]{"limited-role"});
    private static final TestSgConfig.Role ROLE_VALID = new TestSgConfig.Role("valid-role").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).fls(new String[]{"~secret"}).on(new String[]{"index*"});
    private static final TestSgConfig.Role ROLE_USED_WITH_INCORRECT_MAPPING = new TestSgConfig.Role("invalid-mapping-role").clusterPermissions(new String[]{"*"});
    private static final String ERROR_TYPE = "status_exception";
    @ClassRule
    public static LocalCluster.Embedded CLUSTER = new LocalCluster.Builder().singleNode().authc(AUTHC).dlsFls(DLSFLS).roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS}).user(USER_ADMIN).user(USER_LIMITED).sslEnabled().enterpriseModulesEnabled().embedded().build();
    private ConfigurationUpdater configurationUpdater;

    @Before
    public void beforeEach() {
        this.configurationUpdater = new ConfigurationUpdater(CLUSTER, USER_ADMIN);
    }

    @Test
    public void shouldPerformSearchWhenConfigurationIsValid() throws Exception {
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(ROLE_VALID, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsInvalidIndexPattern() throws Exception {
        TestSgConfig.Role roleInvalidIndexPattern = new TestSgConfig.Role("invalid-role-index").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).fls(new String[]{"~secret"}).on(new String[]{"/index-(.+/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleInvalidIndexPattern, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsInvalidPermissionPattern() throws Exception {
        TestSgConfig.Role roleWithInvalidPermission = new TestSgConfig.Role("invalid-role-permission").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"/permission-(.+/"}).fls(new String[]{"~secret"}).on(new String[]{"index"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleWithInvalidPermission, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsDefinedDlsAndInvalidIndexPattern() throws Exception {
        TestSgConfig.Role roleWithDlsIncorrectIndexPattern = new TestSgConfig.Role("invalid-role-dls-index-pattern").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).dls("{\"match\":{\"country_code\":\"ad\"}}").fls(new String[]{"~secret"}).on(new String[]{"/index(.+/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleWithDlsIncorrectIndexPattern, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsIncorrectJsonInDlsQuery() throws Exception {
        TestSgConfig.Role roleWithIncorrectDlsJsonQuery = new TestSgConfig.Role("invalid-role-dls-incorrect-json").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).dls("{\"match\":{\"country_code\":ad}").fls(new String[]{"~secret"}).on(new String[]{"index"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleWithIncorrectDlsJsonQuery, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsIncorrectDlsQuery() throws Exception {
        TestSgConfig.Role roleWithIncorrectDlsQuery = new TestSgConfig.Role("invalid-role-incorrect-dls-query").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"indices:data/read/search*", "indices:monitor/*"}).dls("{\"term\":{}}").fls(new String[]{"~secret"}).on(new String[]{"index"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleWithIncorrectDlsQuery, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenRoleContainsIncorrectFlsPattern() throws Exception {
        TestSgConfig.Role roleWithIncorrectFlsPattern = new TestSgConfig.Role("invalid-role-fls-pattern").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"indices:data/read/search*", "indices:monitor/*"}).dls("{\"match\":{\"country_code\":\"ad\"}}").fls(new String[]{"/public-(.+/"}).on(new String[]{"index"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleWithIncorrectFlsPattern, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldPerformSearchWhenConfigurationWithRolesAndMappingsIsValid() throws Exception {
        TestSgConfig.RoleMapping roleMappingsValid = new TestSgConfig.RoleMapping(ROLE_VALID.getName()).backendRoles(new String[]{"accountant"}).ips(new String[]{"192.178.1.5"}).hosts(new String[]{"*.search-guard.com"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithMapping(roleMappingsValid, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    public void shouldReportConfigurationErrorWhenMappingContainInvalidPatternInBackendRoleName() throws Exception {
        TestSgConfig.RoleMapping roleMappingsInvalidBackendRolePattern = new TestSgConfig.RoleMapping(ROLE_USED_WITH_INCORRECT_MAPPING.getName()).backendRoles(new String[]{"/accountant(.+/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithMapping(roleMappingsInvalidBackendRolePattern, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenMappingContainInvalidPatternInUsername() throws Exception {
        TestSgConfig.RoleMapping roleMappingsInvalidUserPattern = new TestSgConfig.RoleMapping(ROLE_USED_WITH_INCORRECT_MAPPING.getName()).users(new String[]{"/admin-(.+/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithMapping(roleMappingsInvalidUserPattern, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenMappingContainInvalidIpAddress() throws Exception {
        TestSgConfig.RoleMapping roleMappingsInvalidIpAddress = new TestSgConfig.RoleMapping(ROLE_USED_WITH_INCORRECT_MAPPING.getName()).ips(new String[]{"this is not an IP address!"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithMapping(roleMappingsInvalidIpAddress, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportConfigurationErrorWhenMappingContainInvalidHostPattern() throws Exception {
        TestSgConfig.RoleMapping roleMappingsInvalidHostPattern = new TestSgConfig.RoleMapping(ROLE_USED_WITH_INCORRECT_MAPPING.getName()).hosts(new String[]{"/(.+search-guard.com/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithMapping(roleMappingsInvalidHostPattern, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        });
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldReportMultipleErrorsWhenConfigurationIsInvalid() throws Exception {
        TestSgConfig.RoleMapping roleMappingsInvalidHostPattern = new TestSgConfig.RoleMapping(ROLE_USED_WITH_INCORRECT_MAPPING.getName()).hosts(new String[]{"/(.+search-guard.com/"});
        TestSgConfig.Role roleWithInvalidPermission = new TestSgConfig.Role("invalid-role-permission").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"/permission-(.+/"}).fls(new String[]{"~secret"}).on(new String[]{"index"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithMapping(roleMappingsInvalidHostPattern, unused -> (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleWithInvalidPermission, client -> {
            InvalidRolesAndMappingConfigurationTest.assertThatUserCanAuthenticate(client);
            return InvalidRolesAndMappingConfigurationTest.searchAll(client);
        }));
        InvalidRolesAndMappingConfigurationTest.assertThatSearchIsRejectedDueToIncorrectConfiguration(response);
    }

    @Test
    public void shouldRestoreAccessWhenConfigurationIsCorrected() throws Exception {
        TestSgConfig.Role roleInvalidIndexPattern = new TestSgConfig.Role("invalid-role-index").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).fls(new String[]{"~secret"}).on(new String[]{"/index-(.+/"});
        GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)this.configurationUpdater.callWithRole(roleInvalidIndexPattern, InvalidRolesAndMappingConfigurationTest::searchAll);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
        try (GenericRestClient client = CLUSTER.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            response = InvalidRolesAndMappingConfigurationTest.searchAll(client);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    private static void assertThatSearchIsRejectedDueToIncorrectConfiguration(GenericRestClient.HttpResponse response) throws Exception {
        log.info("Search response body '{}'", (Object)response.getBody());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
        DocNode body = response.getBodyAsDocNode();
        MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.error.type", (Object)ERROR_TYPE));
        MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containSubstring((String)"$.error.reason", (String)"Incorrect configuration of SearchGuard roles or roles mapping, please check the log file for more details."));
    }

    private static void assertThatUserCanAuthenticate(GenericRestClient client) throws Exception {
        GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        response = client.get("/_searchguard/health", new Header[0]);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        log.info("Health response body '{}'", (Object)response.getBody());
    }

    private static GenericRestClient.HttpResponse searchAll(GenericRestClient client) throws Exception {
        return client.get("/*/_search", new Header[0]);
    }
}

