/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.DlsFlsActionContext;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.DlsGetEvaluator;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.FlsStoredFieldVisitor;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.indices.IndicesModule;

public class DlsFlsDirectoryReader
extends FilterDirectoryReader {
    private final DlsFlsActionContext dlsFlsContext;

    public DlsFlsDirectoryReader(DirectoryReader in, DlsFlsActionContext dlsFlsContext) throws IOException {
        super(in, (FilterDirectoryReader.SubReaderWrapper)new SubReaderWrapper(dlsFlsContext));
        this.dlsFlsContext = dlsFlsContext;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new DlsFlsDirectoryReader(in, this.dlsFlsContext);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private static class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final DlsFlsActionContext dlsFlsContext;

        SubReaderWrapper(DlsFlsActionContext dlsFlsContext) {
            this.dlsFlsContext = dlsFlsContext;
        }

        public LeafReader wrap(LeafReader reader) {
            return new FilterLeafReader(reader, this.dlsFlsContext);
        }

        private static class FilterLeafReader
        extends SequentialStoredFieldsLeafReader {
            private static final Logger log = LogManager.getLogger(FilterLeafReader.class);
            private static final ImmutableSet<String> META_FIELDS = ImmutableSet.of((Collection)IndicesModule.getBuiltInMetadataFields()).with((Object)"_primary_term");
            private final FieldInfos flsFieldInfos;
            private final DlsFlsActionContext dlsFlsContext;
            private final DlsGetEvaluator dlsGetEvaluator;

            FilterLeafReader(LeafReader delegate, DlsFlsActionContext dlsFlsContext) {
                super(delegate);
                this.dlsFlsContext = dlsFlsContext;
                try {
                    if (dlsFlsContext.hasFlsRestriction()) {
                        FieldInfos originalFieldInfos = delegate.getFieldInfos();
                        ArrayList<FieldInfo> restrictedFieldInfos = new ArrayList<FieldInfo>(originalFieldInfos.size());
                        for (FieldInfo fieldInfo : originalFieldInfos) {
                            if (!this.isMetaField(fieldInfo.name) && !dlsFlsContext.isAllowed(fieldInfo.name)) continue;
                            restrictedFieldInfos.add(fieldInfo);
                        }
                        this.flsFieldInfos = new FieldInfos(restrictedFieldInfos.toArray(new FieldInfo[restrictedFieldInfos.size()]));
                    } else {
                        this.flsFieldInfos = delegate.getFieldInfos();
                    }
                    this.dlsGetEvaluator = new DlsGetEvaluator((org.apache.lucene.index.FilterLeafReader)this, dlsFlsContext.getDlsQuery(), this.in, this.applyDlsHere());
                }
                catch (RuntimeException e) {
                    log.error("Got exception while initializing " + String.valueOf((Object)this), (Throwable)e);
                    throw e;
                }
            }

            public StoredFields storedFields() throws IOException {
                final StoredFields storedFields = super.storedFields();
                if (log.isTraceEnabled()) {
                    log.trace("FilterLeafReader.storedFields()\nindex: " + this.dlsFlsContext.getIndexService().index().getName() + "\nfls: " + String.valueOf(this.dlsFlsContext.getFlsRule()) + "\nfieldMasking: " + String.valueOf(this.dlsFlsContext.getFieldMaskingRule()));
                }
                if (this.dlsFlsContext.hasFlsRestriction() || this.dlsFlsContext.hasFieldMasking()) {
                    return new StoredFields(){

                        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                            storedFields.document(docID, (StoredFieldVisitor)new FlsStoredFieldVisitor(visitor, dlsFlsContext));
                        }
                    };
                }
                return storedFields;
            }

            public Bits getLiveDocs() {
                return this.dlsGetEvaluator.getLiveDocs();
            }

            public int numDocs() {
                return this.dlsGetEvaluator.numDocs();
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return this.in.getCoreCacheHelper();
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return this.dlsGetEvaluator.getReaderCacheHelper();
            }

            public boolean hasDeletions() {
                return this.dlsGetEvaluator.hasDeletions();
            }

            protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
                return new DlsFlsStoredFieldsReader(reader);
            }

            public FieldInfos getFieldInfos() {
                return this.flsFieldInfos;
            }

            public TermVectors termVectors() throws IOException {
                final TermVectors termVectors = this.in.termVectors();
                return new TermVectors(){

                    public Fields get(int i) throws IOException {
                        final Fields fields = termVectors.get(i);
                        if (!dlsFlsContext.hasFlsRestriction() || fields == null) {
                            return fields;
                        }
                        return new Fields(){

                            public Iterator<String> iterator() {
                                return Iterators.filter((Iterator)fields.iterator(), dlsFlsContext::isAllowed);
                            }

                            public Terms terms(String field) throws IOException {
                                if ("_field_names".equals(field)) {
                                    return new FilteredTerms(in.terms(field));
                                }
                                if (this.isMetaField(field) || dlsFlsContext.isAllowed(field)) {
                                    return in.terms(field);
                                }
                                return null;
                            }

                            public int size() {
                                return flsFieldInfos.size();
                            }
                        };
                    }
                };
            }

            public NumericDocValues getNumericDocValues(String field) throws IOException {
                return this.isMetaField(field) || this.dlsFlsContext.isAllowed(field) ? this.in.getNumericDocValues(field) : null;
            }

            public BinaryDocValues getBinaryDocValues(String field) throws IOException {
                final BinaryDocValues binaryDocValues = this.in.getBinaryDocValues(field);
                if (binaryDocValues == null) {
                    return null;
                }
                if (this.isMetaField(field)) {
                    return binaryDocValues;
                }
                if (!this.dlsFlsContext.isAllowed(field)) {
                    return null;
                }
                final RoleBasedFieldMasking.FieldMaskingRule.Field fieldMasking = this.dlsFlsContext.getFieldMaskingRule().get(field);
                if (fieldMasking == null) {
                    return binaryDocValues;
                }
                return new BinaryDocValues(){

                    public int nextDoc() throws IOException {
                        return binaryDocValues.nextDoc();
                    }

                    public int docID() {
                        return binaryDocValues.docID();
                    }

                    public long cost() {
                        return binaryDocValues.cost();
                    }

                    public int advance(int target) throws IOException {
                        return binaryDocValues.advance(target);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        return binaryDocValues.advanceExact(target);
                    }

                    public BytesRef binaryValue() throws IOException {
                        return fieldMasking.apply(binaryDocValues.binaryValue());
                    }
                };
            }

            public SortedDocValues getSortedDocValues(String field) throws IOException {
                if (this.isMetaField(field)) {
                    return this.in.getSortedDocValues(field);
                }
                if (!this.dlsFlsContext.isAllowedButPossiblyMasked(field)) {
                    return null;
                }
                final SortedDocValues sortedDocValues = this.in.getSortedDocValues(field);
                if (sortedDocValues == null) {
                    return null;
                }
                final RoleBasedFieldMasking.FieldMaskingRule.Field fieldMasking = this.dlsFlsContext.getFieldMaskingRule().get(field);
                if (fieldMasking == null) {
                    return sortedDocValues;
                }
                return new SortedDocValues(){

                    public int lookupTerm(BytesRef key) throws IOException {
                        return sortedDocValues.lookupTerm(key);
                    }

                    public TermsEnum termsEnum() throws IOException {
                        return new MaskedTermsEnum(sortedDocValues.termsEnum(), fieldMasking);
                    }

                    public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                        return new MaskedTermsEnum(sortedDocValues.intersect(automaton), fieldMasking);
                    }

                    public int nextDoc() throws IOException {
                        return sortedDocValues.nextDoc();
                    }

                    public int docID() {
                        return sortedDocValues.docID();
                    }

                    public long cost() {
                        return sortedDocValues.cost();
                    }

                    public int advance(int target) throws IOException {
                        return sortedDocValues.advance(target);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        return sortedDocValues.advanceExact(target);
                    }

                    public int ordValue() throws IOException {
                        return sortedDocValues.ordValue();
                    }

                    public BytesRef lookupOrd(int ord) throws IOException {
                        return fieldMasking.apply(sortedDocValues.lookupOrd(ord));
                    }

                    public int getValueCount() {
                        return sortedDocValues.getValueCount();
                    }
                };
            }

            public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
                return this.isMetaField(field) || this.dlsFlsContext.isAllowed(field) ? this.in.getSortedNumericDocValues(field) : null;
            }

            public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
                if (this.isMetaField(field)) {
                    return this.in.getSortedSetDocValues(field);
                }
                if (!this.dlsFlsContext.isAllowedButPossiblyMasked(field)) {
                    return null;
                }
                final SortedSetDocValues sortedSetDocValues = this.in.getSortedSetDocValues(field);
                if (sortedSetDocValues == null) {
                    return null;
                }
                final RoleBasedFieldMasking.FieldMaskingRule.Field fieldMasking = this.dlsFlsContext.getFieldMaskingRule().get(field);
                if (fieldMasking == null) {
                    return sortedSetDocValues;
                }
                return new SortedSetDocValues(){

                    public int docValueCount() {
                        return sortedSetDocValues.docValueCount();
                    }

                    public long lookupTerm(BytesRef key) throws IOException {
                        return sortedSetDocValues.lookupTerm(key);
                    }

                    public TermsEnum termsEnum() throws IOException {
                        return new MaskedTermsEnum(sortedSetDocValues.termsEnum(), fieldMasking);
                    }

                    public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                        return new MaskedTermsEnum(sortedSetDocValues.intersect(automaton), fieldMasking);
                    }

                    public int nextDoc() throws IOException {
                        return sortedSetDocValues.nextDoc();
                    }

                    public int docID() {
                        return sortedSetDocValues.docID();
                    }

                    public long cost() {
                        return sortedSetDocValues.cost();
                    }

                    public int advance(int target) throws IOException {
                        return sortedSetDocValues.advance(target);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        return sortedSetDocValues.advanceExact(target);
                    }

                    public long nextOrd() throws IOException {
                        return sortedSetDocValues.nextOrd();
                    }

                    public BytesRef lookupOrd(long ord) throws IOException {
                        return fieldMasking.apply(sortedSetDocValues.lookupOrd(ord));
                    }

                    public long getValueCount() {
                        return sortedSetDocValues.getValueCount();
                    }
                };
            }

            public NumericDocValues getNormValues(String field) throws IOException {
                return this.isMetaField(field) || this.dlsFlsContext.isAllowed(field) ? this.in.getNormValues(field) : null;
            }

            public PointValues getPointValues(String field) throws IOException {
                return this.isMetaField(field) || this.dlsFlsContext.isAllowed(field) ? this.in.getPointValues(field) : null;
            }

            public Terms terms(String field) throws IOException {
                if ("_field_names".equals(field)) {
                    return new FilteredTerms(this.in.terms(field));
                }
                if (this.isMetaField(field)) {
                    return this.in.terms(field);
                }
                if (this.dlsFlsContext.isAllowed(field)) {
                    return this.in.terms(field);
                }
                return null;
            }

            private boolean applyDlsHere() {
                if (this.isSuggest()) {
                    return true;
                }
                String action = this.getRuntimeActionName();
                return !action.startsWith("indices:data/read/search");
            }

            private String getRuntimeActionName() {
                return (String)this.dlsFlsContext.getThreadContext().getTransient("_sg_action_name");
            }

            private boolean isSuggest() {
                return this.dlsFlsContext.getThreadContext().getTransient("_sg_issuggest") == Boolean.TRUE;
            }

            private boolean isMetaField(String field) {
                return META_FIELDS.contains((Object)field);
            }

            private class DlsFlsStoredFieldsReader
            extends StoredFieldsReader {
                private final StoredFieldsReader delegate;

                public DlsFlsStoredFieldsReader(StoredFieldsReader delegate) {
                    this.delegate = delegate;
                }

                public void close() throws IOException {
                    this.delegate.close();
                }

                public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                    if (log.isTraceEnabled()) {
                        log.trace("DlsFlsStoredFieldsReader.visitDocument()\nindex: " + FilterLeafReader.this.dlsFlsContext.getIndexService().index().getName() + "\nfls: " + String.valueOf(FilterLeafReader.this.dlsFlsContext.getFlsRule()) + "\nfieldMasking: " + String.valueOf(FilterLeafReader.this.dlsFlsContext.getFieldMaskingRule()));
                    }
                    if (FilterLeafReader.this.dlsFlsContext.hasFlsRestriction() || FilterLeafReader.this.dlsFlsContext.hasFieldMasking()) {
                        visitor = new FlsStoredFieldVisitor(visitor, FilterLeafReader.this.dlsFlsContext);
                    }
                    this.delegate.document(docID, visitor);
                }

                public StoredFieldsReader clone() {
                    return new DlsFlsStoredFieldsReader(this.delegate);
                }

                public void checkIntegrity() throws IOException {
                    this.delegate.checkIntegrity();
                }
            }

            private final class FilteredTerms
            extends FilterLeafReader.FilterTerms {
                public FilteredTerms(Terms delegate) {
                    super(delegate);
                }

                public TermsEnum iterator() throws IOException {
                    return new FilteredTermsEnum(this.in.iterator());
                }

                private final class FilteredTermsEnum
                extends FilterLeafReader.FilterTermsEnum {
                    public FilteredTermsEnum(TermsEnum delegate) {
                        super(delegate);
                    }

                    public BytesRef next() throws IOException {
                        BytesRef nextBytesRef = this.in.next();
                        while (nextBytesRef != null) {
                            if (this.isAllowed(nextBytesRef)) {
                                return nextBytesRef;
                            }
                            nextBytesRef = this.in.next();
                        }
                        return null;
                    }

                    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                        TermsEnum.SeekStatus delegateStatus = this.in.seekCeil(text);
                        if (delegateStatus != TermsEnum.SeekStatus.END && this.isAllowed(this.in.term())) {
                            return delegateStatus;
                        }
                        if (delegateStatus == TermsEnum.SeekStatus.END) {
                            return TermsEnum.SeekStatus.END;
                        }
                        if (this.next() != null) {
                            return TermsEnum.SeekStatus.NOT_FOUND;
                        }
                        return TermsEnum.SeekStatus.END;
                    }

                    public boolean seekExact(BytesRef term) throws IOException {
                        return this.isAllowed(term) && this.in.seekExact(term);
                    }

                    public void seekExact(long ord) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long ord() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    private boolean isAllowed(BytesRef term) {
                        String fieldName = term.utf8ToString();
                        return FilterLeafReader.this.isMetaField(fieldName) || FilterLeafReader.this.dlsFlsContext.isAllowed(fieldName);
                    }
                }
            }

            private static class MaskedTermsEnum
            extends TermsEnum {
                private final TermsEnum delegate;
                private final RoleBasedFieldMasking.FieldMaskingRule.Field fieldMasking;

                public MaskedTermsEnum(TermsEnum delegate, RoleBasedFieldMasking.FieldMaskingRule.Field fieldMasking) {
                    this.delegate = delegate;
                    this.fieldMasking = fieldMasking;
                }

                public BytesRef next() throws IOException {
                    return this.delegate.next();
                }

                public AttributeSource attributes() {
                    return this.delegate.attributes();
                }

                public boolean seekExact(BytesRef text) throws IOException {
                    return this.delegate.seekExact(text);
                }

                public IOBooleanSupplier prepareSeekExact(BytesRef bytesRef) throws IOException {
                    return this.delegate.prepareSeekExact(bytesRef);
                }

                public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                    return this.delegate.seekCeil(text);
                }

                public void seekExact(long ord) throws IOException {
                    this.delegate.seekExact(ord);
                }

                public void seekExact(BytesRef term, TermState state) throws IOException {
                    this.delegate.seekExact(term, state);
                }

                public BytesRef term() throws IOException {
                    return this.fieldMasking.apply(this.delegate.term());
                }

                public long ord() throws IOException {
                    return this.delegate.ord();
                }

                public int docFreq() throws IOException {
                    return this.delegate.docFreq();
                }

                public long totalTermFreq() throws IOException {
                    return this.delegate.totalTermFreq();
                }

                public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                    return this.delegate.postings(reuse, flags);
                }

                public ImpactsEnum impacts(int flags) throws IOException {
                    return this.delegate.impacts(flags);
                }

                public TermState termState() throws IOException {
                    return this.delegate.termState();
                }
            }
        }
    }
}

