/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.cluster.SimpleRestHandler;
import com.floragunn.searchsupport.action.ActionHandlerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class ThreadContextAuthzHashProviderIntTest {
    static final TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DLS_USER_1A = new TestSgConfig.User("dls_user_1a").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"index_*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DLS_USER_1B = new TestSgConfig.User("dls_user_1b").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"index_*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DLS_USER_2 = new TestSgConfig.User("dls_user_2").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_b")).on(new String[]{"index_*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DLS_USER_WITH_ATTR = new TestSgConfig.User("dls_user_with_attr").attr("dept", (Object)"dept_a").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"${user.attr.dept}")).on(new String[]{"index_*"}).clusterPermissions(new String[]{"*"})});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(TestSgConfig.Authc.DEFAULT).dlsFls(new TestSgConfig.DlsFls()).users(new TestSgConfig.User[]{ADMIN, DLS_USER_1A, DLS_USER_1B, DLS_USER_2, DLS_USER_WITH_ATTR}).nodeSettings(new Object[]{"searchguard.dls_fls.provide_thread_context_authz_hash", true}).embedded().plugin(MockPlugin.class).build();

    @Test
    public void access_unrestricted() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.post("index_1/_mock");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.distinctNodesAt((String)"header_values.*", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"0"}))}));
        }
    }

    @Test
    public void access_restricted() throws Exception {
        GenericRestClient.HttpResponse response;
        String expectedForUser1 = "8ddcf3b2f3e5c619a3271ba7df12507002280bbf4d22aac8f17b9ab984e23f74";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER_1A, new Header[0]);){
            response = client.post("index_1/_mock");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.distinctNodesAt((String)"header_values.*", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{expectedForUser1}))}));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER_1B, new Header[0]);
        try {
            response = client.post("index_1/_mock");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.distinctNodesAt((String)"header_values.*", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{expectedForUser1}))}));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER_1B, new Header[0]);
        try {
            response = client.post("index_2/_mock");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.distinctNodesAt((String)"header_values.*", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{expectedForUser1}))}));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        String expectedForUser2 = "cd5196e132bc2afc486a98911b812a79c3b3aeaba5cc9c0724458731c7f14fb0";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER_2, new Header[0]);){
            GenericRestClient.HttpResponse response2 = client.post("index_1/_mock");
            MatcherAssert.assertThat((Object)response2, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response2, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.distinctNodesAt((String)"header_values.*", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{expectedForUser2}))}));
        }
        String expectedForAttrUser = "61c42babbd798dad279d4828afa479f1eb7cf302b4d3c59ae19a1d1f7c8bd84a";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER_WITH_ATTR, new Header[0]);){
            GenericRestClient.HttpResponse response3 = client.post("index_1/_mock");
            MatcherAssert.assertThat((Object)response3, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response3, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.distinctNodesAt((String)"header_values.*", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{expectedForAttrUser}))}));
        }
    }

    public static class MockPlugin
    extends Plugin
    implements ActionPlugin {
        public List<ActionPlugin.ActionHandler> getActions() {
            return Arrays.asList(ActionHandlerFactory.actionHandler(MockTransportAction.TYPE, MockTransportAction.class));
        }

        public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
            return Arrays.asList(new SimpleRestHandler(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mock"), MockTransportAction.TYPE, request -> new MockActionNodesRequest(request.param("index"))));
        }

        public static class MockTransportAction
        extends TransportNodesAction<MockActionNodesRequest, MockActionNodesResponse, MockActionRequest, MockActionResponse, MockTransportAction> {
            static ActionType<MockActionNodesResponse> TYPE = new ActionType("indices:mock/action");
            final ThreadContext threadContext;

            @Inject
            public MockTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
                super(TYPE.name(), clusterService, transportService, actionFilters, MockActionRequest::new, (Executor)threadPool.executor("generic"));
                this.threadContext = threadPool.getThreadContext();
            }

            protected MockActionResponse nodeOperation(MockActionRequest request, Task task) {
                String authzHeaderValue = this.threadContext.getHeader("_sg_dls_fls_authz");
                return new MockActionResponse(this.clusterService.localNode(), authzHeaderValue);
            }

            protected MockActionNodesResponse newResponse(MockActionNodesRequest nodesRequest, List<MockActionResponse> nodes, List<FailedNodeException> failures) {
                return new MockActionNodesResponse(this.clusterService.getClusterName(), nodes, failures);
            }

            protected MockActionRequest newNodeRequest(MockActionNodesRequest nodesRequest) {
                return new MockActionRequest(nodesRequest.index);
            }

            protected MockActionResponse newNodeResponse(StreamInput streamInput, DiscoveryNode discoveryNode) throws IOException {
                return new MockActionResponse(streamInput);
            }
        }

        public static class MockActionNodesRequest
        extends BaseNodesRequest
        implements IndicesRequest {
            private String index;

            public MockActionNodesRequest(String index) {
                super(new String[0]);
                this.index = index;
            }

            public ActionRequestValidationException validate() {
                return null;
            }

            public String getIndex() {
                return this.index;
            }

            public void setIndex(String index) {
                this.index = index;
            }

            public String[] indices() {
                return new String[]{this.index};
            }

            public IndicesOptions indicesOptions() {
                return IndicesOptions.STRICT_NO_EXPAND_FORBID_CLOSED;
            }
        }

        public static class MockActionResponse
        extends BaseNodeResponse
        implements ToXContentObject,
        ChunkedToXContentObject {
            private String headerValue;

            public MockActionResponse(DiscoveryNode node, String headerValue) {
                super(node);
                this.headerValue = headerValue;
            }

            public MockActionResponse(StreamInput in) throws IOException {
                super(in);
                this.headerValue = in.readOptionalString();
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("header_value", this.headerValue);
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeOptionalString(this.headerValue);
            }

            public RestStatus status() {
                return RestStatus.OK;
            }

            public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                ImmutableList list = ImmutableList.of((Object)((Object)this));
                return list.iterator();
            }

            public boolean isFragment() {
                return false;
            }
        }

        public static class MockActionRequest
        extends ActionRequest
        implements IndicesRequest {
            private String index;

            public MockActionRequest(String index) {
                this.index = index;
            }

            public MockActionRequest(StreamInput in) throws IOException {
                super(in);
                this.index = in.readOptionalString();
            }

            public ActionRequestValidationException validate() {
                return null;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeOptionalString(this.index);
            }

            public String getIndex() {
                return this.index;
            }

            public void setIndex(String index) {
                this.index = index;
            }

            public String[] indices() {
                return new String[]{this.index};
            }

            public IndicesOptions indicesOptions() {
                return IndicesOptions.STRICT_NO_EXPAND_FORBID_CLOSED;
            }
        }

        public static class MockActionNodesResponse
        extends BaseNodesResponse<MockActionResponse>
        implements ToXContentObject,
        ChunkedToXContentObject {
            public MockActionNodesResponse(ClusterName clusterName, List<MockActionResponse> nodes, List<FailedNodeException> failures) {
                super(clusterName, nodes, failures);
            }

            public MockActionNodesResponse(StreamInput in) throws IOException {
                super(in);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("header_values");
                builder.startObject();
                for (MockActionResponse nodeResponse : this.getNodes()) {
                    builder.field(nodeResponse.getNode().getName(), nodeResponse.headerValue);
                }
                builder.endObject();
                builder.field("failures");
                builder.startObject();
                for (FailedNodeException failedNodeException : this.failures()) {
                    builder.field(failedNodeException.nodeId(), (ToXContent)failedNodeException);
                }
                builder.endObject();
                builder.endObject();
                return builder;
            }

            public RestStatus status() {
                return RestStatus.OK;
            }

            public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                ImmutableList list = ImmutableList.of((Object)((Object)this));
                return list.iterator();
            }

            public boolean isFragment() {
                return false;
            }

            public List<MockActionResponse> readNodesFrom(StreamInput in) throws IOException {
                return in.readCollectionAsList(MockActionResponse::new);
            }

            public void writeNodesTo(StreamOutput out, List<MockActionResponse> nodes) throws IOException {
                out.writeCollection(nodes);
            }
        }
    }
}

