/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RoleBasedFieldAuthorizationSingleRoleTest {
    @Test
    public void shouldReturnFieldAndAllParentFieldsForMultiLevelField() {
        List result = RoleBasedFieldAuthorization.FlsRule.SingleRole.fieldItselfWithAllItsParent((String)"foo.bar.baz");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new String[]{"foo.bar.baz", "foo.bar", "foo"}));
    }

    @Test
    public void shouldReturnFieldAndAllParentFieldsForMultiLevelFieldCaseTwo() {
        List result = RoleBasedFieldAuthorization.FlsRule.SingleRole.fieldItselfWithAllItsParent((String)"a.b.c.d.e");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new String[]{"a.b.c.d.e", "a.b.c.d", "a.b.c", "a.b", "a"}));
    }

    @Test
    public void shouldReturnFieldAndParentForSingleDotField() {
        List result = RoleBasedFieldAuthorization.FlsRule.SingleRole.fieldItselfWithAllItsParent((String)"foo.bar");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new String[]{"foo.bar", "foo"}));
    }

    @Test
    public void shouldReturnFieldItselfWhenNoDotPresent() {
        List result = RoleBasedFieldAuthorization.FlsRule.SingleRole.fieldItselfWithAllItsParent((String)"foobar");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new String[]{"foobar"}));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldReturnEmptyStringWhenInputIsEmpty() {
        List result = RoleBasedFieldAuthorization.FlsRule.SingleRole.fieldItselfWithAllItsParent((String)"");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new String[]{""}));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
    }
}

