/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.FlsStoredFieldVisitor;
import org.junit.Assert;
import org.junit.Test;

public class DocumentFilterTest {
    @Test
    public void identity() throws Exception {
        DocNode document = DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"a", (Object)1, (String)"b", (Object)DocNode.of((String)"c", (Object)2)), (String)"boolean", (Object)true, (String)"boolean2", (Object)false, (String)"null", null, (Object[])new Object[]{"float", 0.1});
        byte[] filteredDocumentBytes = FlsStoredFieldVisitor.DocumentFilter.filter((Format)Format.JSON, (byte[])document.toBytes(Format.JSON), (RoleBasedFieldAuthorization.FlsRule)RoleBasedFieldAuthorization.FlsRule.ALLOW_ALL, (RoleBasedFieldMasking.FieldMaskingRule)RoleBasedFieldMasking.FieldMaskingRule.ALLOW_ALL);
        DocNode filteredDocument = DocNode.parse((Format)Format.JSON).from(filteredDocumentBytes);
        Assert.assertEquals((Object)document.toDeepBasicObject(), (Object)filteredDocument.toDeepBasicObject());
    }

    @Test
    public void skipSimpleAttribute() throws Exception {
        RoleBasedFieldAuthorization.FlsRule flsRule = RoleBasedFieldAuthorization.FlsRule.of((String[])new String[]{"*", "~x"});
        DocNode document = DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"a", (Object)1), (String)"x", (Object)"y");
        byte[] filteredDocumentBytes = FlsStoredFieldVisitor.DocumentFilter.filter((Format)Format.JSON, (byte[])document.toBytes(Format.JSON), (RoleBasedFieldAuthorization.FlsRule)flsRule, (RoleBasedFieldMasking.FieldMaskingRule)RoleBasedFieldMasking.FieldMaskingRule.ALLOW_ALL);
        DocNode filteredDocument = DocNode.parse((Format)Format.JSON).from(filteredDocumentBytes);
        Assert.assertEquals((Object)document.without(new String[]{"x"}).toDeepBasicObject(), (Object)filteredDocument.toDeepBasicObject());
    }

    @Test
    public void skipObjectAttribute() throws Exception {
        RoleBasedFieldAuthorization.FlsRule flsRule = RoleBasedFieldAuthorization.FlsRule.of((String[])new String[]{"*", "~object"});
        DocNode document = DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"a", (Object)1), (String)"x", (Object)"y");
        byte[] filteredDocumentBytes = FlsStoredFieldVisitor.DocumentFilter.filter((Format)Format.JSON, (byte[])document.toBytes(Format.JSON), (RoleBasedFieldAuthorization.FlsRule)flsRule, (RoleBasedFieldMasking.FieldMaskingRule)RoleBasedFieldMasking.FieldMaskingRule.ALLOW_ALL);
        DocNode filteredDocument = DocNode.parse((Format)Format.JSON).from(filteredDocumentBytes);
        Assert.assertEquals((Object)document.without(new String[]{"object"}).toDeepBasicObject(), (Object)filteredDocument.toDeepBasicObject());
    }

    @Test
    public void skipArrayAttribute() throws Exception {
        RoleBasedFieldAuthorization.FlsRule flsRule = RoleBasedFieldAuthorization.FlsRule.of((String[])new String[]{"*", "~array"});
        DocNode document = DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"a", (Object)1), (String)"x", (Object)"y");
        byte[] filteredDocumentBytes = FlsStoredFieldVisitor.DocumentFilter.filter((Format)Format.JSON, (byte[])document.toBytes(Format.JSON), (RoleBasedFieldAuthorization.FlsRule)flsRule, (RoleBasedFieldMasking.FieldMaskingRule)RoleBasedFieldMasking.FieldMaskingRule.ALLOW_ALL);
        DocNode filteredDocument = DocNode.parse((Format)Format.JSON).from(filteredDocumentBytes);
        Assert.assertEquals((Object)document.without(new String[]{"array"}).toDeepBasicObject(), (Object)filteredDocument.toDeepBasicObject());
    }

    @Test
    public void skipNestedAttribute() throws Exception {
        RoleBasedFieldAuthorization.FlsRule flsRule = RoleBasedFieldAuthorization.FlsRule.of((String[])new String[]{"*", "~object.a"});
        DocNode document = DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"a", (Object)1, (String)"b", (Object)2), (String)"x", (Object)"y");
        byte[] filteredDocumentBytes = FlsStoredFieldVisitor.DocumentFilter.filter((Format)Format.JSON, (byte[])document.toBytes(Format.JSON), (RoleBasedFieldAuthorization.FlsRule)flsRule, (RoleBasedFieldMasking.FieldMaskingRule)RoleBasedFieldMasking.FieldMaskingRule.ALLOW_ALL);
        DocNode filteredDocument = DocNode.parse((Format)Format.JSON).from(filteredDocumentBytes);
        Assert.assertEquals((Object)DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"b", (Object)2), (String)"x", (Object)"y").toDeepBasicObject(), (Object)filteredDocument.toDeepBasicObject());
    }

    @Test
    public void hashSimpleAttribute() throws Exception {
        RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule = RoleBasedFieldMasking.FieldMaskingRule.of((DlsFlsConfig.FieldMasking)DlsFlsConfig.FieldMasking.DEFAULT, (String[])new String[]{"x"});
        DocNode document = DocNode.of((String)"array", (Object)DocNode.array((Object[])new Object[]{"a", "b", "c", 1, 2, 3}), (String)"object", (Object)DocNode.of((String)"a", (Object)1), (String)"x", (Object)"y");
        byte[] filteredDocumentBytes = FlsStoredFieldVisitor.DocumentFilter.filter((Format)Format.JSON, (byte[])document.toBytes(Format.JSON), (RoleBasedFieldAuthorization.FlsRule)RoleBasedFieldAuthorization.FlsRule.ALLOW_ALL, (RoleBasedFieldMasking.FieldMaskingRule)fieldMaskingRule);
        DocNode filteredDocument = DocNode.parse((Format)Format.JSON).from(filteredDocumentBytes);
        Assert.assertEquals((Object)document.with("x", (Object)"0f9768c7af6190a3707258090b7966d429ae72b29ce19afeacb7c26b59b5448f").toDeepBasicObject(), (Object)filteredDocument.toDeepBasicObject());
    }
}

