/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class DlsMinDocCountTest {
    static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls();
    static final TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User LOGS_TWO_TERMX_A_USER = new TestSgConfig.User("logs_termx_a").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("logs_index_with_dls").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"bool.filter.term.termX", (Object)"A")).on(new String[]{"logs-2"})});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).users(new TestSgConfig.User[]{ADMIN, LOGS_TWO_TERMX_A_USER}).resources("dlsfls").embedded().build();

    @Test
    public void testDlsWithMinDocCountZeroAggregations() throws Exception {
        Client client = cluster.getInternalNodeClient();
        client.admin().indices().create(new CreateIndexRequest("logs-2").mapping((Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"termX", (Object)ImmutableMap.of((Object)"type", (Object)"keyword"))))).actionGet();
        for (int i = 0; i < 3; ++i) {
            client.index(((IndexRequest)new IndexRequest("logs-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"amount", i, "termX", "A", "timestamp", "2022-01-06T09:05:00Z"})).actionGet();
            client.index(((IndexRequest)new IndexRequest("logs-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"amount", i, "termX", "B", "timestamp", "2022-01-06T09:08:00Z"})).actionGet();
            client.index(((IndexRequest)new IndexRequest("logs-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"amount", i, "termX", "C", "timestamp", "2022-01-06T09:09:00Z"})).actionGet();
            client.index(((IndexRequest)new IndexRequest("logs-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"amount", i, "termX", "D", "timestamp", "2022-01-06T09:10:00Z"})).actionGet();
        }
        client.index(((IndexRequest)new IndexRequest("logs-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"amount", 0, "termX", "E", "timestamp", "2022-01-06T09:11:00Z"})).actionGet();
        try (GenericRestClient dmClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)LOGS_TWO_TERMX_A_USER, new Header[0]);
             GenericRestClient adminClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
             GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            cluster.callAndRestoreConfig(DlsFlsConfig.TYPE, () -> {
                DocNode dlsConfig = DocNode.of((String)"use_impl", (Object)"flx", (String)"dls.force_min_doc_count_to_1", (Object)false);
                GenericRestClient.HttpResponse configResponse = adminCertClient.putJson("/_searchguard/config/authz_dlsfls", (Document)dlsConfig);
                Assert.assertEquals((long)200L, (long)configResponse.getStatusCode());
                String query1 = "{\n  \"size\":0,\n  \"query\":{\n    \"bool\":{\n      \"must\":[\n        {\n          \"range\":{\n            \"amount\":{\"gte\":1,\"lte\":100}\n          }\n        }\n      ]\n    }\n  },\n  \"aggs\":{\n    \"a\": {\n      \"terms\": {\n        \"field\": \"termX\",\n        \"min_doc_count\":0,\n\"size\": 10,\n\"order\": { \"_count\": \"desc\" }\n      }\n    }\n  }\n}";
                GenericRestClient.HttpResponse response1 = dmClient.postJson("logs-2*/_search", query1, new Header[0]);
                Assert.assertEquals((long)403L, (long)response1.getStatusCode());
                String query2 = "{\n  \"size\":0,\n  \"query\":{\n    \"bool\":{\n      \"must\":[\n        {\n          \"range\":{\n            \"amount\":{\"gte\":1,\"lte\":100}\n          }\n        }\n      ]\n    }\n  },\n  \"aggs\":{\n    \"a\": {\n      \"terms\": {\n        \"field\": \"termX\",\n\"size\": 10,\n\"order\": { \"_count\": \"desc\" }\n      }\n    }\n  }\n}";
                GenericRestClient.HttpResponse response2 = dmClient.postJson("logs-2*/_search", query2, new Header[0]);
                Assert.assertEquals((long)200L, (long)response2.getStatusCode());
                Assert.assertTrue((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"A\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"B\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"C\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"D\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"E\""));
                GenericRestClient.HttpResponse response3 = adminClient.postJson("logs-2*/_search", query1, new Header[0]);
                Assert.assertEquals((long)200L, (long)response3.getStatusCode());
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"A\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"B\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"C\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"D\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"E\",\"doc_count\":0"));
                GenericRestClient.HttpResponse response4 = adminClient.postJson("logs-2*/_search", query2, new Header[0]);
                Assert.assertEquals((long)200L, (long)response4.getStatusCode());
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"A\""));
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"B\""));
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"C\""));
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"D\""));
                Assert.assertFalse((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"E\""));
                return null;
            });
            cluster.callAndRestoreConfig(DlsFlsConfig.TYPE, () -> {
                DocNode dlsConfig = DocNode.of((String)"use_impl", (Object)"flx", (String)"dls.force_min_doc_count_to_1", (Object)true);
                GenericRestClient.HttpResponse configResponse = adminCertClient.putJson("/_searchguard/config/authz_dlsfls", (Document)dlsConfig);
                Assert.assertEquals((long)200L, (long)configResponse.getStatusCode());
                String query1 = "{\n  \"size\":0,\n  \"query\":{\n    \"bool\":{\n      \"must\":[\n        {\n          \"range\":{\n            \"amount\":{\"gte\":1,\"lte\":100}\n          }\n        }\n      ]\n    }\n  },\n  \"aggs\":{\n    \"a\": {\n      \"terms\": {\n        \"field\": \"termX\",\n        \"min_doc_count\":0,\n\"size\": 10,\n\"order\": { \"_count\": \"desc\" }\n      }\n    }\n  }\n}";
                GenericRestClient.HttpResponse response1 = dmClient.postJson("logs-2*/_search", query1, new Header[0]);
                Assert.assertEquals((long)200L, (long)response1.getStatusCode());
                Assert.assertTrue((String)response1.getBody(), (boolean)response1.getBody().contains("\"key\":\"A\""));
                Assert.assertFalse((String)response1.getBody(), (boolean)response1.getBody().contains("\"key\":\"B\""));
                Assert.assertFalse((String)response1.getBody(), (boolean)response1.getBody().contains("\"key\":\"C\""));
                Assert.assertFalse((String)response1.getBody(), (boolean)response1.getBody().contains("\"key\":\"D\""));
                Assert.assertFalse((String)response1.getBody(), (boolean)response1.getBody().contains("\"key\":\"E\""));
                String query2 = "{\n  \"size\":0,\n  \"query\":{\n    \"bool\":{\n      \"must\":[\n        {\n          \"range\":{\n            \"amount\":{\"gte\":1,\"lte\":100}\n          }\n        }\n      ]\n    }\n  },\n  \"aggs\":{\n    \"a\": {\n      \"terms\": {\n        \"field\": \"termX\",\n\"size\": 10,\n\"order\": { \"_count\": \"desc\" }\n      }\n    }\n  }\n}";
                GenericRestClient.HttpResponse response2 = dmClient.postJson("logs-2*/_search", query2, new Header[0]);
                Assert.assertEquals((long)200L, (long)response2.getStatusCode());
                Assert.assertTrue((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"A\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"B\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"C\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"D\""));
                Assert.assertFalse((String)response2.getBody(), (boolean)response2.getBody().contains("\"key\":\"E\""));
                GenericRestClient.HttpResponse response3 = adminClient.postJson("logs*/_search", query1, new Header[0]);
                Assert.assertEquals((long)200L, (long)response3.getStatusCode());
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"A\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"B\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"C\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"D\""));
                Assert.assertTrue((String)response3.getBody(), (boolean)response3.getBody().contains("\"key\":\"E\",\"doc_count\":0"));
                GenericRestClient.HttpResponse response4 = adminClient.postJson("logs-2*/_search", query2, new Header[0]);
                Assert.assertEquals((long)200L, (long)response4.getStatusCode());
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"A\""));
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"B\""));
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"C\""));
                Assert.assertTrue((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"D\""));
                Assert.assertFalse((String)response4.getBody(), (boolean)response4.getBody().contains("\"key\":\"E\""));
                return null;
            });
            String query3 = "{\"size\":20,\"aggregations\":{\"significant_termX\":{\"significant_terms\":{\"field\":\"termX.keyword\",\"min_doc_count\":0}}}}";
            GenericRestClient.HttpResponse response5 = dmClient.postJson("logs-2*/_search", query3, new Header[0]);
            Assert.assertEquals((long)200L, (long)response5.getStatusCode());
            Assert.assertTrue((String)response5.getBody(), (boolean)response5.getBody().contains("\"termX\":\"A\""));
            Assert.assertFalse((String)response5.getBody(), (boolean)response5.getBody().contains("\"termX\":\"B\""));
            Assert.assertFalse((String)response5.getBody(), (boolean)response5.getBody().contains("\"termX\":\"C\""));
            Assert.assertFalse((String)response5.getBody(), (boolean)response5.getBody().contains("\"termX\":\"D\""));
            Assert.assertFalse((String)response5.getBody(), (boolean)response5.getBody().contains("\"termX\":\"E\""));
            String query4 = "{\"size\":20,\"aggregations\":{\"significant_termX\":{\"significant_terms\":{\"field\":\"termX.keyword\"}}}}";
            GenericRestClient.HttpResponse response6 = dmClient.postJson("logs-2*/_search", query4, new Header[0]);
            Assert.assertEquals((long)200L, (long)response6.getStatusCode());
            Assert.assertTrue((String)response6.getBody(), (boolean)response6.getBody().contains("\"termX\":\"A\""));
            Assert.assertFalse((String)response6.getBody(), (boolean)response6.getBody().contains("\"termX\":\"B\""));
            Assert.assertFalse((String)response6.getBody(), (boolean)response6.getBody().contains("\"termX\":\"C\""));
            Assert.assertFalse((String)response6.getBody(), (boolean)response6.getBody().contains("\"termX\":\"D\""));
            Assert.assertFalse((String)response6.getBody(), (boolean)response6.getBody().contains("\"termX\":\"E\""));
            GenericRestClient.HttpResponse response7 = adminClient.postJson("logs-2*/_search", query3, new Header[0]);
            Assert.assertEquals((long)200L, (long)response7.getStatusCode());
            Assert.assertTrue((String)response7.getBody(), (boolean)response7.getBody().contains("\"termX\":\"A\""));
            Assert.assertTrue((String)response7.getBody(), (boolean)response7.getBody().contains("\"termX\":\"B\""));
            Assert.assertTrue((String)response7.getBody(), (boolean)response7.getBody().contains("\"termX\":\"C\""));
            Assert.assertTrue((String)response7.getBody(), (boolean)response7.getBody().contains("\"termX\":\"D\""));
            Assert.assertTrue((String)response7.getBody(), (boolean)response7.getBody().contains("\"termX\":\"E\""));
            GenericRestClient.HttpResponse response8 = adminClient.postJson("logs-2*/_search", query4, new Header[0]);
            Assert.assertEquals((long)200L, (long)response8.getStatusCode());
            Assert.assertTrue((String)response8.getBody(), (boolean)response8.getBody().contains("\"termX\":\"A\""));
            Assert.assertTrue((String)response8.getBody(), (boolean)response8.getBody().contains("\"termX\":\"B\""));
            Assert.assertTrue((String)response8.getBody(), (boolean)response8.getBody().contains("\"termX\":\"C\""));
            Assert.assertTrue((String)response8.getBody(), (boolean)response8.getBody().contains("\"termX\":\"D\""));
            Assert.assertTrue((String)response8.getBody(), (boolean)response8.getBody().contains("\"termX\":\"E\""));
            String query5 = "{\"size\":20,\"aggs\":{\"amount\":{\"histogram\":{\"field\":\"amount\",\"interval\":1,\"min_doc_count\":0}}}}";
            GenericRestClient.HttpResponse response9 = dmClient.postJson("logs-2*/_search", query5, new Header[0]);
            Assert.assertEquals((long)200L, (long)response9.getStatusCode());
            Assert.assertTrue((String)response9.getBody(), (boolean)response9.getBody().contains("\"termX\":\"A\""));
            Assert.assertFalse((String)response9.getBody(), (boolean)response9.getBody().contains("\"termX\":\"B\""));
            Assert.assertFalse((String)response9.getBody(), (boolean)response9.getBody().contains("\"termX\":\"C\""));
            Assert.assertFalse((String)response9.getBody(), (boolean)response9.getBody().contains("\"termX\":\"D\""));
            Assert.assertFalse((String)response9.getBody(), (boolean)response9.getBody().contains("\"termX\":\"E\""));
            String query6 = "{\"size\":20,\"aggs\":{\"amount\":{\"histogram\":{\"field\":\"amount\",\"interval\":1}}}}";
            GenericRestClient.HttpResponse response10 = dmClient.postJson("logs-2*/_search", query6, new Header[0]);
            Assert.assertEquals((long)200L, (long)response10.getStatusCode());
            Assert.assertTrue((String)response10.getBody(), (boolean)response10.getBody().contains("\"termX\":\"A\""));
            Assert.assertFalse((String)response10.getBody(), (boolean)response10.getBody().contains("\"termX\":\"B\""));
            Assert.assertFalse((String)response10.getBody(), (boolean)response10.getBody().contains("\"termX\":\"C\""));
            Assert.assertFalse((String)response10.getBody(), (boolean)response10.getBody().contains("\"termX\":\"D\""));
            Assert.assertFalse((String)response10.getBody(), (boolean)response10.getBody().contains("\"termX\":\"E\""));
            GenericRestClient.HttpResponse response11 = adminClient.postJson("logs-2*/_search", query5, new Header[0]);
            Assert.assertEquals((long)200L, (long)response11.getStatusCode());
            Assert.assertTrue((String)response11.getBody(), (boolean)response11.getBody().contains("\"termX\":\"A\""));
            Assert.assertTrue((String)response11.getBody(), (boolean)response11.getBody().contains("\"termX\":\"B\""));
            Assert.assertTrue((String)response11.getBody(), (boolean)response11.getBody().contains("\"termX\":\"C\""));
            Assert.assertTrue((String)response11.getBody(), (boolean)response11.getBody().contains("\"termX\":\"D\""));
            Assert.assertTrue((String)response11.getBody(), (boolean)response11.getBody().contains("\"termX\":\"E\""));
            GenericRestClient.HttpResponse response12 = adminClient.postJson("logs-2*/_search", query6, new Header[0]);
            Assert.assertEquals((long)200L, (long)response12.getStatusCode());
            Assert.assertTrue((String)response12.getBody(), (boolean)response12.getBody().contains("\"termX\":\"A\""));
            Assert.assertTrue((String)response12.getBody(), (boolean)response12.getBody().contains("\"termX\":\"B\""));
            Assert.assertTrue((String)response12.getBody(), (boolean)response12.getBody().contains("\"termX\":\"C\""));
            Assert.assertTrue((String)response12.getBody(), (boolean)response12.getBody().contains("\"termX\":\"D\""));
            Assert.assertTrue((String)response12.getBody(), (boolean)response12.getBody().contains("\"termX\":\"E\""));
            String query7 = "{\"size\":20,\"aggs\":{\"timestamp\":{\"date_histogram\":{\"field\":\"timestamp\",\"calendar_interval\":\"month\",\"min_doc_count\":0}}}}";
            GenericRestClient.HttpResponse response13 = dmClient.postJson("logs-2*/_search", query7, new Header[0]);
            Assert.assertEquals((long)200L, (long)response13.getStatusCode());
            Assert.assertTrue((String)response13.getBody(), (boolean)response13.getBody().contains("\"termX\":\"A\""));
            Assert.assertFalse((String)response13.getBody(), (boolean)response13.getBody().contains("\"termX\":\"B\""));
            Assert.assertFalse((String)response13.getBody(), (boolean)response13.getBody().contains("\"termX\":\"C\""));
            Assert.assertFalse((String)response13.getBody(), (boolean)response13.getBody().contains("\"termX\":\"D\""));
            Assert.assertFalse((String)response13.getBody(), (boolean)response13.getBody().contains("\"termX\":\"E\""));
            String query8 = "{\"size\":20,\"aggs\":{\"timestamp\":{\"date_histogram\":{\"field\":\"timestamp\",\"calendar_interval\":\"month\"}}}}";
            GenericRestClient.HttpResponse response14 = dmClient.postJson("logs-2*/_search", query8, new Header[0]);
            Assert.assertEquals((long)200L, (long)response14.getStatusCode());
            Assert.assertTrue((String)response14.getBody(), (boolean)response14.getBody().contains("\"termX\":\"A\""));
            Assert.assertFalse((String)response14.getBody(), (boolean)response14.getBody().contains("\"termX\":\"B\""));
            Assert.assertFalse((String)response14.getBody(), (boolean)response14.getBody().contains("\"termX\":\"C\""));
            Assert.assertFalse((String)response14.getBody(), (boolean)response14.getBody().contains("\"termX\":\"D\""));
            Assert.assertFalse((String)response14.getBody(), (boolean)response14.getBody().contains("\"termX\":\"E\""));
            GenericRestClient.HttpResponse response15 = adminClient.postJson("logs-2*/_search", query7, new Header[0]);
            Assert.assertEquals((long)200L, (long)response15.getStatusCode());
            Assert.assertTrue((String)response15.getBody(), (boolean)response15.getBody().contains("\"termX\":\"A\""));
            Assert.assertTrue((String)response15.getBody(), (boolean)response15.getBody().contains("\"termX\":\"B\""));
            Assert.assertTrue((String)response15.getBody(), (boolean)response15.getBody().contains("\"termX\":\"C\""));
            Assert.assertTrue((String)response15.getBody(), (boolean)response15.getBody().contains("\"termX\":\"D\""));
            Assert.assertTrue((String)response15.getBody(), (boolean)response15.getBody().contains("\"termX\":\"E\""));
            GenericRestClient.HttpResponse response16 = adminClient.postJson("logs-2*/_search", query8, new Header[0]);
            Assert.assertEquals((long)200L, (long)response16.getStatusCode());
            Assert.assertTrue((String)response16.getBody(), (boolean)response16.getBody().contains("\"termX\":\"A\""));
            Assert.assertTrue((String)response16.getBody(), (boolean)response16.getBody().contains("\"termX\":\"B\""));
            Assert.assertTrue((String)response16.getBody(), (boolean)response16.getBody().contains("\"termX\":\"C\""));
            Assert.assertTrue((String)response16.getBody(), (boolean)response16.getBody().contains("\"termX\":\"D\""));
            Assert.assertTrue((String)response16.getBody(), (boolean)response16.getBody().contains("\"termX\":\"E\""));
        }
    }
}

