/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Map;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class DlsWriteIntTest {
    static final TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").indexPermissions(new String[]{"*"}).on(new String[]{"*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DLS_USER = new TestSgConfig.User("dls_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").indexPermissions(new String[]{"SGS_MANAGE", "SGS_CRUD"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_d")).on(new String[]{"dls_*"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    public static final String LOGSDB_INDEX_POSTFIX = "logsdb";
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).users(new TestSgConfig.User[]{ADMIN, DLS_USER}).resources("dlsfls").build();

    @Test
    public void newIndex_allowedRead() throws Exception {
        GenericRestClient.HttpResponse response;
        String index = "/dls_new_index_allowed_read";
        String doc1uri = index + "/_doc/1";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER, new Header[0]);){
            response = client.putJson(doc1uri + "?refresh=true", (Document)DocNode.of((String)"payload", (Object)"foo", (String)"dept", (Object)"dept_d"));
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.get(doc1uri, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(doc1uri, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void newIndex_disallowedRead() throws Exception {
        GenericRestClient.HttpResponse response;
        String index = "/dls_new_index_disallowed_read";
        String doc1uri = index + "/_doc/1";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_USER, new Header[0]);){
            response = client.putJson(doc1uri + "?refresh=true", (Document)DocNode.of((String)"payload", (Object)"foo", (String)"dept", (Object)"dept_e"));
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.get(doc1uri, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)404L, (long)response.getStatusCode());
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(doc1uri, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

