/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsModule;
import com.floragunn.searchguard.enterprise.dlsfls.ThreadContextAuthzHashProvider;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.junit.Assert;
import org.junit.Test;

public class ThreadContextAuthzHashProviderTest {
    static final StaticSettings ENABLED_SETTINGS = StaticSettings.ofBoolean((StaticSettings.Attribute)DlsFlsModule.PROVIDE_THREAD_CONTEXT_AUTHZ_HASH, (boolean)true);
    static final User TEST_USER = User.forUser((String)"test_user").attribute("x", (Object)1).build();
    static final NamedXContentRegistry X_CONTENT_REGISTRY = new NamedXContentRegistry((List)ImmutableList.of((Object)new NamedXContentRegistry.Entry(QueryBuilder.class, new ParseField("term", new String[0]), p -> TermQueryBuilder.fromXContent((XContentParser)p))));
    static final ConfigurationRepository.Context PARSER_CONTEXT = new ConfigurationRepository.Context(null, null, null, X_CONTENT_REGISTRY, null);

    @Test
    public void restrictionsInfo_basic() throws Exception {
        ThreadContextAuthzHashProvider subject = new ThreadContextAuthzHashProvider(ENABLED_SETTINGS, new ThreadContext(Settings.EMPTY));
        PrivilegesEvaluationContext ctx = ThreadContextAuthzHashProviderTest.ctx(TEST_USER, "role_1");
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("role_1:\n  index_permissions:\n  - index_patterns: ['protected_index_*']\n    dls: '{\"term\" : {\"department\" : 1}}}'\n  - index_patterns: ['unprotected_index_*']\n"), (CType)CType.ROLES, (ConfigurationRepository.Context)PARSER_CONTEXT).get();
        String info = subject.restrictionsInfo(ctx, roles);
        Assert.assertEquals((Object)"[unprotected_index_*]::{protected_index_*=[dls:{\"term\" : {\"department\" : 1}}}, fls: [], fm: []]}", (Object)info);
    }

    @Test
    public void restrictionsInfo_indexPermissionTemplate() throws Exception {
        ThreadContextAuthzHashProvider subject = new ThreadContextAuthzHashProvider(ENABLED_SETTINGS, new ThreadContext(Settings.EMPTY));
        PrivilegesEvaluationContext ctx = ThreadContextAuthzHashProviderTest.ctx(TEST_USER, "role_1");
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.parse((Format)Format.YAML).from("role_1:\n  index_permissions:\n  - index_patterns: ['protected_index_${user.attr.x}']\n    dls: '{\"term\" : {\"department\" : 1}}}'\n  - index_patterns: ['unprotected_index_*']\n"), (CType)CType.ROLES, (ConfigurationRepository.Context)PARSER_CONTEXT).get();
        String info = subject.restrictionsInfo(ctx, roles);
        Assert.assertEquals((Object)"test_user::{\"x\":1}::[role_1]", (Object)info);
    }

    private static PrivilegesEvaluationContext ctx(User user, String ... roles) {
        return new PrivilegesEvaluationContext(user, false, ImmutableSet.ofArray((Object[])roles), null, (Object)roles, true, null, null);
    }
}

