/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DlsFlsProcessedConfigTest {
    private static final ValidationError VALIDATION_ERROR_1 = new ValidationError("attribute-1", "error-message-1");
    private static final ValidationError VALIDATION_ERROR_2 = new ValidationError("attribute-2", "error-message-2");
    private static final String INVALID_ROLE_1 = "my-invalid-role-1";
    private static final String INVALID_ROLE_2 = "my-invalid-role-2";
    private static final String INVALID_MAPPING_1 = "my-invalid-mapping-1";
    private static final String INVALID_MAPPING_2 = "my-invalid-mapping-2";
    private DlsFlsProcessedConfig config;
    @Mock
    private DlsFlsConfig dlsDlsConfig;
    @Mock
    private ValidationErrors rolesMapingdValidationErrors;
    @Mock
    private ValidationErrors rolesValidationErrors;
    @Mock
    private RoleBasedFieldMasking fieldMasking;
    @Mock
    private RoleBasedFieldAuthorization fieldAuthorization;
    @Mock
    private RoleBasedDocumentAuthorization documentAuthorization;

    @Test
    public void shouldSupportNullValidationErrors() {
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, null, null);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void shouldNotContainValidationErrors() {
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void shouldReturnRoleValidationErrorForRoles() {
        Mockito.when((Object)this.rolesValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_ROLE_1, Collections.singleton(VALIDATION_ERROR_1)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_ROLE_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
    }

    @Test
    public void shouldReturnMultipleRoleValidationError() {
        Mockito.when((Object)this.rolesValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_ROLE_1, Collections.singleton(VALIDATION_ERROR_1), (Object)INVALID_ROLE_2, Collections.singleton(VALIDATION_ERROR_2)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_ROLE_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_ROLE_2));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_2.getMessage()));
    }

    @Test
    public void shouldReturnMultipleValidationErrorForSameRole() {
        Mockito.when((Object)this.rolesValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_ROLE_1, Arrays.asList(VALIDATION_ERROR_1, VALIDATION_ERROR_2)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_ROLE_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_2.getMessage()));
    }

    @Test
    public void shouldReturnRoleValidationErrorForRolesMappings() {
        Mockito.when((Object)this.rolesMapingdValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesMapingdValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_MAPPING_1, Collections.singleton(VALIDATION_ERROR_1)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_MAPPING_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
    }

    @Test
    public void shouldReturnMultipleRoleMappingValidationError() {
        Mockito.when((Object)this.rolesMapingdValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesMapingdValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_MAPPING_1, Collections.singleton(VALIDATION_ERROR_1), (Object)INVALID_MAPPING_2, Collections.singleton(VALIDATION_ERROR_2)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_MAPPING_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_MAPPING_2));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_2.getMessage()));
    }

    @Test
    public void shouldReturnMultipleValidationErrorForSameMappingsRole() {
        Mockito.when((Object)this.rolesMapingdValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesMapingdValidationErrors.getErrors()).thenReturn(Map.of(INVALID_MAPPING_1, Arrays.asList(VALIDATION_ERROR_1, VALIDATION_ERROR_2)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_MAPPING_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_2.getMessage()));
    }

    @Test
    public void shouldReturnValidationErrorsForRolesAndMappings() {
        Mockito.when((Object)this.rolesValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_ROLE_1, Collections.singleton(VALIDATION_ERROR_1)));
        Mockito.when((Object)this.rolesMapingdValidationErrors.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.rolesMapingdValidationErrors.getErrors()).thenReturn((Object)ImmutableMap.of((Object)INVALID_MAPPING_2, Collections.singleton(VALIDATION_ERROR_2)));
        this.config = new DlsFlsProcessedConfig(this.dlsDlsConfig, this.documentAuthorization, this.fieldAuthorization, this.fieldMasking, null, this.rolesValidationErrors, this.rolesMapingdValidationErrors);
        MatcherAssert.assertThat((Object)this.config.containsValidationError(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.config.getUniqueValidationErrorToken(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)this.config.getUniqueValidationErrorToken()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_ROLE_1));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)INVALID_MAPPING_2));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_1.getMessage()));
        MatcherAssert.assertThat((Object)this.config.getValidationErrorDescription(), (Matcher)Matchers.containsString((String)VALIDATION_ERROR_2.getMessage()));
    }
}

