/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DlsReadOnlyIntTests {
    static TestIndex index_1 = TestIndex.name((String)"index_1").documentCount(100).seed(1).attr("prefix", (Object)"a").setting("index.number_of_shards", 5).build();
    static TestIndex index_2 = TestIndex.name((String)"index_2").documentCount(110).seed(2).attr("prefix", (Object)"a").setting("index.number_of_shards", 5).build();
    static TestIndex index_3 = TestIndex.name((String)"index_3").documentCount(51).seed(4).attr("prefix", (Object)"b").setting("index.number_of_shards", 5).build();
    static TestIndex index_hidden = TestIndex.name((String)"index_hidden").documentCount(52).hidden().seed(8).attr("prefix", (Object)"h").build();
    static TestIndex user_dept_terms_lookup = TestIndex.name((String)"user_dept_terms_lookup").documentCount(0).customDocument("limited_user_index_1_dept_D_terms_lookup", (Map)ImmutableMap.of((Object)"dept", (Object)"dept_d")).hidden().build();
    static TestAlias alias_1 = new TestAlias("alias_1", new TestIndexLike[]{index_1});
    static TestAlias alias_12 = new TestAlias("alias_12", new TestIndexLike[]{index_1, index_2});
    static TestSgConfig.User LIMITED_USER_INDEX_1_DEPT_A = new TestSgConfig.User("limited_user_index_1_dept_A").description("dept_a in index_1").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"index_1"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_a"))}));
    static TestSgConfig.User LIMITED_USER_INDEX_1_DEPT_D = new TestSgConfig.User("limited_user_index_1_dept_D").description("dept_d in index_1").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_d")).on(new String[]{"index_1"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_d"))}));
    static TestSgConfig.User LIMITED_USER_INDEX_1_HIDDEN_DEPT_A = new TestSgConfig.User("limited_user_index_1_hidden_dept_A").description("dept_a in index_1 and index_hidden").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"index_1", "index_hidden"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_a")), index_hidden.filteredBy(node -> node.getAsString("dept").startsWith("dept_a"))}));
    static TestSgConfig.User LIMITED_USER_INDEX_1_DEPT_A_INDEX_2_DEPT_D = new TestSgConfig.User("limited_user_index_1_dept_A_index_2_dept_D").description("dept_a in index_1; dept_d in index_2").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"index_1"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_d")).on(new String[]{"index_2"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_a")), index_2.filteredBy(node -> node.getAsString("dept").startsWith("dept_d"))}));
    static TestSgConfig.User LIMITED_USER_ALIAS_1_DEPT_A = new TestSgConfig.User("limited_user_alias_1_dept_A").description("dept_a in alias_1").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).aliasPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"alias_1"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{alias_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_a")), index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_a"))}));
    static TestSgConfig.User LIMITED_USER_ALIAS_12_DEPT_D = new TestSgConfig.User("limited_user_alias_12_dept_D").description("dept_d in alias_12").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).aliasPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_d")).on(new String[]{"alias_12"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_d")), index_2.filteredBy(node -> node.getAsString("dept").startsWith("dept_d"))}));
    static TestSgConfig.User LIMITED_USER_ALIAS_12_DEPT_D_INDEX_1_DEPT_A = new TestSgConfig.User("limited_user_alias_12_dept_D_index_1_dept_a").description("dept_d in alias_12; additionally dept_a in index_1").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).aliasPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_d")).on(new String[]{"alias_12"}), new TestSgConfig.Role("r2").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"index_1"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_d") || node.getAsString("dept").startsWith("dept_a")), index_2.filteredBy(node -> node.getAsString("dept").startsWith("dept_d"))}));
    static TestSgConfig.User LIMITED_USER_INDEX_1_DEPT_D_TERMS_LOOKUP = new TestSgConfig.User("limited_user_index_1_dept_D_terms_lookup").description("dept_d in index_1 with terms lookup").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"terms", (Object)DocNode.of((String)"dept", (Object)DocNode.of((String)"index", (Object)"user_dept_terms_lookup", (String)"id", (Object)"${user.name}", (String)"path", (Object)"dept")))).on(new String[]{"index_1"})}).indexMatcher("read", IndexApiMatchers.limitedTo((TestIndexLike[])new TestIndexLike[]{index_1.filteredBy(node -> node.getAsString("dept").startsWith("dept_d"))}));
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").description("unlimited").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("r1").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR"}).indexPermissions(new String[]{"*"}).on(new String[]{"*"}).aliasPermissions(new String[]{"*"}).on(new String[]{"*"})}).indexMatcher("read", IndexApiMatchers.unlimited()).indexMatcher("read_top_level", IndexApiMatchers.unlimited()).indexMatcher("get_alias", IndexApiMatchers.unlimited());
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().indexMatcher("read", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("read_top_level", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices());
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)LIMITED_USER_INDEX_1_DEPT_A, (Object)LIMITED_USER_INDEX_1_DEPT_D, (Object)LIMITED_USER_INDEX_1_HIDDEN_DEPT_A, (Object[])new TestSgConfig.User[]{LIMITED_USER_INDEX_1_DEPT_A_INDEX_2_DEPT_D, LIMITED_USER_ALIAS_1_DEPT_A, LIMITED_USER_ALIAS_12_DEPT_D, LIMITED_USER_ALIAS_12_DEPT_D_INDEX_1_DEPT_A, LIMITED_USER_INDEX_1_DEPT_D_TERMS_LOOKUP, UNLIMITED_USER, SUPER_UNLIMITED_USER});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().users(USERS).indices(new TestIndex[]{index_1, index_2, index_3, index_hidden, user_dept_terms_lookup}).aliases(new TestAlias[]{alias_1, alias_12}).authzDebug(true).logRequests().dlsFls(DLSFLS).build();
    final TestSgConfig.User user;

    @Test
    public void search_noPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_all_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3, index_hidden, user_dept_terms_lookup, IndexApiMatchers.searchGuardIndices()}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_wildcard_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3, index_hidden, user_dept_terms_lookup, IndexApiMatchers.searchGuardIndices()}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_staticIndicies_hidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_hidden/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_hidden}).at("hits.hits[*]").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_alias_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_12/_search?size=1000&ignore_unavailable=true", new Header[0]);
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_1}).at("hits.hits[*]").but(this.user.indexMatcher("read")).isEmpty() || this.user == LIMITED_USER_ALIAS_1_DEPT_A) {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
            }
        }
    }

    @Test
    public void search_alias_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2}).at("hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_scroll_all() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_all/_search?scroll=1m&size=15", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            ArrayList hits = new ArrayList(response.getBodyAsDocNode().getAsNode("hits").getAsListOfNodes("hits"));
            String scrollId = response.getBodyAsDocNode().getAsString("_scroll_id");
            while (true) {
                GenericRestClient.HttpResponse scrollResponse = client.postJson("/_search/scroll", (Map)DocNode.of((String)"scroll", (Object)"1m", (String)"scroll_id", (Object)scrollId), new Header[0]);
                MatcherAssert.assertThat((Object)scrollResponse, (Matcher)RestMatchers.isOk());
                ImmutableList moreHits = scrollResponse.getBodyAsDocNode().getAsNode("hits").getAsListOfNodes("hits");
                if (moreHits.size() == 0) break;
                hits.addAll(moreHits);
            }
            MatcherAssert.assertThat(hits, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3}).but(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_aggregation_terms_all() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/_all/_search", (Map)DocNode.of((String)"query.match_all", (Object)DocNode.EMPTY, (String)"aggs.test_agg.terms.field", (Object)"dept.keyword"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2, index_3}).aggregateTerm("dept").at("aggregations.test_agg.buckets").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_aggregation_terms_static_index() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/index_1/_search", (Map)DocNode.of((String)"query.match_all", (Object)DocNode.EMPTY, (String)"aggs.test_agg.terms.field", (Object)"dept.keyword"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).aggregateTerm("dept").at("aggregations.test_agg.buckets").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_aggregation_terms_static_alias() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/alias_12/_search?ignore_unavailable=true", (Map)DocNode.of((String)"query.match_all", (Object)DocNode.EMPTY, (String)"aggs.test_agg.terms.field", (Object)"dept.keyword"), new Header[0]);
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_1}).at("hits.hits[*]").but(this.user.indexMatcher("read")).isEmpty() || this.user == LIMITED_USER_ALIAS_1_DEPT_A) {
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2}).aggregateTerm("dept").at("aggregations.test_agg.buckets").but(this.user.indexMatcher("read")).whenEmpty(200));
            }
        }
    }

    @Test
    public void msearch_staticIndices() throws Exception {
        String msearchBody = "{\"index\":\"index_1\"}\n{\"size\":200, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n{\"index\":\"index_2\"}\n{\"size\":200, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_msearch", msearchBody, new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1, index_2}).at("responses[*].hits.hits[*]").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void get() throws Exception {
        TestData.TestDocument testDocument1a1 = index_1.getTestData().anyDocumentForDepartment("dept_a_1");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/index_1/_doc/" + testDocument1a1.getId(), new Header[0]);
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).isCoveredBy(this.user.indexMatcher("read"))) {
                if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).but(this.user.indexMatcher("read")).containsDocument(testDocument1a1.getId())) {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
                } else {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isNotFound());
                }
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void get2() throws Exception {
        TestData.TestDocument testDocument1d = index_1.getTestData().anyDocumentForDepartment("dept_d");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/index_1/_doc/" + testDocument1d.getId(), new Header[0]);
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).isCoveredBy(this.user.indexMatcher("read"))) {
                if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).but(this.user.indexMatcher("read")).containsDocument(testDocument1d.getId())) {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
                } else {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isNotFound());
                }
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void get_alias() throws Exception {
        TestData.TestDocument testDocument1a1 = index_1.getTestData().anyDocumentForDepartment("dept_a_1");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/alias_1/_doc/" + testDocument1a1.getId(), new Header[0]);
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).isCoveredBy(this.user.indexMatcher("read")) && this.user != LIMITED_USER_ALIAS_12_DEPT_D) {
                if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).but(this.user.indexMatcher("read")).containsDocument(testDocument1a1.getId())) {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
                } else {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isNotFound());
                }
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void get_alias2() throws Exception {
        TestData.TestDocument testDocument1d = index_1.getTestData().anyDocumentForDepartment("dept_d");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/alias_1/_doc/" + testDocument1d.getId(), new Header[0]);
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).isCoveredBy(this.user.indexMatcher("read")) && this.user != LIMITED_USER_ALIAS_12_DEPT_D) {
                if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).but(this.user.indexMatcher("read")).containsDocument(testDocument1d.getId())) {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
                } else {
                    MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isNotFound());
                }
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void mget() throws Exception {
        TestData.TestDocument testDocument1a1 = index_1.getTestData().anyDocumentForDepartment("dept_a_1");
        TestData.TestDocument testDocument1b1 = index_1.getTestData().anyDocumentForDepartment("dept_b_1");
        TestData.TestDocument testDocument2a1 = index_2.getTestData().anyDocumentForDepartment("dept_a_1");
        TestData.TestDocument testDocument2b1 = index_2.getTestData().anyDocumentForDepartment("dept_b_1");
        DocNode mget = DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_index", (Object)"index_1", (String)"_id", (Object)testDocument1a1.getId()), DocNode.of((String)"_index", (Object)"index_1", (String)"_id", (Object)testDocument1b1.getId()), DocNode.of((String)"_index", (Object)"index_2", (String)"_id", (Object)testDocument2a1.getId()), DocNode.of((String)"_index", (Object)"index_2", (String)"_id", (Object)testDocument2b1.getId())}));
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.postJson("/_mget", (Map)mget, new Header[0]);
            if (this.user == LIMITED_USER_INDEX_1_DEPT_D_TERMS_LOOKUP) {
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
                Assert.assertEquals((String)response.getBody(), (Object)"Insufficient permissions", (Object)response.getBodyAsDocNode().get("error", new String[]{"reason"}));
            } else {
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                DocNode body = response.getBodyAsDocNode();
                this.checkMgetDocument(response, body, (TestIndexLike)index_1, testDocument1a1);
                this.checkMgetDocument(response, body, (TestIndexLike)index_1, testDocument1b1);
                this.checkMgetDocument(response, body, (TestIndexLike)index_2, testDocument2a1);
                this.checkMgetDocument(response, body, (TestIndexLike)index_2, testDocument2b1);
            }
        }
    }

    @Test
    public void mget_alias() throws Exception {
        TestData.TestDocument testDocument1a1 = index_1.getTestData().anyDocumentForDepartment("dept_a_1");
        TestData.TestDocument testDocument1b1 = index_1.getTestData().anyDocumentForDepartment("dept_b_1");
        DocNode mget = DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_index", (Object)"alias_1", (String)"_id", (Object)testDocument1a1.getId()), DocNode.of((String)"_index", (Object)"alias_1", (String)"_id", (Object)testDocument1b1.getId())}));
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.postJson("/_mget", (Map)mget, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            if (this.user == LIMITED_USER_INDEX_1_DEPT_D_TERMS_LOOKUP) {
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"docs", (int)0));
            } else {
                this.checkMgetDocument(response, body, (TestIndexLike)index_1, testDocument1a1);
                this.checkMgetDocument(response, body, (TestIndexLike)index_1, testDocument1b1);
            }
        }
    }

    private void checkMgetDocument(GenericRestClient.HttpResponse response, DocNode body, TestIndexLike testIndex, TestData.TestDocument testDocument) throws Exception {
        DocNode foundDocument = (DocNode)body.findSingleNodeByJsonPath("docs[?(@._id == \"" + testDocument.getId() + "\")]").toListOfNodes().get(0);
        Assert.assertNotNull((String)response.getBody(), (Object)foundDocument);
        if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{testIndex}).isCoveredBy(this.user.indexMatcher("read"))) {
            Boolean found = foundDocument.getBoolean("found");
            if (found == null) {
                Assert.fail((String)("No found attribute " + foundDocument.toString()));
            }
            if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{testIndex}).but(this.user.indexMatcher("read")).containsDocument(testDocument.getId())) {
                Assert.assertTrue((String)response.getBody(), (boolean)found);
            } else {
                Assert.assertFalse((String)response.getBody(), (boolean)found);
            }
        } else {
            Assert.assertEquals((String)response.getBody(), (Object)"Insufficient permissions", (Object)foundDocument.get("error", new String[]{"reason"}));
        }
    }

    @Test
    public void termvectors() throws Exception {
        TestData.TestDocument testDocument1a1 = index_1.getTestData().anyDocumentForDepartment("dept_a_1");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/index_1/_termvectors/" + testDocument1a1.getId(), new Header[0]);
            if (this.user == LIMITED_USER_INDEX_1_DEPT_D_TERMS_LOOKUP) {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isInternalServerError());
                Assert.assertTrue((String)httpResponse.getBody(), (boolean)httpResponse.getBodyAsDocNode().getAsNode("error").getAsString("reason").startsWith("Unsupported request type for filter level DLS"));
            } else if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).isCoveredBy(this.user.indexMatcher("read"))) {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
                if (IndexApiMatchers.containsExactly((TestIndexLike[])new TestIndexLike[]{index_1}).but(this.user.indexMatcher("read")).containsDocument(testDocument1a1.getId())) {
                    Assert.assertEquals((String)httpResponse.getBody(), (Object)true, (Object)httpResponse.getBodyAsDocNode().get("found"));
                } else {
                    Assert.assertEquals((String)httpResponse.getBody(), (Object)false, (Object)httpResponse.getBodyAsDocNode().get("found"));
                }
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (TestSgConfig.User user : USERS) {
            result.add(new Object[]{user, user.getDescription()});
        }
        return result;
    }

    public DlsReadOnlyIntTests(TestSgConfig.User user, String description) throws Exception {
        this.user = user;
    }
}

