/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.JavaSecurityTestSetup;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class HttpIntegrationTests
extends SingleClusterTest {
    @ClassRule
    public static JavaSecurityTestSetup javaSecurity = new JavaSecurityTestSetup();

    protected String getResourceFolder() {
        return "multitenancy_legacy";
    }

    @Test
    public void testHTTPBasic() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("sg_tenant", "unittesttenant"), HttpIntegrationTests.encodeBasicHeader((String)"worf", (String)"worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("unittesttenant"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"kltentrw\":true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\":\"worf\""));
        res = rh.executeGetRequest("_searchguard/authinfo", new Header[]{HttpIntegrationTests.encodeBasicHeader((String)"worf", (String)"worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_requested_tenant\":null"));
        Assert.assertTrue((boolean)res.getBody().contains("\"kltentrw\":true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\":\"worf\""));
        Assert.assertTrue((boolean)res.getBody().contains("\"custom_attribute_names\":[]"));
        Assert.assertFalse((boolean)res.getBody().contains("attributes="));
    }
}

