/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.searchguard.enterprise.femt.TenantAccessMatcher;
import com.floragunn.searchguard.legacy.test.AbstractSGUnitTest;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class MultitenancyTests {
    private static final TestSgConfig.User USER_DEPT_01 = new TestSgConfig.User("user_dept_01").attr("dept_no", (Object)"01").roles(new String[]{"sg_tenant_user_attrs"});
    private static final TestSgConfig.User USER_DEPT_02 = new TestSgConfig.User("user_dept_02").attr("dept_no", (Object)"02").roles(new String[]{"sg_tenant_user_attrs"});
    private static final TestSgConfig.User HR_USER_READ_ONLY = new TestSgConfig.User("hr_user_read_only").roles(new String[]{"hr_tenant_read_only_access"});
    private static final TestSgConfig.User HR_USER_READ_WRITE = new TestSgConfig.User("hr_user_read_write").roles(new String[]{"hr_tenant_read_write_access"});
    public static final String TENANT_WRITABLE = Boolean.toString(true);
    public static final String TENANT_NOT_WRITABLE = Boolean.toString(false);
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().resources("multitenancy").enterpriseModulesEnabled().users(new TestSgConfig.User[]{USER_DEPT_01, USER_DEPT_02, HR_USER_READ_ONLY, HR_USER_READ_WRITE}).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMt() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("hr_employee", "hr_employee", new Header[0]);){
            String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
            GenericRestClient.HttpResponse response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "blafasel")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            response = client.delete(".kibana", new Header[]{new BasicHeader("sgtenant", "business_intelligence")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "business_intelligence")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "human_resources")});
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)Pattern.create((String)"*.kibana_*_humanresources*").matches(response.getBody()));
            response = client.get(".kibana/_doc/5.6.0?pretty", new Header[]{new BasicHeader("sgtenant", "human_resources")});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)Pattern.create((String)"*human_resources*").matches(response.getBody()));
        }
        finally {
            try (Client tc = cluster.getInternalNodeClient();){
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana_1592542611_humanresources")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testMtMulti() throws Exception {
        try (Client tc = cluster.getInternalNodeClient();){
            String body = "{\"type\" : \"index-pattern\",\"updated_at\" : \"2018-09-29T08:56:59.066Z\",\"index-pattern\" : {\"title\" : \"humanresources\"}}";
            tc.admin().indices().create(new CreateIndexRequest(".kibana_92668751_admin").settings((Map)ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0))).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_92668751_admin").id("index-pattern:9fbbd1a0-c3c5-11e8-a13f-71b8ea5a4f7b").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
        }
        try (GenericRestClient client = cluster.getRestClient("admin", "admin", new Header[0]);){
            System.out.println("#### search");
            String body = "{\"query\" : {\"term\" : { \"_id\" : \"index-pattern:9fbbd1a0-c3c5-11e8-a13f-71b8ea5a4f7b\"}}}";
            GenericRestClient.HttpResponse res = client.postJson(".kibana/_search/?pretty", body, new Header[]{new BasicHeader("sgtenant", "__user__")});
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertFalse((boolean)res.getBody().contains("exception"));
            Assert.assertTrue((boolean)res.getBody().contains("humanresources"));
            Assert.assertTrue((boolean)res.getBody().contains("\"value\" : 1"));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
            System.out.println("#### msearch");
            body = "{\"index\":\".kibana\", \"ignore_unavailable\": false}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
            res = client.postJson("_msearch/?pretty", body, new Header[]{new BasicHeader("sgtenant", "__user__")});
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertFalse((boolean)res.getBody().contains("exception"));
            Assert.assertTrue((boolean)res.getBody().contains("humanresources"));
            Assert.assertTrue((boolean)res.getBody().contains("\"value\" : 1"));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
            System.out.println("#### get");
            res = client.get(".kibana/_doc/index-pattern:9fbbd1a0-c3c5-11e8-a13f-71b8ea5a4f7b?pretty", new Header[]{new BasicHeader("sgtenant", "__user__")});
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertFalse((boolean)res.getBody().contains("exception"));
            Assert.assertTrue((boolean)res.getBody().contains("humanresources"));
            Assert.assertTrue((boolean)res.getBody().contains("\"found\" : true"));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
            System.out.println("#### mget");
            body = "{\"docs\" : [{\"_index\" : \".kibana\",\"_id\" : \"index-pattern:9fbbd1a0-c3c5-11e8-a13f-71b8ea5a4f7b\"}]}";
            res = client.postJson("_mget/?pretty", body, new Header[]{new BasicHeader("sgtenant", "__user__")});
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertFalse((boolean)res.getBody().contains("exception"));
            Assert.assertTrue((boolean)res.getBody().contains("humanresources"));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
            System.out.println("#### index");
            body = "{\"type\" : \"index-pattern\",\"updated_at\" : \"2017-09-29T08:56:59.066Z\",\"index-pattern\" : {\"title\" : \"xyz\"}}";
            res = client.putJson(".kibana/_doc/abc?pretty", body, new Header[]{new BasicHeader("sgtenant", "__user__")});
            Assert.assertEquals((long)201L, (long)res.getStatusCode());
            Assert.assertFalse((boolean)res.getBody().contains("exception"));
            Assert.assertTrue((boolean)res.getBody().contains("\"result\" : \"created\""));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
            System.out.println("#### bulk");
            body = "{ \"index\" : { \"_index\" : \".kibana\", \"_id\" : \"b1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \".kibana\",\"_id\" : \"b2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator();
            res = client.putJson("_bulk?pretty", body, new Header[]{new BasicHeader("sgtenant", "__user__")});
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertFalse((boolean)res.getBody().contains("exception"));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
            Assert.assertTrue((boolean)res.getBody().contains("\"errors\" : false"));
            Assert.assertTrue((boolean)res.getBody().contains("\"result\" : \"created\""));
            res = client.get("_cat/indices", new Header[0]);
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_92668751_admin"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKibanaAlias() throws Exception {
        Client tc;
        try {
            tc = cluster.getInternalNodeClient();
            try {
                String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
                tc.admin().indices().create(new CreateIndexRequest(".kibana-6").alias(new Alias(".kibana")).settings((Map)ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0))).actionGet();
                tc.index(((IndexRequest)new IndexRequest(".kibana-6").id("6.2.2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
            }
            finally {
                if (tc != null) {
                    tc.close();
                }
            }
            try (GenericRestClient client = cluster.getRestClient("kibanaro", "kibanaro", new Header[0]);){
                GenericRestClient.HttpResponse res = client.get(".kibana-6/_doc/6.2.2?pretty", new Header[0]);
                Assert.assertEquals((long)200L, (long)res.getStatusCode());
                res = client.get(".kibana/_doc/6.2.2?pretty", new Header[0]);
                Assert.assertEquals((long)200L, (long)res.getStatusCode());
                System.out.println(res.getBody());
            }
        }
        finally {
            try {
                tc = cluster.getInternalNodeClient();
                try {
                    tc.admin().indices().delete(new DeleteIndexRequest(".kibana-6")).actionGet();
                }
                finally {
                    if (tc != null) {
                        tc.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKibanaAlias65() throws Exception {
        Client tc;
        try {
            tc = cluster.getInternalNodeClient();
            try {
                String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
                HashMap<String, Integer> indexSettings = new HashMap<String, Integer>();
                indexSettings.put("number_of_shards", 1);
                indexSettings.put("number_of_replicas", 0);
                tc.admin().indices().create(new CreateIndexRequest(".kibana_1").alias(new Alias(".kibana")).settings(indexSettings)).actionGet();
                tc.index(((IndexRequest)new IndexRequest(".kibana_1").id("6.2.2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
                tc.index(((IndexRequest)new IndexRequest(".kibana_-900636979_kibanaro").id("6.2.2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
            }
            finally {
                if (tc != null) {
                    tc.close();
                }
            }
            try (GenericRestClient client = cluster.getRestClient("kibanaro", "kibanaro", new Header[0]);){
                GenericRestClient.HttpResponse res = client.get(".kibana/_doc/6.2.2?pretty", new Header[]{new BasicHeader("sgtenant", "__user__")});
                Assert.assertEquals((long)200L, (long)res.getStatusCode());
                System.out.println(res.getBody());
                Assert.assertTrue((boolean)res.getBody().contains(".kibana_-900636979_kibanaro"));
            }
        }
        finally {
            try {
                tc = cluster.getInternalNodeClient();
                try {
                    tc.admin().indices().delete(new DeleteIndexRequest(".kibana_1")).actionGet();
                }
                finally {
                    if (tc != null) {
                        tc.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKibanaAliasKibana_7_12() throws Exception {
        Client tc;
        try {
            tc = cluster.getInternalNodeClient();
            try {
                String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
                tc.admin().indices().create(new CreateIndexRequest(".kibana_-815674808_kibana712aliastest_7.12.0_001").alias(new Alias(".kibana_-815674808_kibana712aliastest_7.12.0")).settings((Map)ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0))).actionGet();
                tc.index(((IndexRequest)new IndexRequest(".kibana_-815674808_kibana712aliastest_7.12.0").id("test").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
            }
            finally {
                if (tc != null) {
                    tc.close();
                }
            }
            try (GenericRestClient client = cluster.getRestClient("admin", "admin", "kibana_7_12_alias_test");){
                GenericRestClient.HttpResponse response = client.get(".kibana_7.12.0/_doc/test", new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertEquals((String)response.getBody(), (Object)".kibana_-815674808_kibana712aliastest_7.12.0_001", (Object)response.getBodyAsDocNode().getAsString("_index"));
            }
        }
        finally {
            try {
                tc = cluster.getInternalNodeClient();
                try {
                    tc.admin().indices().delete(new DeleteIndexRequest(".kibana_-815674808_kibana712aliastest_7.12.0_001")).actionGet();
                }
                finally {
                    if (tc != null) {
                        tc.close();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAliasCreationKibana_7_12() throws Exception {
        try (RestHighLevelClient tenantClient = cluster.getRestHighLevelClient("admin", "admin", "kibana_7_12_alias_creation_test");
             Client client = cluster.getInternalNodeClient();){
            IndexResponse indexResponse = tenantClient.index((IndexRequest)new IndexRequest(".kibana_7.12.0_001").id("test").source((Map)ImmutableMap.of((Object)"buildNum", (Object)15460)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), RequestOptions.DEFAULT);
            Assert.assertEquals((String)indexResponse.toString(), (Object)indexResponse.getResult(), (Object)DocWriteResponse.Result.CREATED);
            Assert.assertEquals((String)indexResponse.toString(), (Object)".kibana_1482524924_kibana712aliascreationtest_7.12.0_001", (Object)indexResponse.getIndex());
            AcknowledgedResponse ackResponse = tenantClient.indices().updateAliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(".kibana_7.12.0_001").alias(".kibana_7.12.0")), RequestOptions.DEFAULT);
            Assert.assertTrue((String)ackResponse.toString(), (boolean)ackResponse.isAcknowledged());
            GetResponse getResponse = tenantClient.get(new GetRequest(".kibana_7.12.0", "test"), RequestOptions.DEFAULT);
            Assert.assertEquals((String)getResponse.toString(), (Object)".kibana_1482524924_kibana712aliascreationtest_7.12.0_001", (Object)getResponse.getIndex());
            GetAliasesResponse getAliasesResponse = (GetAliasesResponse)client.admin().indices().getAliases(new GetAliasesRequest(new String[]{".kibana_1482524924_kibana712aliascreationtest_7.12.0"})).actionGet();
            Assert.assertNotNull((String)getAliasesResponse.getAliases().toString(), (Object)getAliasesResponse.getAliases().get((Object)".kibana_1482524924_kibana712aliascreationtest_7.12.0_001"));
            Assert.assertEquals((String)getAliasesResponse.getAliases().toString(), (Object)".kibana_1482524924_kibana712aliascreationtest_7.12.0", (Object)((AliasMetadata)((List)getAliasesResponse.getAliases().get((Object)".kibana_1482524924_kibana712aliascreationtest_7.12.0_001")).get(0)).alias());
        }
        finally {
            try (Client tc = cluster.getInternalNodeClient();){
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana_1482524924_kibana712aliascreationtest_7.12.0_001")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMgetWithKibanaAlias() throws Exception {
        String indexName = ".kibana_1592542611_humanresources";
        String testDoc = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
        try (Client client = cluster.getInternalNodeClient();
             RestHighLevelClient restClient = cluster.getRestHighLevelClient("hr_employee", "hr_employee", "human_resources");){
            HashMap<String, Integer> indexSettings = new HashMap<String, Integer>();
            indexSettings.put("number_of_shards", 3);
            indexSettings.put("number_of_replicas", 0);
            client.admin().indices().create(new CreateIndexRequest(indexName + "_2").alias(new Alias(indexName)).settings(indexSettings)).actionGet();
            MultiGetRequest multiGetRequest = new MultiGetRequest();
            for (int i = 0; i < 100; ++i) {
                client.index(((IndexRequest)new IndexRequest(indexName).id("d" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(testDoc, XContentType.JSON)).actionGet();
                multiGetRequest.add(new MultiGetRequest.Item(".kibana", "d" + i));
            }
            MultiGetResponse response = restClient.mget(multiGetRequest, RequestOptions.DEFAULT);
            for (MultiGetItemResponse item : response.getResponses()) {
                if (item.getFailure() == null) continue;
                Assert.fail((String)(item.getFailure().getMessage() + "\n" + item.getFailure()));
            }
        }
        finally {
            try (Client tc = cluster.getInternalNodeClient();){
                tc.admin().indices().delete(new DeleteIndexRequest(indexName + "_2")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserAttributesInTenantPattern() throws Exception {
        try {
            GenericRestClient.HttpResponse response;
            try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_DEPT_01, new Header[0]);){
                response = restClient.get("_searchguard/authinfo", new Header[0]);
                Assert.assertEquals((String)response.getBody(), (Object)"true", (Object)response.getBodyAsDocNode().getAsNode("sg_tenants", new String[]{"dept_01"}).toString());
                Assert.assertNull((Object)response.getBodyAsDocNode().get("sg_tenants", new String[]{"dept_02"}));
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_01")});
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_02")});
                Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            }
            restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_DEPT_02, new Header[0]);
            try {
                response = restClient.get("_searchguard/authinfo", new Header[0]);
                Assert.assertNull((Object)response.getBodyAsDocNode().get("sg_tenants", new String[]{"dept_01"}));
                Assert.assertEquals((Object)"true", (Object)response.getBodyAsDocNode().getAsNode("sg_tenants", new String[]{"dept_02"}).toString());
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_01")});
                Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_02")});
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            }
            finally {
                if (restClient != null) {
                    restClient.close();
                }
            }
        }
        finally {
            try (Client tc = cluster.getInternalNodeClient();){
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana_1592542611_humanresources")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void checksActionsOfReadOnlyUserAgainstMultitenancy() throws Exception {
        String tenant = "test_tenant_ro";
        BasicHeader header = new BasicHeader("sgtenant", "test_tenant_ro");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)HR_USER_READ_ONLY, new Header[]{header});){
            MultitenancyTests.assertAdminCanCreateTenantIndex(restClient, "test_tenant_ro");
            MultitenancyTests.assertTenantWriteable(restClient, "test_tenant_ro", TENANT_NOT_WRITABLE);
            MatcherAssert.assertThat((Object)restClient, TenantAccessMatcher.canPerformFollowingActions(EnumSet.noneOf(TenantAccessMatcher.Action.class)));
        }
    }

    @Test
    public void checksActionsOfReadWriteUserAgainstMultitenancy() throws Exception {
        String tenant = "test_tenant_rw";
        BasicHeader header = new BasicHeader("sgtenant", "test_tenant_rw");
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)HR_USER_READ_WRITE, new Header[]{header});){
            MultitenancyTests.assertAdminCanCreateTenantIndex(restClient, "test_tenant_rw");
            MultitenancyTests.assertTenantWriteable(restClient, "test_tenant_rw", TENANT_WRITABLE);
            MatcherAssert.assertThat((Object)restClient, TenantAccessMatcher.canPerformFollowingActions(EnumSet.of(TenantAccessMatcher.Action.CREATE_DOCUMENT, TenantAccessMatcher.Action.UPDATE_DOCUMENT, TenantAccessMatcher.Action.UPDATE_INDEX, TenantAccessMatcher.Action.DELETE_INDEX)));
        }
    }

    @Test
    public void checksActionsOfReadOnlyAnonymousAgainstMultitenancy() throws Exception {
        String tenant = "sg_anonymous";
        BasicHeader header = new BasicHeader("sgtenant", "sg_anonymous");
        try (GenericRestClient restClient = cluster.getRestClient(new Header[]{header});){
            MultitenancyTests.assertAdminCanCreateTenantIndex(restClient, "sg_anonymous");
            MultitenancyTests.assertTenantWriteable(restClient, "sg_anonymous", TENANT_NOT_WRITABLE);
            MatcherAssert.assertThat((Object)restClient, TenantAccessMatcher.canPerformFollowingActions(EnumSet.noneOf(TenantAccessMatcher.Action.class)));
        }
    }

    @Test
    public void checksActionsOfReadWriteAnonymousAgainstMultitenancy() throws Exception {
        String tenant = "anonymous_rw";
        BasicHeader header = new BasicHeader("sgtenant", "anonymous_rw");
        try (GenericRestClient restClient = cluster.getRestClient(new Header[]{header});){
            MultitenancyTests.assertAdminCanCreateTenantIndex(restClient, "anonymous_rw");
            MultitenancyTests.assertTenantWriteable(restClient, "anonymous_rw", TENANT_WRITABLE);
            MatcherAssert.assertThat((Object)restClient, TenantAccessMatcher.canPerformFollowingActions(EnumSet.of(TenantAccessMatcher.Action.CREATE_DOCUMENT, TenantAccessMatcher.Action.UPDATE_DOCUMENT, TenantAccessMatcher.Action.UPDATE_INDEX, TenantAccessMatcher.Action.DELETE_INDEX)));
        }
    }

    private static void assertTenantWriteable(GenericRestClient restClient, String tenant, String isTenantWritable) throws Exception {
        GenericRestClient.HttpResponse authInfo = restClient.get("/_searchguard/authinfo?pretty", new Header[0]);
        MatcherAssert.assertThat((String)authInfo.getBody(), (Object)authInfo.getBodyAsDocNode().findByJsonPath("sg_tenants." + tenant).get(0).toString(), (Matcher)Matchers.equalTo((Object)isTenantWritable));
    }

    private static void assertAdminCanCreateTenantIndex(GenericRestClient restClient, String tenant) throws Exception {
        GenericRestClient.HttpResponse adminIndexDocToCreateTenant = restClient.putJson(".kibana/_doc/5.6.0", "{\"buildNum\": 15460, \"defaultIndex\": \"anon\", \"tenant\": \"" + tenant + "\"}", new Header[]{AbstractSGUnitTest.encodeBasicHeader((String)"admin", (String)"admin")});
        MatcherAssert.assertThat((String)adminIndexDocToCreateTenant.getBody(), (Object)adminIndexDocToCreateTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
    }
}

