/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.RoleBasedActionAuthorization;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.PrivilegesInterceptorImpl;
import com.floragunn.searchguard.user.User;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class PrivilegesInterceptorImplTest {
    private static final ActionGroup.FlattenedIndex emptyActionGroups = new ActionGroup.FlattenedIndex(SgDynamicConfiguration.empty((CType)CType.ACTIONGROUPS));
    private static final Actions actions = new Actions(null);

    @Test
    public void wildcardTenantMapping() throws Exception {
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"all_access", (Object)DocNode.of((String)"tenant_permissions", Arrays.asList(ImmutableMap.of((Object)"tenant_patterns", Arrays.asList("*"), (Object)"allowed_actions", Arrays.asList("*"))))), (CType)CType.ROLES, null).get();
        ImmutableSet tenants = ImmutableSet.of((Object)"my_tenant", (Object)"test");
        RoleBasedActionAuthorization actionAuthorization = new RoleBasedActionAuthorization(roles, emptyActionGroups, actions, null, (Set)tenants);
        PrivilegesInterceptorImpl subject = new PrivilegesInterceptorImpl(FeMultiTenancyConfig.DEFAULT, tenants, actions);
        User user = User.forUser((String)"test").searchGuardRoles(new String[]{"all_access"}).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"test", (Object)true, (Object)"my_tenant", (Object)true), (Object)subject.mapTenants(user, ImmutableSet.of((Object)"all_access"), (ActionAuthorization)actionAuthorization));
    }
}

