/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class TenantInfoActionTest {
    private static final TestSgConfig.User KIBANA_SERVER = new TestSgConfig.User("kibanaserver").roles(new String[]{"SGS_KIBANA_SERVER"});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().resources("multitenancy").user(KIBANA_SERVER).enterpriseModulesEnabled().users(new TestSgConfig.User[]{KIBANA_SERVER}).build();

    @Test
    public void testTenantInfo() throws Exception {
        try (Client tc = cluster.getInternalNodeClient();){
            tc.index(((IndexRequest)new IndexRequest(".kibana-6").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-1139640511_admin1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-1386441176_praxisrw").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-634608247_abcdef22").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-12345_123456").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana2_-12345_123456").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_9876_xxx_ccc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_fff_eee").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("esb-prod-5").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":5}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{".kibana-6"}).alias(".kibana"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-5"}).alias(".kibana_-2014056163_kltentrw"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-5"}).alias("esb-alias-5"))).actionGet();
        }
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)KIBANA_SERVER, new Header[0]);){
            GenericRestClient.HttpResponse res = client.get("/_searchguard/tenantinfo?pretty", new Header[0]);
            System.out.println(res.getBody());
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-1139640511_admin1\" : \"admin_1\""));
            Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-1386441176_praxisrw\" : \"praxisrw\""));
            Assert.assertTrue((boolean)res.getBody().contains(".kibana_-2014056163_kltentrw\" : \"kltentrw\""));
            Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-634608247_abcdef22\" : \"abcdef_2_2\""));
            Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-12345_123456\" : \"__private__\""));
            Assert.assertFalse((boolean)res.getBody().contains(".kibana-6"));
            Assert.assertFalse((boolean)res.getBody().contains("esb-"));
            Assert.assertFalse((boolean)res.getBody().contains("xxx"));
            Assert.assertFalse((boolean)res.getBody().contains(".kibana2"));
        }
    }
}

