/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.searchguard.enterprise.femt.TenantAccessMatcher;
import com.floragunn.searchguard.test.GenericRestClient;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class TenantsActionsMatcher
extends TypeSafeDiagnosingMatcher<GenericRestClient> {
    private final EnumSet<TenantAccessMatcher.Action> allowedActions;

    public TenantsActionsMatcher(EnumSet<TenantAccessMatcher.Action> allowedActions) {
        this.allowedActions = allowedActions;
    }

    protected boolean matchesSafely(GenericRestClient restClient, Description mismatchDescription) {
        try {
            int expectedStatus;
            GenericRestClient.HttpResponse search = restClient.get(".kibana/_search", new Header[0]);
            if (search.getStatusCode() != 200) {
                mismatchDescription.appendText(".kibana/_search GET call response is not HTTP/200");
                return false;
            }
            GenericRestClient.HttpResponse msearch = restClient.postJson(".kibana/_msearch", "{}\n{\"query\":{\"match_all\":{}}}\n", new Header[0]);
            if (msearch.getStatusCode() != 200) {
                mismatchDescription.appendText(".kibana/_msearch POST call response is not HTTP/200");
                return false;
            }
            GenericRestClient.HttpResponse mget = restClient.postJson(".kibana/_mget", "{\"docs\":[{\"_id\":\"5.6.0\"}]}", new Header[0]);
            if (mget.getStatusCode() != 200) {
                mismatchDescription.appendText(".kibana/_mget POST call response is not HTTP/200");
                return false;
            }
            GenericRestClient.HttpResponse getDoc = restClient.get(".kibana/_doc/5.6.0", new Header[0]);
            if (getDoc.getStatusCode() != 200) {
                mismatchDescription.appendText(".kibana/_doc/5.6.0 GET call response is not HTTP/200");
                return false;
            }
            GenericRestClient.HttpResponse createDoc = restClient.postJson(".kibana/_doc", "{}", new Header[0]);
            int n = expectedStatus = this.allowedActions.contains((Object)TenantAccessMatcher.Action.CREATE_DOCUMENT) ? 201 : 403;
            if (createDoc.getStatusCode() != expectedStatus) {
                mismatchDescription.appendText(".kibana/_doc POST call response is not HTTP/").appendValue((Object)expectedStatus);
                return false;
            }
            GenericRestClient.HttpResponse updateDoc = restClient.putJson(".kibana/_doc/5.6.0", "{}", new Header[0]);
            int n2 = expectedStatus = this.allowedActions.contains((Object)TenantAccessMatcher.Action.UPDATE_DOCUMENT) ? 200 : 403;
            if (updateDoc.getStatusCode() != expectedStatus) {
                mismatchDescription.appendText(".kibana/_doc/5.6.0 PUT call response is not HTTP/").appendValue((Object)expectedStatus);
                return false;
            }
            GenericRestClient.HttpResponse deleteDoc = restClient.delete(".kibana/_doc/5.6.0", new Header[0]);
            int n3 = expectedStatus = this.allowedActions.contains((Object)TenantAccessMatcher.Action.UPDATE_DOCUMENT) ? 200 : 403;
            if (deleteDoc.getStatusCode() != expectedStatus) {
                mismatchDescription.appendText(".kibana/_doc/5.6.0 DELETE call response is not HTTP/").appendValue((Object)expectedStatus);
                return false;
            }
            GenericRestClient.HttpResponse getKibana = restClient.get(".kibana", new Header[0]);
            if (getKibana.getStatusCode() != 200) {
                mismatchDescription.appendText(".kibana GET call response is not HTTP/200");
                return false;
            }
            GenericRestClient.HttpResponse closeKibana = restClient.post(".kibana/_close");
            int n4 = expectedStatus = this.allowedActions.contains((Object)TenantAccessMatcher.Action.UPDATE_INDEX) ? 200 : 403;
            if (closeKibana.getStatusCode() != expectedStatus) {
                mismatchDescription.appendText(".kibana/_close POST call response is not HTTP/").appendValue((Object)expectedStatus);
                return false;
            }
            GenericRestClient.HttpResponse deleteKibana = restClient.delete(".kibana", new Header[0]);
            int n5 = expectedStatus = this.allowedActions.contains((Object)TenantAccessMatcher.Action.DELETE_INDEX) ? 200 : 403;
            if (deleteKibana.getStatusCode() != expectedStatus) {
                mismatchDescription.appendText(".kibana delete call response is not HTTP/").appendValue((Object)expectedStatus);
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("User should be allowed to perform the following actions" + this.allowedActions.stream().map(Enum::toString).collect(Collectors.joining(", ")));
    }
}

