/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigApi;
import com.floragunn.searchguard.enterprise.femt.PrivilegesInterceptorImpl;
import com.floragunn.searchguard.enterprise.femt.TenantInfoAction;
import com.floragunn.searchguard.privileges.PrivilegesInterceptor;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class FeMultiTenancyModule
implements SearchGuardModule,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(FeMultiTenancyModule.class);
    private final ComponentState componentState = new ComponentState(1000, null, "fe_multi_tenancy", FeMultiTenancyModule.class).requiresEnterpriseLicense();
    private volatile boolean enabled;
    private volatile PrivilegesInterceptorImpl interceptorImpl;
    private volatile FeMultiTenancyConfig config;
    private volatile ImmutableSet<String> tenantNames = ImmutableSet.empty();
    private ThreadPool threadPool;
    private ClusterService clusterService;
    private AdminDNs adminDns;
    private static final CType<FeMultiTenancyConfig> TYPE = FeMultiTenancyConfig.TYPE;
    private final PrivilegesInterceptor privilegesInterceptor = new PrivilegesInterceptor(){

        public PrivilegesInterceptor.InterceptionResult replaceKibanaIndex(PrivilegesEvaluationContext context, ActionRequest request, Action action, ActionAuthorization actionAuthorization) throws PrivilegesEvaluationException {
            if (FeMultiTenancyModule.this.enabled && FeMultiTenancyModule.this.interceptorImpl != null) {
                return FeMultiTenancyModule.this.interceptorImpl.replaceKibanaIndex(context, request, action, actionAuthorization);
            }
            return PrivilegesInterceptor.InterceptionResult.NORMAL;
        }

        public boolean isEnabled() {
            return FeMultiTenancyModule.this.enabled;
        }

        public String getKibanaIndex() {
            if (FeMultiTenancyModule.this.enabled && FeMultiTenancyModule.this.interceptorImpl != null) {
                return FeMultiTenancyModule.this.interceptorImpl.getKibanaIndex();
            }
            return ".kibana";
        }

        public String getKibanaServerUser() {
            if (FeMultiTenancyModule.this.enabled && FeMultiTenancyModule.this.interceptorImpl != null) {
                return FeMultiTenancyModule.this.interceptorImpl.getKibanaServerUser();
            }
            return "kibanaserver";
        }

        public Map<String, Boolean> mapTenants(User user, ImmutableSet<String> roles, ActionAuthorization actionAuthorization) {
            if (FeMultiTenancyModule.this.enabled && FeMultiTenancyModule.this.interceptorImpl != null) {
                return FeMultiTenancyModule.this.interceptorImpl.mapTenants(user, roles, actionAuthorization);
            }
            return ImmutableMap.empty();
        }
    };

    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        this.threadPool = baseDependencies.getThreadPool();
        this.clusterService = baseDependencies.getClusterService();
        this.adminDns = new AdminDNs(baseDependencies.getSettings());
        baseDependencies.getConfigurationRepository().subscribeOnChange(configMap -> {
            ImmutableSet tenantNames;
            SgDynamicConfiguration config = configMap.get(FeMultiTenancyConfig.TYPE);
            SgDynamicConfiguration legacyConfig = configMap.get(CType.CONFIG);
            FeMultiTenancyConfig feMultiTenancyConfig = null;
            if (config != null && config.getCEntry("default") != null) {
                feMultiTenancyConfig = (FeMultiTenancyConfig)config.getCEntry("default");
                this.componentState.setState(ComponentState.State.INITIALIZED, "using_authc_config");
                this.componentState.setConfigVersion(config.getDocVersion());
            } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                try {
                    LegacySgConfig sgConfig = (LegacySgConfig)legacyConfig.getCEntry("sg_config");
                    feMultiTenancyConfig = FeMultiTenancyConfig.parseLegacySgConfig(sgConfig.getSource(), null);
                    this.componentState.setState(ComponentState.State.INITIALIZED, "using_legacy_config");
                    this.componentState.setConfigVersion(legacyConfig.getDocVersion());
                }
                catch (ConfigValidationException e) {
                    log.warn("Error while parsing legacy MT configuration", (Throwable)e);
                    this.componentState.setFailed((Throwable)e);
                    this.componentState.setConfigVersion(legacyConfig.getDocVersion());
                }
            } else {
                feMultiTenancyConfig = FeMultiTenancyConfig.DEFAULT;
                this.componentState.setState(ComponentState.State.INITIALIZED, "using_default_config");
                this.componentState.setConfigVersion(config.getDocVersion());
            }
            this.config = feMultiTenancyConfig;
            SgDynamicConfiguration tenantConfig = configMap.get(CType.TENANTS);
            this.tenantNames = tenantNames = ImmutableSet.of((Set)tenantConfig.getCEntries().keySet());
            if (feMultiTenancyConfig != null) {
                if (feMultiTenancyConfig.isEnabled()) {
                    this.enabled = true;
                    this.interceptorImpl = new PrivilegesInterceptorImpl(feMultiTenancyConfig, (ImmutableSet<String>)tenantNames, baseDependencies.getActions());
                } else {
                    this.enabled = false;
                    this.componentState.setState(ComponentState.State.SUSPENDED, "disabled_by_config");
                }
            } else {
                this.enabled = false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Using MT config: " + feMultiTenancyConfig + "\nenabled: " + this.enabled + "\ninterceptor: " + this.interceptorImpl);
            }
        });
        return Arrays.asList(this.privilegesInterceptor);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FeMultiTenancyConfig getConfig() {
        return this.config;
    }

    ImmutableSet<String> getTenantNames() {
        return this.tenantNames;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, Supplier<DiscoveryNodes> nodesInCluster) {
        return ImmutableList.of((Object)((Object)new TenantInfoAction(settings, restController, this, this.threadPool, this.clusterService, this.adminDns)), (Object)FeMultiTenancyConfigApi.REST_API);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return FeMultiTenancyConfigApi.ACTION_HANDLERS;
    }

    public ImmutableSet<String> getCapabilities() {
        return ImmutableSet.of((Object)"fe_multi_tenancy");
    }
}

