/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyModule;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;

public class TenantInfoAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final FeMultiTenancyModule module;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AdminDNs adminDns;

    public TenantInfoAction(Settings settings, RestController controller, FeMultiTenancyModule module, ThreadPool threadPool, ClusterService clusterService, AdminDNs adminDns) {
        this.threadContext = threadPool.getThreadContext();
        this.module = module;
        this.clusterService = clusterService;
        this.adminDns = adminDns;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/tenantinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/tenantinfo"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)TenantInfoAction.this.threadContext.getTransient("_sg_user");
                    if (user == null || !user.getName().equals(TenantInfoAction.this.module.getConfig().getServerUsername()) && !TenantInfoAction.this.adminDns.isAdmin(user)) {
                        response = new BytesRestResponse(RestStatus.FORBIDDEN, "");
                    } else {
                        builder.startObject();
                        SortedMap lookup = TenantInfoAction.this.clusterService.state().getMetadata().getIndicesLookup();
                        for (String indexOrAlias : lookup.keySet()) {
                            String tenant = TenantInfoAction.this.tenantNameForIndex(indexOrAlias);
                            if (tenant == null) continue;
                            builder.field(indexOrAlias, tenant);
                        }
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.OK, builder);
                    }
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    private String tenantNameForIndex(String index) {
        String[] indexParts;
        if (index == null || (indexParts = index.split("_")).length != 3) {
            return null;
        }
        if (!indexParts[0].equals(this.module.getConfig().getIndex())) {
            return null;
        }
        try {
            int expectedHash = Integer.parseInt(indexParts[1]);
            String sanitizedName = indexParts[2];
            for (String tenant : this.module.getTenantNames()) {
                if (tenant.hashCode() != expectedHash || !sanitizedName.equals(tenant.toLowerCase().replaceAll("[^a-z0-9]+", ""))) continue;
                return tenant;
            }
            return "__private__";
        }
        catch (NumberFormatException e) {
            this.log.info("Index " + index + " looks like a SG tenant index but we cannot parse the hashcode so we ignore it.");
            return null;
        }
    }

    public String getName() {
        return "Tenant Info Action";
    }

    static /* synthetic */ Logger access$500(TenantInfoAction x0) {
        return x0.log;
    }
}

