/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.DeleteTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.common.Strings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DeleteTempIndexStepTest {
    private StepRepository repository;
    private DataMigrationContext context;
    private DeleteTempIndexStep step;
    private final String indexNameParameter;

    public DeleteTempIndexStepTest(String indexNameParameter) {
        Strings.requireNonEmpty((String)indexNameParameter, (String)"Index name is required");
        this.indexNameParameter = indexNameParameter;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"data_migration_temp_fe_1990_01_01_01_01_00"}, {"data_migration_temp_fe_1993_01_01_01_01_00"}, {"data_migration_temp_fe_1993_03_02_09_08_07"}, {"data_migration_temp_fe_1995_12_11_10_15_59"}, {"data_migration_temp_fe_1999_09_09_09_09_09"}, {"data_migration_temp_fe_2001_05_03_07_16_23"}, {"data_migration_temp_fe_2000_01_01_01_01_00"}, {"another_index_name"}, {"index_for_deletion"});
    }

    @Before
    public void before() {
        this.repository = (StepRepository)Mockito.mock(StepRepository.class);
        this.context = (DataMigrationContext)Mockito.mock(DataMigrationContext.class);
        this.step = new DeleteTempIndexStep(this.repository);
    }

    @Test
    public void shouldDeleteOnlyTempIndex() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)this.indexNameParameter);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).deleteIndices(new String[]{this.indexNameParameter});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((DataMigrationContext)Mockito.verify((Object)this.context)).getTempIndexName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }
}

