/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStateRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MigrationStepsExecutor {
    private static final Logger log = LogManager.getLogger(MigrationStepsExecutor.class);
    static final String MIGRATION_ID = "migration_8_8_0";
    private final MigrationStateRepository migrationStateRepository;
    private final Clock clock;
    private final ImmutableList<MigrationStep> steps;
    private final MigrationConfig config;

    MigrationStepsExecutor(MigrationConfig config, MigrationStateRepository migrationStateRepository, Clock clock, ImmutableList<MigrationStep> steps) {
        this.migrationStateRepository = Objects.requireNonNull(migrationStateRepository, "Migration state repository is required");
        this.clock = Objects.requireNonNull(clock, "Clock is required");
        this.config = Objects.requireNonNull(config, "Migration config is required");
        if (steps.isEmpty()) {
            throw new IllegalStateException("Step list cannot be empty");
        }
        if (steps.stream().anyMatch(Objects::isNull)) {
            throw new IllegalStateException("Step list contain null element " + steps);
        }
        this.steps = Objects.requireNonNull(steps, "Steps list is required");
    }

    public MigrationExecutionSummary execute() {
        DataMigrationContext context = new DataMigrationContext(this.config, this.clock);
        ArrayList<StepExecutionSummary> accomplishedSteps = new ArrayList<StepExecutionSummary>();
        for (int i = 0; i < this.steps.size(); ++i) {
            String stepName;
            MigrationStep step = (MigrationStep)this.steps.get(i);
            LocalDateTime stepStartTime = LocalDateTime.now(this.clock);
            log.info("Starting execution of migration step '{}' at '{}'", (Object)step.name(), (Object)stepStartTime);
            try {
                boolean lastStep;
                StepResult result = step.execute(context);
                StepExecutionSummary stepSummary = new StepExecutionSummary(i, stepStartTime, step.name(), result);
                accomplishedSteps.add(stepSummary);
                boolean bl = lastStep = i == this.steps.size() - 1;
                ExecutionStatus status = lastStep ? (result.isSuccess() ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE) : (result.isSuccess() ? ExecutionStatus.IN_PROGRESS : ExecutionStatus.FAILURE);
                log.info("Step '{}' executed with result '{}", (Object)step.name(), (Object)result);
                if (result.isFailure()) {
                    return this.rollbackMigration(i, context, accomplishedSteps);
                }
                MigrationExecutionSummary migrationSummary = this.persistState(context, accomplishedSteps, status);
                if (!lastStep) continue;
                return migrationSummary;
            }
            catch (StepException ex) {
                stepName = step.name();
                StepExecutionSummary stepSummary = new StepExecutionSummary((long)i, stepStartTime, stepName, ex.getStatus(), ex.getMessage(), ex.getDetails());
                accomplishedSteps.add(stepSummary);
                return this.rollbackMigration(i, context, accomplishedSteps);
            }
            catch (Exception ex) {
                stepName = step.name();
                String message = "Unexpected error: " + ex.getMessage();
                accomplishedSteps.add(new StepExecutionSummary((long)i, stepStartTime, stepName, StepExecutionStatus.UNEXPECTED_ERROR, message, ex));
                log.error("Unexpected error occurred during execution of data migration step '{}' which is '{}'.", (Object)i, (Object)stepName, (Object)ex);
                return this.rollbackMigration(i, context, accomplishedSteps);
            }
        }
        throw new IllegalStateException("Migration already finished, no more steps to execute!");
    }

    private MigrationExecutionSummary rollbackMigration(int currentStep, DataMigrationContext context, List<StepExecutionSummary> accomplishedSteps) {
        MigrationExecutionSummary migrationExecutionSummary = this.persistState(context, accomplishedSteps, ExecutionStatus.FAILURE);
        ImmutableList stepsToRollBack = this.steps.subList(0, currentStep).map(SafeStep::new);
        for (int i = stepsToRollBack.size() - 1; i >= 0; --i) {
            LocalDateTime stepStartTime = LocalDateTime.now(this.clock);
            MigrationStep step = (MigrationStep)stepsToRollBack.get(i);
            log.info("Step '{}' needs to be rollback.", (Object)step.name());
            StepResult result = step.rollback(context);
            StepExecutionSummary stepSummary = new StepExecutionSummary(i, stepStartTime, step.name(), result);
            accomplishedSteps.add(stepSummary);
            migrationExecutionSummary = this.persistState(context, accomplishedSteps, ExecutionStatus.FAILURE);
        }
        return migrationExecutionSummary;
    }

    private MigrationExecutionSummary persistState(DataMigrationContext dataMigrationContext, List<StepExecutionSummary> accomplishedSteps, ExecutionStatus status) {
        MigrationExecutionSummary migrationExecutionSummary = MigrationStepsExecutor.createExecutionSummary(dataMigrationContext, accomplishedSteps, status);
        this.migrationStateRepository.upsert(MIGRATION_ID, migrationExecutionSummary);
        return migrationExecutionSummary;
    }

    private static MigrationExecutionSummary createExecutionSummary(DataMigrationContext dataMigrationContext, List<StepExecutionSummary> accomplishedSteps, ExecutionStatus status) {
        return new MigrationExecutionSummary(dataMigrationContext.getStartTime(), status, dataMigrationContext.getTempIndexName(), dataMigrationContext.getBackupIndexName(), (ImmutableList<StepExecutionSummary>)ImmutableList.of(accomplishedSteps));
    }

    private static final class SafeStep
    implements MigrationStep {
        private final MigrationStep step;

        public SafeStep(MigrationStep step) {
            this.step = Objects.requireNonNull(step, "Migration step is required");
        }

        @Override
        public StepResult execute(DataMigrationContext dataMigrationContext) throws StepException {
            return this.step.execute(dataMigrationContext);
        }

        @Override
        public String name() {
            return "rollback - " + this.step.name();
        }

        @Override
        public StepResult rollback(DataMigrationContext dataMigrationContext) throws StepException {
            try {
                return this.step.rollback(dataMigrationContext);
            }
            catch (Exception ex) {
                log.error("Cannot rollback step '{}'.", (Object)this.name(), (Object)ex);
                return new StepResult(StepExecutionStatus.UNEXPECTED_ERROR, "Unexpected error during step rollback", ex.getMessage());
            }
        }
    }
}

