/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.tenants.MultitenancyActivationService;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentType;

class FrontendDataMigrationInterceptor {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final String kibanaServerUsername;
    private final ThreadContext threadContext;
    private final Client nodeClient;

    public FrontendDataMigrationInterceptor(ThreadContext threadContext, Client nodeClient, FeMultiTenancyConfig config) {
        this.threadContext = threadContext;
        this.nodeClient = nodeClient;
        this.kibanaServerUsername = config.getServerUsername();
    }

    public SyncAuthorizationFilter.Result process(Set<String> kibanaIndices, PrivilegesEvaluationContext context, ActionListener<?> listener) {
        try {
            Optional<ActionProcessor> actionProcessor = this.getActionProcessor(kibanaIndices, context, listener);
            return actionProcessor.map(processor -> new UserAccessGuardWrapper(context.getUser(), (ActionProcessor)processor)).orElseGet(() -> new PassOnFastLineProcessor()).process();
        }
        catch (Exception e) {
            this.log.error("An error occurred while intercepting migration", (Throwable)e);
            listener.onFailure(e);
            return SyncAuthorizationFilter.Result.INTERCEPTED;
        }
    }

    private Optional<ActionProcessor> getActionProcessor(Set<String> kibanaIndices, PrivilegesEvaluationContext context, ActionListener<?> listener) {
        Object object;
        if (context.getUser() != null && Strings.isNullOrEmpty((String)context.getUser().getRequestedTenant()) && this.kibanaServerUsername.equals(context.getUser().getName()) && (object = context.getRequest()) instanceof BulkRequest) {
            BulkRequest bulkRequest = (BulkRequest)object;
            this.log.debug("Index '{}' used during migration detected.", kibanaIndices);
            return Optional.of(() -> this.handleDataMigration(kibanaIndices, context, bulkRequest, (ActionListener<BulkResponse>)listener));
        }
        if (TransportPutMappingAction.TYPE.name().equals(context.getAction().name())) {
            this.log.debug("Migration of mappings for index '{}' detected ", kibanaIndices);
            return Optional.of(() -> this.extendIndexMappingWithMultiTenancyData((PutMappingRequest)context.getRequest(), (ActionListener<AcknowledgedResponse>)listener));
        }
        if (TransportCreateIndexAction.TYPE.name().equals(context.getAction().name())) {
            this.log.debug("Creation of index '{}' detected", kibanaIndices);
            return Optional.of(() -> this.extendIndexMappingWithMultiTenancyData((CreateIndexRequest)context.getRequest(), (ActionListener<CreateIndexResponse>)listener));
        }
        return Optional.empty();
    }

    private SyncAuthorizationFilter.Result handleDataMigration(Set<String> kibanaIndices, PrivilegesEvaluationContext context, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        String actionName = context.getAction().name();
        this.log.debug("Data migration - action '{}' invoked, request class '{}'.", (Object)actionName, context.getRequest().getClass());
        boolean requestExtended = false;
        for (DocWriteRequest item : bulkRequest.requests()) {
            IndexRequest indexRequest;
            boolean isKibanaIndex;
            if (!(item instanceof IndexRequest) || !(isKibanaIndex = kibanaIndices.contains((indexRequest = (IndexRequest)item).index()))) continue;
            Map source = (Map)XContentHelper.convertToMap((BytesReference)indexRequest.source(), (boolean)true, (XContentType)indexRequest.getContentType()).v2();
            if (!RequestResponseTenantData.isScopedId(indexRequest.id())) continue;
            if (!RequestResponseTenantData.containsSgTenantField(source)) {
                String tenantName = RequestResponseTenantData.extractTenantFromId(indexRequest.id());
                this.log.debug("Data migration - adding field '{}' to document '{}' from index '{}' with value '{}'.", (Object)RequestResponseTenantData.getSgTenantField(), (Object)indexRequest.id(), (Object)indexRequest.index(), (Object)tenantName);
                RequestResponseTenantData.appendSgTenantFieldTo(source, tenantName);
                indexRequest.source(source);
                requestExtended = true;
                continue;
            }
            this.log.debug("Data migration - document already '{}' contains {} field with value '{}'", (Object)indexRequest.id(), (Object)RequestResponseTenantData.getSgTenantField(), source.get(RequestResponseTenantData.getSgTenantField()));
        }
        if (requestExtended) {
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext();){
                this.threadContext.putHeader("_sg_filter_level_femt_done", bulkRequest.toString());
                this.nodeClient.bulk(bulkRequest, listener);
                this.log.debug("Data migration - request extended");
                SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
                return result;
            }
        }
        this.log.debug("Data migration - request not extended");
        return SyncAuthorizationFilter.Result.OK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SyncAuthorizationFilter.Result extendIndexMappingWithMultiTenancyData(PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
        String source = request.source();
        this.log.debug("Extend put mappings request for '{}' to support multi tenancy, current mappings '{}'", (Object)request.indices(), (Object)source);
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext();){
            Optional<PutMappingRequest> newRequest = this.extendMappingsWithMultitenancy(source).map(docNode -> this.createExtendedPutMappingRequest(request, (DocNode)docNode));
            if (newRequest.isPresent()) {
                PutMappingRequest putMappingRequest = newRequest.get();
                this.threadContext.putHeader("_sg_filter_level_femt_done", putMappingRequest.toString());
                this.nodeClient.admin().indices().putMapping(putMappingRequest, listener);
                this.log.debug("Extend put mappings request - mappings extended: '{}'", (Object)putMappingRequest.source());
                SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
                return result;
            }
            this.log.debug("Extend put mappings request - mappings not extended");
            SyncAuthorizationFilter.Result throwable = SyncAuthorizationFilter.Result.OK;
            return throwable;
        }
        catch (DocumentParseException e) {
            String message = "Cannot extend put mappings request with information related to multi tenancy";
            this.log.error(message, (Throwable)e);
            listener.onFailure((Exception)new ElasticsearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            return SyncAuthorizationFilter.Result.INTERCEPTED;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SyncAuthorizationFilter.Result extendIndexMappingWithMultiTenancyData(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener) {
        String sourceMappings = request.mappings();
        if (Strings.isNullOrEmpty((String)sourceMappings)) {
            this.log.debug("Extend create index request for '{}' to support multi tenancy. Exit early, mappings from request are empty", Arrays.asList(request.indices()));
            return SyncAuthorizationFilter.Result.OK;
        }
        this.log.debug("Extend create index request for '{}' to support multi tenancy, current mappings '{}", Arrays.asList(request.indices()), (Object)sourceMappings);
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext();){
            UnparsedDocument mappings = UnparsedDocument.from((String)sourceMappings, (Format)Format.JSON);
            DocNode requestSource = mappings.parseAsDocNode();
            if (!requestSource.hasNonNull("_doc")) return SyncAuthorizationFilter.Result.OK;
            Optional<String> newMappings = this.extendMappingsWithMultitenancy(requestSource.getAsNode("_doc")).map(updatedMappings -> requestSource.with("_doc", updatedMappings)).map(DocNode::toJsonString);
            if (newMappings.isPresent()) {
                String extendedMappings = newMappings.get();
                request.mapping(extendedMappings);
                this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
                this.nodeClient.admin().indices().create(request, listener);
                this.log.debug("Extend create index - mappings extended: '{}'", (Object)extendedMappings);
                SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
                return result;
            }
            this.log.debug("Extend create index - mappings not extended");
            return SyncAuthorizationFilter.Result.OK;
        }
        catch (DocumentParseException e) {
            String message = "Cannot extend index mapping with information related to multi tenancy during index creation";
            this.log.error(message, (Throwable)e);
            listener.onFailure((Exception)new ElasticsearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            return SyncAuthorizationFilter.Result.INTERCEPTED;
        }
    }

    private Optional<DocNode> extendMappingsWithMultitenancy(String sourceMappings) throws DocumentParseException {
        UnparsedDocument mappings = UnparsedDocument.from((String)sourceMappings, (Format)Format.JSON);
        DocNode node = mappings.parseAsDocNode();
        return this.extendMappingsWithMultitenancy(node);
    }

    private PutMappingRequest createExtendedPutMappingRequest(PutMappingRequest request, DocNode docNode) {
        PutMappingRequest extendedRequest = ((PutMappingRequest)((PutMappingRequest)new PutMappingRequest(request.indices()).source((Map)docNode).origin(request.origin()).writeIndexOnly(request.writeIndexOnly()).masterNodeTimeout(request.masterNodeTimeout())).ackTimeout(request.ackTimeout())).indicesOptions(request.indicesOptions());
        if (request.getConcreteIndex() != null) {
            extendedRequest.setConcreteIndex(request.getConcreteIndex());
        }
        return extendedRequest;
    }

    private Optional<DocNode> extendMappingsWithMultitenancy(DocNode node) {
        return Optional.of(node).filter(docNode -> docNode.hasNonNull("properties")).map(propertiesDocNode -> propertiesDocNode.getAsNode("properties")).filter(propertiesDocNode -> !RequestResponseTenantData.containsSgTenantField(propertiesDocNode)).map(propertiesDocNode -> propertiesDocNode.with((Document)MultitenancyActivationService.getSgTenantFieldMapping())).map(propertiesDocNode -> node.with("properties", propertiesDocNode));
    }

    @FunctionalInterface
    private static interface ActionProcessor {
        public SyncAuthorizationFilter.Result process();
    }

    private class PassOnFastLineProcessor
    implements ActionProcessor {
        private PassOnFastLineProcessor() {
        }

        @Override
        public SyncAuthorizationFilter.Result process() {
            FrontendDataMigrationInterceptor.this.log.debug("Non-migration action, return PASS_ON_FAST_LANE");
            return SyncAuthorizationFilter.Result.PASS_ON_FAST_LANE;
        }
    }

    private class UserAccessGuardWrapper
    implements ActionProcessor {
        private final User user;
        private final ActionProcessor delegate;

        private UserAccessGuardWrapper(User user, ActionProcessor delegate) {
            this.user = user;
            this.delegate = delegate;
        }

        @Override
        public SyncAuthorizationFilter.Result process() {
            if (!this.isUserAllowed(this.user)) {
                FrontendDataMigrationInterceptor.this.log.error("User '{} is not allowed to perform this action", (Object)this.user.getName());
                return SyncAuthorizationFilter.Result.DENIED;
            }
            return this.delegate.process();
        }

        private boolean isUserAllowed(User user) {
            return FrontendDataMigrationInterceptor.this.kibanaServerUsername.equals(user.getName());
        }
    }
}

