/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CheckIfIndicesAreBlockedStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckIfIndicesAreBlockedStepTest {
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(1990, 1, 1, 1, 1), ZoneOffset.UTC);
    private static final Clock CLOCK = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    public static final String INDEX_NAME_1 = "index-name-1";
    public static final String INDEX_NAME_2 = "index-name-2";
    @Mock
    private StepRepository repository;
    @Mock
    private GetSettingsResponse settingsResponse;
    private DataMigrationContext context;
    private CheckIfIndicesAreBlockedStep step;

    @Before
    public void before() {
        this.context = new DataMigrationContext(new MigrationConfig(false), CLOCK);
        this.step = new CheckIfIndicesAreBlockedStep(this.repository);
    }

    @Test
    public void shouldAccomplishSuccessfullyWhenIndicesAreNotBlocked() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_1, "tenant name")));
        Mockito.when((Object)this.repository.getIndexSettings((String[])this.context.getDataIndicesNames().toArray(String[]::new))).thenReturn((Object)this.settingsResponse);
        Settings settings = Settings.builder().put("index.blocks.write", false).build();
        Mockito.when((Object)this.settingsResponse.getIndexToSettings()).thenReturn((Object)ImmutableMap.of((Object)INDEX_NAME_1, (Object)settings));
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldAccomplishSuccessfullyWhenBlockSettingsAreNotPresent() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_1, "tenant name")));
        Mockito.when((Object)this.repository.getIndexSettings((String[])this.context.getDataIndicesNames().toArray(String[]::new))).thenReturn((Object)this.settingsResponse);
        Settings settings = Settings.builder().put("index.number_of_replicas", 1).build();
        Mockito.when((Object)this.settingsResponse.getIndexToSettings()).thenReturn((Object)ImmutableMap.of((Object)INDEX_NAME_1, (Object)settings));
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldAccomplishSuccessfullyWhenBlockSettingsAreNotPresentForTheFirstIndex() {
        TenantIndex tenantIndexOne = new TenantIndex(INDEX_NAME_1, "tenant name");
        TenantIndex tenantIndexTwo = new TenantIndex(INDEX_NAME_2, "no name");
        ImmutableList tenantIndices = ImmutableList.of((Object)tenantIndexOne, (Object)tenantIndexTwo);
        this.context.setTenantIndices(tenantIndices);
        Mockito.when((Object)this.repository.getIndexSettings((String[])this.context.getDataIndicesNames().toArray(String[]::new))).thenReturn((Object)this.settingsResponse);
        Settings settingsOne = Settings.builder().put("index.number_of_replicas", 1).build();
        Settings settingsTwo = Settings.builder().put("index.blocks.write", false).build();
        Mockito.when((Object)this.settingsResponse.getIndexToSettings()).thenReturn((Object)ImmutableMap.of((Object)INDEX_NAME_1, (Object)settingsOne, (Object)INDEX_NAME_2, (Object)settingsTwo));
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReturnErrorWhenSettingsForIndexAreNotFound() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_1, "tenant name")));
        Mockito.when((Object)this.repository.getIndexSettings((String[])this.context.getDataIndicesNames().toArray(String[]::new))).thenReturn((Object)this.settingsResponse);
        Mockito.when((Object)this.settingsResponse.getIndexToSettings()).thenReturn((Object)ImmutableMap.empty());
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"Settings for index"));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)INDEX_NAME_1));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"are not available"));
    }

    @Test
    public void shouldReturnErrorWhenTheSecondIndexIsBlocked() {
        TenantIndex tenantIndexOne = new TenantIndex(INDEX_NAME_1, "tenant name");
        TenantIndex tenantIndexTwo = new TenantIndex(INDEX_NAME_2, "no name");
        ImmutableList tenantIndices = ImmutableList.of((Object)tenantIndexOne, (Object)tenantIndexTwo);
        this.context.setTenantIndices(tenantIndices);
        Mockito.when((Object)this.repository.getIndexSettings((String[])this.context.getDataIndicesNames().toArray(String[]::new))).thenReturn((Object)this.settingsResponse);
        Settings settingsOne = Settings.builder().put("index.number_of_replicas", 1).build();
        Settings settingsTwo = Settings.builder().put("index.blocks.write", true).build();
        Mockito.when((Object)this.settingsResponse.getIndexToSettings()).thenReturn((Object)ImmutableMap.of((Object)INDEX_NAME_1, (Object)settingsOne, (Object)INDEX_NAME_2, (Object)settingsTwo));
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
    }

    @Test
    public void shouldHandleIndicesWithBlockedMetadata() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_1, "tenant name")));
        Mockito.when((Object)this.repository.getIndexSettings((String[])this.context.getDataIndicesNames().toArray(String[]::new))).thenThrow(ClusterBlockException.class);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
    }
}

