/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.search.SearchHit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class CopyDataToTempIndexStepTest {
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(1993, 1, 1, 1, 7), ZoneOffset.UTC);
    private static final Clock CLOCK = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    public static final TenantIndex GLOBAL_TENANT = new TenantIndex("global", "SGS_GLOBAL_TENANT");
    public static final String BACKUP_INDEX_NAME_1 = "backup_index_1";
    public static final String BACKUP_INDEX_NAME_2 = "backup_index_2";
    public static final String BACKUP_INDEX_NAME_3 = "backup_index_3";
    public static final TenantIndex TENANT_INDEX_1 = new TenantIndex("frontend_data_index_1", "tenant-name-1");
    public static final TenantIndex TENANT_INDEX_2 = new TenantIndex("frontend_data_index_2", "tenant-name-2");
    public static final TenantIndex TENANT_INDEX_3 = new TenantIndex("frontend_data_index_3", "tenant-name-3");
    @Mock
    private StepRepository repository;
    @Mock
    private FeMultiTenancyConfigurationProvider configProvider;
    @Mock
    private IndexSettingsManager indexSettingsManager;
    private DataMigrationContext context;
    private CopyDataToTempIndexStep step;

    @Before
    public void before() {
        this.context = new DataMigrationContext(new MigrationConfig(false), CLOCK);
        this.step = new CopyDataToTempIndexStep(this.repository, this.configProvider, this.indexSettingsManager);
    }

    @Test
    public void shouldDetectDuplicatedId() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        ImmutableList hits = ImmutableList.of((Object)new SearchHit(1, "space:default"), (Object)new SearchHit(2, "space:default"));
        ((StepRepository)Mockito.doAnswer((Answer)new ProvideSearchHitsAnswer((ImmutableList<SearchHit>)hits)).when((Object)this.repository)).forEachDocumentInIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DOCUMENT_ALREADY_EXISTS_ERROR));
    }

    @Test
    public void shouldDetectAlreadyMigratedDocument() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        SearchHit hitOne = new SearchHit(1, "space:default__sg_ten___3292183_kirk_8.7.0_001");
        SearchHit hitTwo = new SearchHit(2, "space:default");
        ImmutableList hits = ImmutableList.of((Object)hitOne, (Object)hitTwo);
        ((StepRepository)Mockito.doAnswer((Answer)new ProvideSearchHitsAnswer((ImmutableList<SearchHit>)hits)).when((Object)this.repository)).forEachDocumentInIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DOCUMENT_ALREADY_MIGRATED_ERROR));
    }

    @Test
    public void shouldDetectIncorrectIndexNamePrefix() {
        String indexName = "incorrect-index-name-without-prefix";
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)new TenantIndex(indexName, null)));
        Mockito.when((Object)this.configProvider.getKibanaIndex()).thenReturn((Object)"required-index-name-prefix");
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)searchHit.getId()).thenReturn((Object)"space:default");
        Mockito.when((Object)searchHit.getIndex()).thenReturn((Object)indexName);
        ImmutableList hits = ImmutableList.of((Object)searchHit);
        ((StepRepository)Mockito.doAnswer((Answer)new ProvideSearchHitsAnswer((ImmutableList<SearchHit>)hits)).when((Object)this.repository)).forEachDocumentInIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INCORRECT_INDEX_NAME_PREFIX_ERROR));
    }

    @Test
    public void shouldReportErrorWhenItIsNotPossibleToGetPrivateTenantName() {
        String prefix = "required-index-name-prefix";
        String indexName = prefix + "-one";
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)new TenantIndex(indexName, null)));
        Mockito.when((Object)this.configProvider.getKibanaIndex()).thenReturn((Object)prefix);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)searchHit.getId()).thenReturn((Object)"space:default");
        Mockito.when((Object)searchHit.getIndex()).thenReturn((Object)indexName);
        ImmutableList hits = ImmutableList.of((Object)searchHit);
        ((StepRepository)Mockito.doAnswer((Answer)new ProvideSearchHitsAnswer((ImmutableList<SearchHit>)hits)).when((Object)this.repository)).forEachDocumentInIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNKNOWN_USER_PRIVATE_TENANT_NAME_ERROR));
    }

    @Test
    public void shouldFlushAndRefreshTempIndex() {
        String prefix = ".openfind";
        String indexName = prefix + "_3292183_kirk_8.7.0_003";
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)new TenantIndex(indexName, null)));
        Mockito.when((Object)this.configProvider.getKibanaIndex()).thenReturn((Object)prefix);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)searchHit.getId()).thenReturn((Object)"space:default");
        Mockito.when((Object)searchHit.getIndex()).thenReturn((Object)indexName);
        ImmutableList hits = ImmutableList.of((Object)searchHit);
        ((StepRepository)Mockito.doAnswer((Answer)new ProvideSearchHitsAnswer((ImmutableList<SearchHit>)hits)).when((Object)this.repository)).forEachDocumentInIndex(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex("data_migration_temp_fe_1993_01_01_01_07_00");
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex("data_migration_temp_fe_1993_01_01_01_07_00");
    }

    @Test
    public void shouldUseOnlyGlobalIndexAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)false);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)GLOBAL_TENANT.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldUseManyTenantIndicesAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1, (Object)TENANT_INDEX_2, (Object[])new TenantIndex[]{TENANT_INDEX_3}));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)false);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)GLOBAL_TENANT.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_2.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_3.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldReportErrorWhenGlobalTenantIsMissing() {
        this.context.setTenantIndices(ImmutableList.of((Object)TENANT_INDEX_1, (Object)TENANT_INDEX_2, (Object)TENANT_INDEX_3, (Object[])new TenantIndex[0]));
        ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(IllegalStateException.class)});
    }

    @Test
    public void shouldUseGlobalTenantIndexAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_NAME_1, (Object)BACKUP_INDEX_NAME_2, (Object)BACKUP_INDEX_NAME_3, (Object[])new String[0]));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)false);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)GLOBAL_TENANT.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldNotRequireBackupIndexListWhenGlobalIndexDoesNotContainMigrationMarker() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(null);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)false);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)GLOBAL_TENANT.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldUseTheOnlyBackupIndexAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_NAME_1));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)BACKUP_INDEX_NAME_1), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldUseTheFirstBackupIndexAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_NAME_1, (Object)BACKUP_INDEX_NAME_2, (Object)BACKUP_INDEX_NAME_3, (Object[])new String[0]));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)BACKUP_INDEX_NAME_1), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldUseTheSecondBackupIndexAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_NAME_1, (Object)BACKUP_INDEX_NAME_2, (Object)BACKUP_INDEX_NAME_3, (Object[])new String[0]));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(BACKUP_INDEX_NAME_1)).thenReturn((Object)true);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)BACKUP_INDEX_NAME_2), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_1);
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldUseTheThirdBackupIndexAsDataSource() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_NAME_1, (Object)BACKUP_INDEX_NAME_2, (Object)BACKUP_INDEX_NAME_3, (Object[])new String[0]));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(BACKUP_INDEX_NAME_1)).thenReturn((Object)true);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(BACKUP_INDEX_NAME_2)).thenReturn((Object)true);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)BACKUP_INDEX_NAME_3), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).forEachDocumentInIndex((String)ArgumentMatchers.eq((Object)TENANT_INDEX_1.indexName()), ArgumentMatchers.anyInt(), (Consumer)ArgumentMatchers.any(Consumer.class));
        ((StepRepository)Mockito.verify((Object)this.repository)).refreshIndex(this.context.getTempIndexName());
        ((StepRepository)Mockito.verify((Object)this.repository)).flushIndex(this.context.getTempIndexName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repository});
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(GLOBAL_TENANT.indexName());
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_1);
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_2);
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).isMigrationMarkerPresent(BACKUP_INDEX_NAME_3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexSettingsManager});
    }

    @Test
    public void shouldReportErrorWhenGlobalIndexAndItsBackupsContainMigratedData() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_NAME_1, (Object)BACKUP_INDEX_NAME_2, (Object)BACKUP_INDEX_NAME_3, (Object[])new String[0]));
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(BACKUP_INDEX_NAME_1)).thenReturn((Object)true);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(BACKUP_INDEX_NAME_2)).thenReturn((Object)true);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(BACKUP_INDEX_NAME_3)).thenReturn((Object)true);
        StepException ex = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)ex.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_INDICES_CONTAIN_MIGRATION_MARKER));
    }

    @Test
    public void shouldReportErrorWhenGlobalTenantIndexContainMigratedDataAndBackupIndicesAreMissing() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(ImmutableList.empty());
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        StepException ex = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)ex.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_FROM_PREVIOUS_MIGRATION_NOT_AVAILABLE_ERROR));
    }

    @Test
    public void shouldReportErrorWhenGlobalTenantIndexContainMigratedDataAndBackupIndicesAreEqualToNull() {
        this.context.setTenantIndices(ImmutableList.of((Object)GLOBAL_TENANT, (Object)TENANT_INDEX_1));
        this.context.setBackupIndices(null);
        Mockito.when((Object)this.indexSettingsManager.isMigrationMarkerPresent(GLOBAL_TENANT.indexName())).thenReturn((Object)true);
        StepException ex = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)ex.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_FROM_PREVIOUS_MIGRATION_NOT_AVAILABLE_ERROR));
    }

    private static class ProvideSearchHitsAnswer
    implements Answer<Void> {
        private final ImmutableList<SearchHit> hits;

        private ProvideSearchHitsAnswer(ImmutableList<SearchHit> hits) {
            this.hits = Objects.requireNonNull(hits, "Search hits are required");
        }

        public Void answer(InvocationOnMock invocation) {
            Consumer consumer = (Consumer)invocation.getArgument(2);
            consumer.accept(this.hits);
            return null;
        }
    }
}

