/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateBackupOfGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CreateBackupOfGlobalIndexStepTest {
    private static final Logger log = LogManager.getLogger(CreateBackupOfGlobalIndexStepTest.class);
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(2033, 1, 1, 1, 7), ZoneOffset.UTC);
    private static final Clock CLOCK = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    public static final String INDEX_NAME_GLOBAL_TENANT = "global_tenant_index";
    public static final String BACKUP_DESTINATION = "backup_fe_migration_to_8_8_0_2033_01_01_01_07_00";
    public static final long NUMBER_OF_DOCUMENTS = 100L;
    public static final String GLOBAL_TENANT_NAME = "SGS_GLOBAL_TENANT";
    @Mock
    private StepRepository repository;
    @Mock
    private IndexSettingsManager indexSettingsManager;
    @Mock
    private BulkByScrollResponse response;
    @Mock
    private BulkByScrollTask.Status responseStatus;
    private DataMigrationContext context;
    private CreateBackupOfGlobalIndexStep step;

    @Before
    public void before() {
        this.context = new DataMigrationContext(new MigrationConfig(false), CLOCK);
        this.step = new CreateBackupOfGlobalIndexStep(this.repository, this.indexSettingsManager);
    }

    @Test
    public void shouldMarkBackupIndexAsCreated() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)true));
        ((IndexSettingsManager)Mockito.verify((Object)this.indexSettingsManager)).createIndexWithClonedSettings(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION, false);
    }

    @Test
    public void shouldReportErrorWhenBackupIndexContainsInsufficientNumberOfDocuments() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.repository.countDocuments(INDEX_NAME_GLOBAL_TENANT)).thenReturn((Object)100L);
        Mockito.when((Object)this.repository.countDocuments(BACKUP_DESTINATION)).thenReturn((Object)99L);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.MISSING_DOCUMENTS_IN_BACKUP_ERROR));
    }

    @Test
    public void shouldReportErrorIfDocumentWasUpdatedDuringBackup() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.response.getUpdated()).thenReturn((Object)1L);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_UNEXPECTED_OPERATION_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_UNEXPECTED_OPERATION_ERROR));
    }

    @Test
    public void shouldReportErrorIfDocumentWasDeletedDuringBackup() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.response.getDeleted()).thenReturn((Object)2L);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_UNEXPECTED_OPERATION_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReportErrorIfVersionConflictOccurredDuringBackup() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        Mockito.when((Object)this.response.getVersionConflicts()).thenReturn((Object)3L);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_UNEXPECTED_OPERATION_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldDetectReindexRequestError_1() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        List<BulkByScrollTask.StatusOrException> sliceStatuses = IntStream.range(0, 5).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)sliceStatuses.get(3).getException()).thenReturn((Object)new IllegalStateException("Slice three failure"));
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn(sliceStatuses);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldDetectReindexRequestError_2() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        List<BulkByScrollTask.StatusOrException> sliceStatuses = IntStream.range(0, 5).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)sliceStatuses.get(4).getException()).thenReturn((Object)new IllegalStateException("Slice four failure"));
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn(sliceStatuses);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldDetectReindexRequestError_3() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        List<BulkByScrollTask.StatusOrException> sliceStatuses = IntStream.range(0, 5).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)sliceStatuses.get(0).getException()).thenReturn((Object)new IllegalStateException("Slice zero failure"));
        Mockito.when((Object)sliceStatuses.get(1).getException()).thenReturn((Object)new IllegalStateException("Slice one failure"));
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn(sliceStatuses);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldDetectReindexRequestError_4() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        List<BulkByScrollTask.StatusOrException> sliceStatuses = IntStream.range(0, 15).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        sliceStatuses.forEach(statusOrException -> Mockito.when((Object)statusOrException.getException()).thenReturn((Object)new IllegalStateException("Slice four failure")));
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn(sliceStatuses);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldGainSuccessfulStepResultWhenAllSlicesDoesNotContainException() {
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(INDEX_NAME_GLOBAL_TENANT, GLOBAL_TENANT_NAME)));
        Mockito.when((Object)this.repository.reindexData(INDEX_NAME_GLOBAL_TENANT, BACKUP_DESTINATION)).thenReturn((Object)this.response);
        List<BulkByScrollTask.StatusOrException> sliceStatuses = IntStream.range(0, 12).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        sliceStatuses.forEach(statusOrException -> Mockito.when((Object)statusOrException.getException()).thenReturn(null));
        Mockito.when((Object)this.responseStatus.getSliceStatuses()).thenReturn(sliceStatuses);
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)this.responseStatus);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)true));
    }
}

