/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationService;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.IndexAlreadyExistsException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStateRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.OptimisticLock;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.OptimisticLockException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepsFactory;
import com.floragunn.searchsupport.action.StandardResponse;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataMigrationServiceTest {
    private static final Logger log = LogManager.getLogger(DataMigrationServiceTest.class);
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(2010, 12, 1, 1, 1), ZoneOffset.UTC);
    public static final String STEP_NAME = "My names is mocked step.";
    public static final String MESSAGE = "I am done!";
    public static final String ERROR_MESSAGE = "Unexpected exception during mock step execution";
    public static final String MIGRATION_ID = "migration_8_8_0";
    public static final MigrationConfig STRICT_CONFIG = new MigrationConfig(false);
    @Mock
    private DataMigrationService dataMigrationService;
    @Mock
    private MigrationStateRepository repository;
    @Mock
    private StepsFactory stepFactory;
    @Mock
    private MigrationStep step;
    @Captor
    private ArgumentCaptor<MigrationExecutionSummary> summaryCaptor;

    @Before
    public void before() {
        this.dataMigrationService = new DataMigrationService(this.repository, this.stepFactory, Clock.fixed(NOW.toInstant(), ZoneOffset.UTC));
    }

    @Test
    public void shouldPerformDataMigration() {
        this.mockOneSuccessfulStep();
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository)).upsert(ArgumentMatchers.anyString(), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary persistedSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)persistedSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)persistedSummary.stages().get(0)).name(), (Matcher)Matchers.equalTo((Object)STEP_NAME));
    }

    @Test
    public void shouldDetectErrorDuringMigration() {
        Mockito.when((Object)this.step.execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenThrow(new Throwable[]{new RuntimeException(ERROR_MESSAGE)});
        Mockito.when((Object)this.step.name()).thenReturn((Object)STEP_NAME);
        Mockito.when((Object)this.stepFactory.createSteps()).thenReturn((Object)ImmutableList.of((Object)this.step));
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)500));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository)).upsert(ArgumentMatchers.anyString(), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary persistedSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)persistedSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)persistedSummary.stages().get(0)).name(), (Matcher)Matchers.equalTo((Object)STEP_NAME));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)persistedSummary.stages().get(0)).message(), (Matcher)Matchers.containsString((String)ERROR_MESSAGE));
    }

    @Test
    public void shouldCreateIndexWhenTheIndexDoesNotExist() {
        this.mockOneSuccessfulStep();
        Mockito.when((Object)this.repository.isIndexCreated()).thenReturn((Object)false);
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository)).createIndex();
    }

    @Test
    public void shouldNotCreateIndexWhenTheIndexExists() {
        this.mockOneSuccessfulStep();
        Mockito.when((Object)this.repository.isIndexCreated()).thenReturn((Object)true);
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).createIndex();
    }

    @Test
    public void shouldReturnErrorResponseWhenIndexWasCreatedByConcurrentMigration() {
        Mockito.when((Object)this.repository.isIndexCreated()).thenReturn((Object)false);
        ((MigrationStateRepository)Mockito.doThrow((Throwable[])new Throwable[]{new IndexAlreadyExistsException("Test index already exists exception", null)}).when((Object)this.repository)).createIndex();
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)409));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).create(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).upsert(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).updateWithLock(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class), (OptimisticLock)ArgumentMatchers.any(OptimisticLock.class));
        ((MigrationStep)Mockito.verify((Object)this.step, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
    }

    @Test
    public void shouldDetectThatAnotherMigrationIsInProgressBasedOnRepositoryContent() {
        LocalDateTime past = NOW.minusMinutes(1L).toLocalDateTime();
        MigrationExecutionSummary summary = new MigrationExecutionSummary(past, ExecutionStatus.IN_PROGRESS, null, null, ImmutableList.empty());
        Mockito.when((Object)this.repository.findById(MIGRATION_ID)).thenReturn(Optional.of(summary));
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).create(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).upsert(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).updateWithLock(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class), (OptimisticLock)ArgumentMatchers.any(OptimisticLock.class));
        ((MigrationStep)Mockito.verify((Object)this.step, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
    }

    @Test
    public void shouldStartTheMigrationForTheFirstTime() {
        Mockito.when((Object)this.repository.findById(MIGRATION_ID)).thenReturn(Optional.empty());
        this.mockOneSuccessfulStep();
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository)).create((String)Mockito.eq((Object)MIGRATION_ID), (MigrationExecutionSummary)this.summaryCaptor.capture());
        ((MigrationStep)Mockito.verify((Object)this.step)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        MigrationExecutionSummary persistedSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)persistedSummary.stages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)persistedSummary.stages().get(0)).name(), (Matcher)Matchers.equalTo((Object)"preconditions check"));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)persistedSummary.stages().get(0)).message(), (Matcher)Matchers.containsString((String)"The first start"));
    }

    @Test
    public void shouldDetectThatAnotherProcessTriesToStartDataMigrationForTheFirstTime() {
        Mockito.when((Object)this.repository.findById(MIGRATION_ID)).thenReturn(Optional.empty());
        ((MigrationStateRepository)Mockito.doThrow((Throwable[])new Throwable[]{new OptimisticLockException("Test optimistic lock exception", null)}).when((Object)this.repository)).create((String)ArgumentMatchers.eq((Object)MIGRATION_ID), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)412));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).upsert(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).updateWithLock(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class), (OptimisticLock)ArgumentMatchers.any(OptimisticLock.class));
        ((MigrationStep)Mockito.verify((Object)this.step, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
    }

    @Test
    public void shouldRestartMigrationProcess() {
        LocalDateTime past = NOW.minusDays(1L).toLocalDateTime();
        OptimisticLock lockData = new OptimisticLock(7L, 1492L);
        MigrationExecutionSummary summary = new MigrationExecutionSummary(past, ExecutionStatus.IN_PROGRESS, null, null, ImmutableList.empty(), lockData);
        Mockito.when((Object)this.repository.findById(MIGRATION_ID)).thenReturn(Optional.of(summary));
        this.mockOneSuccessfulStep();
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository)).updateWithLock((String)ArgumentMatchers.eq((Object)MIGRATION_ID), (MigrationExecutionSummary)this.summaryCaptor.capture(), (OptimisticLock)ArgumentMatchers.eq((Object)lockData));
        ((MigrationStep)Mockito.verify((Object)this.step)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        MigrationExecutionSummary storedSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)storedSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)storedSummary.stages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)storedSummary.stages().get(0)).name(), (Matcher)Matchers.equalTo((Object)"preconditions check"));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)storedSummary.stages().get(0)).message(), (Matcher)Matchers.containsString((String)"restarted"));
    }

    @Test
    public void shouldDetectParallelMigrationProcessRestart() {
        LocalDateTime past = NOW.minusDays(1L).toLocalDateTime();
        OptimisticLock lockData = new OptimisticLock(7L, 1492L);
        MigrationExecutionSummary summary = new MigrationExecutionSummary(past, ExecutionStatus.IN_PROGRESS, null, null, ImmutableList.empty(), lockData);
        Mockito.when((Object)this.repository.findById(MIGRATION_ID)).thenReturn(Optional.of(summary));
        ((MigrationStateRepository)Mockito.doThrow((Throwable[])new Throwable[]{new OptimisticLockException("Test optimistic lock exception", null)}).when((Object)this.repository)).updateWithLock((String)ArgumentMatchers.eq((Object)MIGRATION_ID), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class), (OptimisticLock)ArgumentMatchers.eq((Object)lockData));
        StandardResponse standardResponse = this.dataMigrationService.migrateData(STRICT_CONFIG);
        log.debug("Data migration response '{}'", (Object)standardResponse.toJsonString());
        MatcherAssert.assertThat((Object)standardResponse.getStatus(), (Matcher)Matchers.equalTo((Object)409));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).create(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).upsert(ArgumentMatchers.anyString(), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        ((MigrationStep)Mockito.verify((Object)this.step, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
    }

    private void mockOneSuccessfulStep() {
        Mockito.when((Object)this.step.execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenReturn((Object)new StepResult(StepExecutionStatus.OK, MESSAGE));
        Mockito.when((Object)this.step.name()).thenReturn((Object)STEP_NAME);
        Mockito.when((Object)this.stepFactory.createSteps()).thenReturn((Object)ImmutableList.of((Object)this.step));
    }
}

