/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class MigrationExecutionSummaryTest {
    private static final Logger log = LogManager.getLogger(MigrationExecutionSummaryTest.class);
    private static final LocalDateTime NOW = LocalDateTime.of(2023, 5, 25, 12, 7);
    public static final int STEP_NO = 7;
    public static final String STEP_NAME = "the only step name";
    public static final String STEP_MESSAGE = "step message";
    public static final String TEMP_INDEX_NAME = "temp index name";
    public static final String BACKUP_INDEX_NAME = "backup index name";
    public static final String STEP_DETAILS = "step details";

    @Test
    public void shouldSerializeToJson() throws DocumentParseException {
        MigrationExecutionSummary summary = MigrationExecutionSummaryTest.createSummary(NOW, ExecutionStatus.IN_PROGRESS);
        String jsonString = DocWriter.json().writeAsString((Document)summary);
        log.debug("Migration execution summary serialized to JSON: '{}'", (Object)jsonString);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(jsonString);
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.start_time", (Object)"2023-05-25T12:07:00.000Z"));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.status", (Object)"in_progress"));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.temp_index_name", (Object)TEMP_INDEX_NAME));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.backup_index_name", (Object)BACKUP_INDEX_NAME));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.stages[0].start_time", (Object)"2023-05-25T12:07:00.000Z"));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.stages[0].name", (Object)STEP_NAME));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.stages[0].status", (Object)"ok"));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.stages[0].message", (Object)STEP_MESSAGE));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containsValue((String)"$.stages[0].details", (Object)STEP_DETAILS));
    }

    @Test
    public void shouldIncorporateStackTraceInMessageDetails() throws DocumentParseException {
        String message = "The stack trace should be incorporated into step summary";
        RuntimeException exception = new RuntimeException(message);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, NOW, STEP_NAME, StepExecutionStatus.UNEXPECTED_ERROR, STEP_MESSAGE, (Throwable)exception);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary summary = new MigrationExecutionSummary(NOW, ExecutionStatus.FAILURE, null, null, stages, null);
        String jsonString = DocWriter.json().writeAsString((Document)summary);
        log.debug("Migration execution summary serialized to JSON: '{}'", (Object)jsonString);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(jsonString);
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containSubstring((String)"$.stages[0].details", (String)message));
        MatcherAssert.assertThat((Object)docNode, (Matcher)DocNodeMatchers.containSubstring((String)"$.stages[0].details", (String)"com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummaryTest.shouldIncorporateStackTraceInMessageDetails(MigrationExecutionSummaryTest.java:".trim()));
    }

    private static MigrationExecutionSummary createSummary(LocalDateTime startTime, ExecutionStatus status) {
        StepExecutionSummary step = new StepExecutionSummary(7L, NOW, STEP_NAME, StepExecutionStatus.OK, STEP_MESSAGE, STEP_DETAILS);
        return new MigrationExecutionSummary(startTime, status, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, ImmutableList.of((Object)step));
    }

    @Test
    public void shouldNotBeInProgressWhenMigrationExecutionFailed() {
        LocalDateTime nearPast = NOW.minusSeconds(1L);
        MigrationExecutionSummary summary = MigrationExecutionSummaryTest.createSummary(nearPast, ExecutionStatus.FAILURE);
        boolean migrationInProgress = summary.isMigrationInProgress(NOW);
        MatcherAssert.assertThat((Object)migrationInProgress, (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotBeInProgressWhenMigrationIsAccomplishedSuccessfully() {
        LocalDateTime nearPast = NOW.minusSeconds(1L);
        MigrationExecutionSummary summary = MigrationExecutionSummaryTest.createSummary(nearPast, ExecutionStatus.SUCCESS);
        boolean migrationInProgress = summary.isMigrationInProgress(NOW);
        MatcherAssert.assertThat((Object)migrationInProgress, (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldBeInProgressWhenMigrationIsNotAccomplishedAndMigrationStartedInNearPast() {
        LocalDateTime nearPast = NOW.minusSeconds(1L);
        MigrationExecutionSummary summary = MigrationExecutionSummaryTest.createSummary(nearPast, ExecutionStatus.IN_PROGRESS);
        boolean migrationInProgress = summary.isMigrationInProgress(NOW);
        MatcherAssert.assertThat((Object)migrationInProgress, (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotBeInProgressWhenMigrationIsNotAccomplishedAndMigrationStartedInDistantPast() {
        LocalDateTime distantPast = NOW.minusDays(1L);
        MigrationExecutionSummary summary = MigrationExecutionSummaryTest.createSummary(distantPast, ExecutionStatus.IN_PROGRESS);
        boolean migrationInProgress = summary.isMigrationInProgress(NOW);
        MatcherAssert.assertThat((Object)migrationInProgress, (Matcher)Matchers.equalTo((Object)false));
    }
}

