/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.persistence;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.IndexAlreadyExistsException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.OptimisticLock;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.OptimisticLockException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.persistence.IndexMigrationStateRepository;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.Constants;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class IndexMigrationStateRepositoryTest {
    private static final Logger log = LogManager.getLogger(IndexMigrationStateRepositoryTest.class);
    public static final String ID_1 = "my-id-1";
    public static final String ID_2 = "my-id-2";
    public static final String ID_3 = "my-id-3";
    public static final int STEP_NO_1 = 7;
    public static final int STEP_NO_2 = 8;
    public static final String STEP_NAME_1 = "the first step";
    public static final String STEP_NAME_2 = "the second step";
    public static final String MESSAGE = "Please wait...";
    public static final String TEMP_INDEX_NAME = "temp index name";
    public static final String BACKUP_INDEX_NAME = "backup index name";
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().resources("multitenancy").enterpriseModulesEnabled().embedded().build();
    private IndexMigrationStateRepository repository;

    @Before
    public void before() {
        Client client = cluster.getInternalNodeClient();
        PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
        this.repository = new IndexMigrationStateRepository(privilegedConfigClient);
        if (this.repository.isIndexCreated()) {
            client.admin().indices().delete(new DeleteIndexRequest(".sg_data_migration_state")).actionGet();
        }
    }

    @Test
    public void shouldDetectThatIndexDoesNotExist() {
        boolean indexCreated = this.repository.isIndexCreated();
        MatcherAssert.assertThat((Object)indexCreated, (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldDetectThatIndexExists() {
        this.repository.createIndex();
        boolean indexCreated = this.repository.isIndexCreated();
        MatcherAssert.assertThat((Object)indexCreated, (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotCreateIndexWhenTheIndexAlreadyExists() {
        this.repository.createIndex();
        ThrowableAssert.assertThatThrown(() -> this.repository.createIndex(), (Matcher[])new Matcher[]{Matchers.instanceOf(IndexAlreadyExistsException.class)});
    }

    @Test
    public void shouldCreateMappings() {
        this.repository.createIndex();
        GetMappingsRequest request = (GetMappingsRequest)new GetMappingsRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{".sg_data_migration_state"});
        GetMappingsResponse response = (GetMappingsResponse)cluster.getPrivilegedInternalNodeClient().admin().indices().getMappings(request).actionGet();
        MappingMetadata mappingMetadata = (MappingMetadata)response.getMappings().get(".sg_data_migration_state");
        MatcherAssert.assertThat((Object)mappingMetadata, (Matcher)Matchers.notNullValue());
        DocNode mappings = DocNode.wrap((Object)mappingMetadata.getSourceAsMap());
        log.info("Mapping created for index: '{}'", (Object)mappings.toJsonString());
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.start_time.type", (Object)"date"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.status.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.temp_index_name.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.backup_index_name.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.start_time.type", (Object)"date"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.status.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.name.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.number.type", (Object)"long"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.message.type", (Object)"text"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.message.fields.keyword.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.message.fields.keyword.ignore_above", (Object)250));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.details.fields.keyword.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)mappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.stages.properties.details.fields.keyword.ignore_above", (Object)250));
    }

    @Test
    public void shouldCreateDocumentWithIdOne() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 0);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.create(ID_1, migrationSummary);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_1).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary, (Matcher)Matchers.equalTo((Object)migrationSummary));
    }

    @Test
    public void shouldCreateTwoDocuments() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 0);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary migrationSummaryOne = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        MigrationExecutionSummary migrationSummaryTwo = new MigrationExecutionSummary(startTime, ExecutionStatus.FAILURE, null, null, stages);
        this.repository.create(ID_1, migrationSummaryOne);
        this.repository.create(ID_2, migrationSummaryTwo);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_2).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary, (Matcher)Matchers.equalTo((Object)migrationSummaryTwo));
        loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_1).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary, (Matcher)Matchers.equalTo((Object)migrationSummaryOne));
    }

    @Test
    public void shouldReportErrorWhenCreatedDocumentAlreadyExists() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 0);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        MigrationExecutionSummary migrationSummaryTwo = new MigrationExecutionSummary(startTime, ExecutionStatus.FAILURE, null, null, stages);
        this.repository.upsert(ID_1, migrationSummary);
        OptimisticLock optimisticLock = ((MigrationExecutionSummary)this.repository.findById(ID_1).orElseThrow()).lockData();
        ThrowableAssert.assertThatThrown(() -> this.repository.create(ID_1, migrationSummaryTwo), (Matcher[])new Matcher[]{Matchers.instanceOf(OptimisticLockException.class)});
        OptimisticLock lockDataAfterUpdate = ((MigrationExecutionSummary)this.repository.findById(ID_1).orElseThrow()).lockData();
        MatcherAssert.assertThat((Object)lockDataAfterUpdate, (Matcher)Matchers.equalTo((Object)optimisticLock));
    }

    @Test
    public void shouldStoreDocumentWithIdOne() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 0);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_1, migrationSummary);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_1).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary, (Matcher)Matchers.equalTo((Object)migrationSummary));
    }

    @Test
    public void shouldStoreDocumentWithIdTwo() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 1);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_2, migrationSummary);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_2).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary, (Matcher)Matchers.equalTo((Object)migrationSummary));
    }

    @Test
    public void shouldNotFindDocument() {
        this.repository.createIndex();
        Optional summary = this.repository.findById(ID_1);
        MatcherAssert.assertThat((Object)summary.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldLoadPrimaryTermAndSeqNo() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 1);
        StepExecutionSummary stepSummary = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummary);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_3, migrationSummary);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_3).orElseThrow();
        OptimisticLock lock = loadedSummary.lockData();
        MatcherAssert.assertThat((Object)lock, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)lock.primaryTerm(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)lock.seqNo(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void shouldUpdateMigrationSummary() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 1);
        StepExecutionSummary stepSummaryOne = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummaryOne);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.IN_PROGRESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_3, migrationSummary);
        StepExecutionSummary stepSummaryTwo = new StepExecutionSummary(8L, startTime, STEP_NAME_2, StepExecutionStatus.OK, MESSAGE);
        stages = ImmutableList.of((Object)stepSummaryOne, (Object)stepSummaryTwo);
        migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_3, migrationSummary);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_3).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)loadedSummary.stages(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)loadedSummary.stages().get(0)).name(), (Matcher)Matchers.equalTo((Object)STEP_NAME_1));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)loadedSummary.stages().get(1)).name(), (Matcher)Matchers.equalTo((Object)STEP_NAME_2));
    }

    @Test
    public void shouldUpdateMigrationSummaryWithOptimisticLock() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 1);
        StepExecutionSummary stepSummaryOne = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummaryOne);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.IN_PROGRESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_3, migrationSummary);
        OptimisticLock lock = ((MigrationExecutionSummary)this.repository.findById(ID_3).orElseThrow()).lockData();
        StepExecutionSummary stepSummaryTwo = new StepExecutionSummary(8L, startTime, STEP_NAME_2, StepExecutionStatus.OK, MESSAGE);
        stages = ImmutableList.of((Object)stepSummaryOne, (Object)stepSummaryTwo);
        migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.updateWithLock(ID_3, migrationSummary, lock);
        MigrationExecutionSummary loadedSummary = (MigrationExecutionSummary)this.repository.findById(ID_3).orElseThrow();
        MatcherAssert.assertThat((Object)loadedSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)loadedSummary.stages(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)loadedSummary.stages().get(0)).name(), (Matcher)Matchers.equalTo((Object)STEP_NAME_1));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)loadedSummary.stages().get(1)).name(), (Matcher)Matchers.equalTo((Object)STEP_NAME_2));
    }

    @Test
    public void shouldNotUpdateMigrationSummaryWithOptimisticLock() {
        this.repository.createIndex();
        LocalDateTime startTime = LocalDateTime.of(2004, 5, 1, 0, 1);
        StepExecutionSummary stepSummaryOne = new StepExecutionSummary(7L, startTime, STEP_NAME_1, StepExecutionStatus.OK, MESSAGE);
        ImmutableList stages = ImmutableList.of((Object)stepSummaryOne);
        MigrationExecutionSummary migrationSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.IN_PROGRESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_3, migrationSummary);
        OptimisticLock lock = ((MigrationExecutionSummary)this.repository.findById(ID_3).orElseThrow()).lockData();
        migrationSummary = new MigrationExecutionSummary(startTime.plusHours(1L), ExecutionStatus.IN_PROGRESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        this.repository.upsert(ID_3, migrationSummary);
        StepExecutionSummary stepSummaryTwo = new StepExecutionSummary(8L, startTime, STEP_NAME_2, StepExecutionStatus.OK, MESSAGE);
        stages = ImmutableList.of((Object)stepSummaryOne, (Object)stepSummaryTwo);
        MigrationExecutionSummary updatedSummary = new MigrationExecutionSummary(startTime, ExecutionStatus.SUCCESS, TEMP_INDEX_NAME, BACKUP_INDEX_NAME, stages);
        ThrowableAssert.assertThatThrown(() -> this.repository.updateWithLock(ID_3, updatedSummary, lock), (Matcher[])new Matcher[]{Matchers.instanceOf(OptimisticLockException.class)});
    }
}

