/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CopyDataToGlobalIndexStepTest {
    private static final Logger log = LogManager.getLogger(CopyDataToGlobalIndexStepTest.class);
    public static final String SOURCE_INDEX_NAME_1 = "source_index_name_1";
    public static final String DESTINATION_INDEX_NAME_1 = "destination_index_name_1";
    public static final String SOURCE_INDEX_NAME_2 = "source__index__name__2";
    public static final String DESTINATION_INDEX_NAME_2 = "DestinationIndexName_2";
    public static final String SOURCE_INDEX_NAME_3 = "sourceindexname_3";
    public static final String DESTINATION_INDEX_NAME_3 = "destinationindexname_3";
    @Mock
    private StepRepository stepRepository;
    @Mock
    private DataMigrationContext context;
    @Mock
    private BulkByScrollResponse reindexResponse;
    @Mock
    private BulkByScrollTask.Status status;
    private CopyDataToGlobalIndexStep step;

    @Before
    public void before() {
        this.step = new CopyDataToGlobalIndexStep(this.stepRepository);
    }

    @Test
    public void shouldReindexData_1() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        List<BulkByScrollTask.StatusOrException> statuses = IntStream.range(0, 7).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        statuses.forEach(status -> Mockito.when((Object)status.getException()).thenReturn(null));
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn(statuses);
        Mockito.when((Object)this.reindexResponse.getCreated()).thenReturn((Object)1023L);
        Mockito.when((Object)this.reindexResponse.getTotal()).thenReturn((Object)1023L);
        Mockito.when((Object)this.reindexResponse.getBatches()).thenReturn((Object)11);
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)1023L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).reindexData(SOURCE_INDEX_NAME_1, DESTINATION_INDEX_NAME_1);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(SOURCE_INDEX_NAME_1);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(DESTINATION_INDEX_NAME_1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stepRepository});
    }

    @Test
    public void shouldReindexData_2() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_2);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_2);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.reindexResponse.getCreated()).thenReturn((Object)999L);
        Mockito.when((Object)this.reindexResponse.getTotal()).thenReturn((Object)999L);
        Mockito.when((Object)this.reindexResponse.getBatches()).thenReturn((Object)10);
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)999L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).reindexData(SOURCE_INDEX_NAME_2, DESTINATION_INDEX_NAME_2);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(SOURCE_INDEX_NAME_2);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(DESTINATION_INDEX_NAME_2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stepRepository});
    }

    @Test
    public void shouldReindexData_3() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_3);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_3);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.reindexResponse.getCreated()).thenReturn((Object)999L);
        Mockito.when((Object)this.reindexResponse.getTotal()).thenReturn((Object)999L);
        Mockito.when((Object)this.reindexResponse.getBatches()).thenReturn((Object)10);
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)999L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).reindexData(SOURCE_INDEX_NAME_3, DESTINATION_INDEX_NAME_3);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(SOURCE_INDEX_NAME_3);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(DESTINATION_INDEX_NAME_3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stepRepository});
    }

    @Test
    public void shouldReportErrorWhenDocumentsInGlobalTenantIndexAreMissing() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.stepRepository.countDocuments(SOURCE_INDEX_NAME_1)).thenReturn((Object)1050L);
        Mockito.when((Object)this.stepRepository.countDocuments(DESTINATION_INDEX_NAME_1)).thenReturn((Object)1001L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.MISSING_DOCUMENTS_IN_GLOBAL_TENANT_INDEX_ERROR));
    }

    @Test
    public void shouldReportErrorWhenDocumentsWereUpdatedInDestinationIndex() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getUpdated()).thenReturn((Object)1L);
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)1066L);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_DATA_INTO_GLOBAL_TENANT_ERROR));
    }

    @Test
    public void shouldReportErrorWhenDocumentsWereDeletedFromDestinationIndex() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.reindexResponse.getDeleted()).thenReturn((Object)10L);
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)1066L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_DATA_INTO_GLOBAL_TENANT_ERROR));
    }

    @Test
    public void shouldReportErrorWhenVersionConflictsOccurredInDestinationIndex() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.reindexResponse.getVersionConflicts()).thenReturn((Object)13L);
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)1066L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_DATA_INTO_GLOBAL_TENANT_ERROR));
    }

    @Test
    public void shouldReportErrorInCaseOfDeletionUpdatesAndVersionConflictsInDestinationIndex() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getVersionConflicts()).thenReturn((Object)33L);
        Mockito.when((Object)this.reindexResponse.getDeleted()).thenReturn((Object)1051L);
        Mockito.when((Object)this.reindexResponse.getUpdated()).thenReturn((Object)206L);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn((Object)ImmutableList.empty());
        Mockito.when((Object)this.stepRepository.countDocuments(ArgumentMatchers.anyString())).thenReturn((Object)27654L);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_DATA_INTO_GLOBAL_TENANT_ERROR));
    }

    @Test
    public void shouldInterruptStepExecutionInCaseOfExceptionThrownFromRepository_1() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_3);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_3);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new StepException("Test exception", StepExecutionStatus.REINDEX_BULK_ERROR, null)});
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_BULK_ERROR));
    }

    @Test
    public void shouldInterruptStepExecutionInCaseOfExceptionThrownFromRepository_2() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_3);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_3);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new StepException("test ex", StepExecutionStatus.REINDEX_SEARCH_ERROR, null)});
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_SEARCH_ERROR));
    }

    @Test
    public void shouldInterruptStepExecutionInCaseOfExceptionThrownFromRepository_3() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_3);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_3);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new StepException("test timeout", StepExecutionStatus.REINDEX_TIMEOUT_ERROR, null)});
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.REINDEX_TIMEOUT_ERROR));
    }

    @Test
    public void shouldDetectErrorDuringReindexingData_1() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        List<BulkByScrollTask.StatusOrException> statuses = IntStream.range(0, 7).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)statuses.get(0).getException()).thenReturn((Object)new IllegalStateException("Slice 0 error"));
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn(statuses);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
    }

    @Test
    public void shouldDetectErrorDuringReindexingData_2() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        List<BulkByScrollTask.StatusOrException> statuses = IntStream.range(0, 7).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)statuses.get(6).getException()).thenReturn((Object)new IllegalStateException("Slice 7 error"));
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn(statuses);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
    }

    @Test
    public void shouldDetectErrorDuringReindexingData_3() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        List<BulkByScrollTask.StatusOrException> statuses = IntStream.range(0, 7).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)statuses.get(3).getException()).thenReturn((Object)new IllegalStateException("Slice 3 error"));
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn(statuses);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
    }

    @Test
    public void shouldDetectErrorDuringReindexingData_4() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        List<BulkByScrollTask.StatusOrException> statuses = IntStream.range(0, 7).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        Mockito.when((Object)statuses.get(2).getException()).thenReturn((Object)new IllegalStateException("Slice 2 error"));
        Mockito.when((Object)statuses.get(4).getException()).thenReturn((Object)new IllegalStateException("Slice 4 error"));
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn(statuses);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
    }

    @Test
    public void shouldDetectErrorDuringReindexingData_5() {
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)SOURCE_INDEX_NAME_1);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)DESTINATION_INDEX_NAME_1);
        Mockito.when((Object)this.stepRepository.reindexData(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.reindexResponse);
        Mockito.when((Object)this.reindexResponse.getStatus()).thenReturn((Object)this.status);
        List<BulkByScrollTask.StatusOrException> statuses = IntStream.range(0, 7).mapToObj(i -> (BulkByScrollTask.StatusOrException)Mockito.mock(BulkByScrollTask.StatusOrException.class)).toList();
        statuses.forEach(statusOrException -> Mockito.when((Object)statusOrException.getException()).thenReturn((Object)new IllegalArgumentException("Oops!")));
        Mockito.when((Object)this.status.getSliceStatuses()).thenReturn(statuses);
        StepResult result = this.step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.SLICE_PARTIAL_ERROR));
    }
}

