/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.enterprise.femt.tenants.DefaultTenantSelector;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantAccessData;
import com.floragunn.searchguard.user.User;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DefaultTenantSelectorTest {
    private final DefaultTenantSelector tenantSelector = new DefaultTenantSelector();

    @Test
    public void shouldReturnFirstOfPreferredTenants_toWhichUserHasWriteAccessOrHasReadAccessAndTenantExists() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"tenant-2", (Object)"tenant-3", (Object[])new String[]{"tenant-4", "tenant-5", "tenant-6", "tenant-7", "tenant-8"});
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"tenant-1", (Object)new TenantAccessData(false, false, false)).with((Object)"tenant-2", (Object)new TenantAccessData(false, false, true)).with((Object)"tenant-3", (Object)new TenantAccessData(false, true, false)).with((Object)"tenant-4", (Object)new TenantAccessData(false, true, true)).with((Object)"tenant-5", (Object)new TenantAccessData(true, false, false)).with((Object)"tenant-6", (Object)new TenantAccessData(true, false, true)).with((Object)"tenant-7", (Object)new TenantAccessData(true, true, false)).with((Object)"tenant-8", (Object)new TenantAccessData(true, true, true)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-3"));
        tenantAccess = tenantAccess.without((Object)"tenant-3");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-4"));
        tenantAccess = tenantAccess.without((Object)"tenant-4");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-6"));
        tenantAccess = tenantAccess.without((Object)"tenant-6");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-7"));
        tenantAccess = tenantAccess.without((Object)"tenant-7");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-8"));
        tenantAccess = tenantAccess.without((Object)"tenant-8");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnFirstOfPreferredTenants_toWhichUserHasWriteAccessOrHasReadAccessAndTenantExists_globalTenantPreferred() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"global", (Object)"tenant-2", (Object[])new String[0]);
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"tenant-1", (Object)new TenantAccessData(true, false, false)).with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(true, false, true)).with((Object)"tenant-2", (Object)new TenantAccessData(true, true, true)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"GlObAl", (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"__global__", (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"__gLObAl__", (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
    }

    @Test
    public void shouldReturnFirstOfPreferredTenants_toWhichUserHasWriteAccessOrHasReadAccessAndTenantExists_privateTenantPreferred() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"private", (Object)"tenant-2", (Object[])new String[0]);
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"tenant-1", (Object)new TenantAccessData(true, false, false)).with((Object)user.getName(), (Object)new TenantAccessData(true, false, true)).with((Object)"tenant-2", (Object)new TenantAccessData(true, true, true)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)user.getName()));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"pRiVaTe", (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)user.getName()));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"__user__", (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)user.getName()));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)"__UsEr__", (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)user.getName()));
        preferredTenants = ImmutableList.of((Object)"tenant-1", (Object)user.getName(), (Object)"tenant-2", (Object[])new String[0]);
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)user.getName()));
    }

    @Test
    public void shouldReturnGlobalTenant_userHasNoAccessToPreferredTenant_butHasWriteAccessToGlobal() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"preferred-1");
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(false, true, false)).with((Object)"tenant-2", (Object)new TenantAccessData(true, false, false)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
        tenantAccess = tenantAccess.with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(false, true, true));
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
    }

    @Test
    public void shouldReturnGlobalTenant_userHasNoAccessToPreferredTenant_butHasReadAccessToGlobalAndGlobalExists() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"preferred-1");
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(true, false, true)).with((Object)"tenant-2", (Object)new TenantAccessData(true, false, false)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
        tenantAccess = tenantAccess.with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(true, false, false));
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
        tenantAccess = tenantAccess.with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(false, false, false));
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
        tenantAccess = tenantAccess.with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(false, false, true));
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnPrivateTenant_userHasNoAccessToPreferredAndGlobalTenant_butPrivateTenantIsEnabled() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"preferred-1");
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"preferred-1", (Object)new TenantAccessData(true, false, false)).with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(true, false, false)).with((Object)user.getName(), (Object)new TenantAccessData(false, false, false)).with((Object)"tenant-1", (Object)new TenantAccessData(true, false, false)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"__user__"));
        tenantAccess = tenantAccess.without((Object)user.getName());
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnFirstOfTenantsAvailableToUser_toWhichUserHasWriteAccessOrReadAccessAndTenantExists() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"preferred-1");
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"preferred-1", (Object)new TenantAccessData(true, false, false)).with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(true, false, false)).with((Object)"tenant-1", (Object)new TenantAccessData(false, false, false)).with((Object)"tenant-2", (Object)new TenantAccessData(false, false, true)).with((Object)"tenant-3", (Object)new TenantAccessData(false, true, false)).with((Object)"tenant-4", (Object)new TenantAccessData(false, true, true)).with((Object)"tenant-5", (Object)new TenantAccessData(true, false, false)).with((Object)"tenant-6", (Object)new TenantAccessData(true, false, true)).with((Object)"tenant-7", (Object)new TenantAccessData(true, true, false)).with((Object)"tenant-8", (Object)new TenantAccessData(true, true, true)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-3"));
        tenantAccess = tenantAccess.without((Object)"tenant-3");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-4"));
        tenantAccess = tenantAccess.without((Object)"tenant-4");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-6"));
        tenantAccess = tenantAccess.without((Object)"tenant-6");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-7"));
        tenantAccess = tenantAccess.without((Object)"tenant-7");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)selectedTenant.get()), (Matcher)Matchers.equalTo((Object)"tenant-8"));
        tenantAccess = tenantAccess.without((Object)"tenant-8");
        selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotReturnAnyTenant_userDoesNotHaveWriteAccessToAnyTenant_andHasReadAccessOnlyToNotExistingTenants() {
        User user = User.forUser((String)"user").build();
        ImmutableList preferredTenants = ImmutableList.of((Object)"preferred-1");
        ImmutableMap tenantAccess = new ImmutableMap.Builder().with((Object)"preferred-1", (Object)new TenantAccessData(true, false, false)).with((Object)"SGS_GLOBAL_TENANT", (Object)new TenantAccessData(true, false, false)).with((Object)"tenant-1", (Object)new TenantAccessData(true, false, false)).with((Object)"tenant-2", (Object)new TenantAccessData(false, false, true)).build();
        Optional selectedTenant = this.tenantSelector.findDefaultTenantForUser(user, (Map)tenantAccess, (List)preferredTenants);
        MatcherAssert.assertThat((Object)selectedTenant.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }
}

