/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.TenantAccessMapper;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidator;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigApi;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyEnabledFlagValidator;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyTenantAccessMapper;
import com.floragunn.searchguard.enterprise.femt.MultiTenancyAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.RoleBasedTenantAuthorization;
import com.floragunn.searchguard.enterprise.femt.datamigration880.rest.DataMigrationApi;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandlerFactory;
import com.floragunn.searchguard.enterprise.femt.tenants.AvailableTenantService;
import com.floragunn.searchguard.enterprise.femt.tenants.MultitenancyActivationService;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantRepository;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class FeMultiTenancyModule
implements SearchGuardModule,
ComponentStateProvider {
    private static final StaticSettings.Attribute<Boolean> UNSUPPORTED_SINGLE_INDEX_MT_ENABLED = StaticSettings.Attribute.define((String)"searchguard.unsupported.single_index_mt_enabled").withDefault(true).asBoolean();
    private static final Logger log = LogManager.getLogger(FeMultiTenancyModule.class);
    private final ComponentState componentState = new ComponentState(1000, null, "fe_multi_tenancy", FeMultiTenancyModule.class).requiresEnterpriseLicense();
    private volatile boolean enabled;
    private volatile MultiTenancyAuthorizationFilter multiTenancyAuthorizationFilter;
    private volatile FeMultiTenancyConfig config;
    private volatile RoleBasedTenantAuthorization tenantAuthorization;
    private volatile TenantManager tenantManager;
    private volatile FeMultiTenancyTenantAccessMapper feMultiTenancyTenantAccessMapper;
    private volatile ImmutableSet<String> tenantNames = ImmutableSet.empty();
    private ThreadPool threadPool;
    private AdminDNs adminDns;
    private FeMultiTenancyEnabledFlagValidator feMultiTenancyEnabledFlagValidator;
    private static final CType<FeMultiTenancyConfig> TYPE = FeMultiTenancyConfig.TYPE;
    private final TenantAccessMapper tenantAccessMapper = new TenantAccessMapper(){

        public Map<String, Boolean> mapTenantsAccess(User user, boolean adminUser, Set<String> roles) {
            if (!FeMultiTenancyModule.this.enabled) {
                return ImmutableMap.empty();
            }
            return FeMultiTenancyModule.this.feMultiTenancyTenantAccessMapper.mapTenantsAccess(user, adminUser, roles);
        }
    };
    private final SyncAuthorizationFilter syncAuthorizationFilter = new SyncAuthorizationFilter(){

        public SyncAuthorizationFilter.Result apply(PrivilegesEvaluationContext context, ActionListener<?> listener) {
            MultiTenancyAuthorizationFilter delegate = FeMultiTenancyModule.this.multiTenancyAuthorizationFilter;
            if (FeMultiTenancyModule.this.enabled && delegate != null) {
                return delegate.apply(context, listener);
            }
            return SyncAuthorizationFilter.Result.OK;
        }
    };

    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        FeMultiTenancyConfigurationProvider feMultiTenancyConfigurationProvider = new FeMultiTenancyConfigurationProvider(this);
        this.threadPool = baseDependencies.getThreadPool();
        this.adminDns = new AdminDNs(baseDependencies.getSettings());
        this.feMultiTenancyEnabledFlagValidator = new FeMultiTenancyEnabledFlagValidator(feMultiTenancyConfigurationProvider, baseDependencies.getClusterService(), baseDependencies.getConfigurationRepository());
        TenantRepository tenantRepository = new TenantRepository(PrivilegedConfigClient.adapt((Client)baseDependencies.getLocalClient()));
        MultitenancyActivationService activationService = new MultitenancyActivationService(tenantRepository, baseDependencies.getConfigurationRepository(), feMultiTenancyConfigurationProvider);
        baseDependencies.getConfigurationRepository().subscribeOnChange(configMap -> {
            ImmutableSet tenantNames;
            SgDynamicConfiguration config = configMap.get(FeMultiTenancyConfig.TYPE);
            SgDynamicConfiguration legacyConfig = configMap.get(CType.CONFIG);
            FeMultiTenancyConfig feMultiTenancyConfig = null;
            if (config != null && config.getCEntry("default") != null) {
                feMultiTenancyConfig = (FeMultiTenancyConfig)config.getCEntry("default");
                this.componentState.setState(ComponentState.State.INITIALIZED, "using_authc_config");
                this.componentState.setConfigVersion(config.getDocVersion());
            } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                try {
                    LegacySgConfig sgConfig = (LegacySgConfig)legacyConfig.getCEntry("sg_config");
                    feMultiTenancyConfig = FeMultiTenancyConfig.parseLegacySgConfig(sgConfig.getSource(), null);
                    this.componentState.setState(ComponentState.State.INITIALIZED, "using_legacy_config");
                    this.componentState.setConfigVersion(legacyConfig.getDocVersion());
                }
                catch (ConfigValidationException e) {
                    log.warn("Error while parsing legacy MT configuration", (Throwable)e);
                    this.componentState.setFailed((Throwable)e);
                    this.componentState.setConfigVersion(legacyConfig.getDocVersion());
                }
            } else {
                feMultiTenancyConfig = FeMultiTenancyConfig.DEFAULT;
                this.componentState.setState(ComponentState.State.INITIALIZED, "using_default_config");
                this.componentState.setConfigVersion(config.getDocVersion());
            }
            this.config = feMultiTenancyConfig;
            SgDynamicConfiguration tenantConfig = configMap.get(CType.TENANTS);
            this.tenantNames = tenantNames = ImmutableSet.of((Collection)tenantConfig.getCEntries().keySet());
            SgDynamicConfiguration roles = configMap.get(CType.ROLES);
            SgDynamicConfiguration tenants = configMap.get(CType.TENANTS);
            ActionGroup.FlattenedIndex actionGroups = configMap.get(CType.ACTIONGROUPS) != null ? new ActionGroup.FlattenedIndex(configMap.get(CType.ACTIONGROUPS)) : ActionGroup.FlattenedIndex.EMPTY;
            this.tenantManager = new TenantManager((Set)tenants.getCEntries().keySet(), (MultiTenancyConfigurationProvider)feMultiTenancyConfigurationProvider);
            this.tenantAuthorization = new RoleBasedTenantAuthorization((SgDynamicConfiguration<Role>)roles, actionGroups, baseDependencies.getActions(), this.tenantManager, feMultiTenancyConfig.getMetricsLevel());
            this.feMultiTenancyTenantAccessMapper = new FeMultiTenancyTenantAccessMapper(this.tenantManager, this.tenantAuthorization, baseDependencies.getActions());
            RequestHandlerFactory requestHandlerFactory = new RequestHandlerFactory(baseDependencies.getLocalClient(), baseDependencies.getThreadPool().getThreadContext(), baseDependencies.getClusterService(), baseDependencies.getGuiceDependencies().getIndicesService());
            if (feMultiTenancyConfig.isEnabled()) {
                this.enabled = true;
                this.multiTenancyAuthorizationFilter = new MultiTenancyAuthorizationFilter(feMultiTenancyConfig, this.tenantAuthorization, this.tenantManager, baseDependencies.getActions(), baseDependencies.getThreadPool().getThreadContext(), baseDependencies.getLocalClient(), requestHandlerFactory);
            } else {
                this.enabled = false;
                this.componentState.setState(ComponentState.State.SUSPENDED, "disabled_by_config");
            }
            this.componentState.setConfigVersion(configMap.getVersionsAsString());
            this.componentState.replacePart(this.tenantAuthorization.getComponentState());
            this.componentState.updateStateFromParts();
            if (log.isDebugEnabled()) {
                log.debug("Using MT config: " + String.valueOf(feMultiTenancyConfig) + "\nenabled: " + this.enabled + "\nauthorization filter: " + String.valueOf(this.multiTenancyAuthorizationFilter));
            }
        });
        AvailableTenantService availableTenantService = new AvailableTenantService(feMultiTenancyConfigurationProvider, baseDependencies.getAuthorizationService(), this.threadPool, tenantRepository, baseDependencies.getAuthInfoService());
        return Arrays.asList(feMultiTenancyConfigurationProvider, this.tenantAccessMapper, availableTenantService, activationService);
    }

    TenantAccessMapper getTenantAccessMapper() {
        return this.tenantAccessMapper;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FeMultiTenancyConfig getConfig() {
        return this.config;
    }

    ImmutableSet<String> getTenantNames() {
        return this.tenantNames;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return ImmutableList.of((Object)FeMultiTenancyConfigApi.REST_API, (Object)DataMigrationApi.REST_API);
    }

    public ImmutableList<ActionPlugin.ActionHandler<?, ?>> getActions() {
        return FeMultiTenancyConfigApi.ACTION_HANDLERS.with(DataMigrationApi.ACTION_HANDLERS);
    }

    public ImmutableSet<String> getCapabilities() {
        return ImmutableSet.of((Object)"fe_multi_tenancy");
    }

    public ImmutableList<SyncAuthorizationFilter> getPrePrivilegeEvaluationSyncAuthorizationFilters() {
        return ImmutableList.of((Object)this.syncAuthorizationFilter);
    }

    public StaticSettings.AttributeSet getSettings() {
        return StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{UNSUPPORTED_SINGLE_INDEX_MT_ENABLED});
    }

    public ImmutableList<ConfigModificationValidator<?>> getConfigModificationValidators() {
        return ImmutableList.of((Object)((Object)this.feMultiTenancyEnabledFlagValidator));
    }
}

