/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.TenantAccessMapper;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.tenants.AvailableTenantData;
import com.floragunn.searchguard.enterprise.femt.tenants.AvailableTenantService;
import com.floragunn.searchguard.enterprise.femt.tenants.DefaultTenantNotFoundException;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantAccessData;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantRepository;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class AvailableTenantServiceTest {
    public static final String TENANT_1 = "tenant-1";
    public static final String TENANT_2 = "tenant-2";
    public static final String TENANT_3 = "tenant-3";
    public static final String TENANT_4 = "tenant-4";
    public static final String TENANT_5 = "tenant-5";
    @Mock
    private MultiTenancyConfigurationProvider configProvider;
    @Mock
    private AuthorizationService authorizationService;
    @Mock
    private ThreadPool threadPool;
    @Mock
    private TenantRepository repository;
    @Mock
    private ThreadContext threadContext;
    @Mock
    private TenantAccessMapper accessMapper;
    @Mock
    private AuthInfoService authInfoService;
    private AvailableTenantService service;

    @Before
    public void before() {
        Mockito.when((Object)this.threadPool.getThreadContext()).thenReturn((Object)this.threadContext);
        this.service = new AvailableTenantService(this.configProvider, this.authorizationService, this.threadPool, this.repository, this.authInfoService);
    }

    @Test
    public void shouldReturnErrorWhenUserIsNotPresentInContext() {
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn(null);
        Optional response = this.service.findTenantAvailableForCurrentUser();
        MatcherAssert.assertThat((Object)response.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldThrowExceptionWhenMultiTenancyIsEnabledAndUserHaveAccessToZeroTenants() {
        User user = new User("user");
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)ImmutableSet.of((Object)"my_role"));
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenAnswer((Answer)new TenantExistsAnswer(true));
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        this.service = new AvailableTenantService(this.configProvider, this.authorizationService, this.threadPool, this.repository, this.authInfoService);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        ThrowableAssert.assertThatThrown(() -> this.service.findTenantAvailableForCurrentUser(), (Matcher[])new Matcher[]{Matchers.instanceOf(DefaultTenantNotFoundException.class)});
    }

    @Test
    public void shouldNotThrowExceptionWhenMultiTenancyIsDisabledAndUserHaveAccessToZeroTenants() {
        User user = User.forUser((String)"user").requestedTenant("my_tenant").build();
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)false);
        this.service = new AvailableTenantService(this.configProvider, this.authorizationService, this.threadPool, this.repository, this.authInfoService);
        AvailableTenantData tenantAvailableForCurrentUser = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().get();
        MatcherAssert.assertThat((Object)tenantAvailableForCurrentUser.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)tenantAvailableForCurrentUser.tenants(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)tenantAvailableForCurrentUser.defaultTenant(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)tenantAvailableForCurrentUser.username(), (Matcher)Matchers.equalTo((Object)"user"));
        MatcherAssert.assertThat((Object)tenantAvailableForCurrentUser.userRequestedTenant(), (Matcher)Matchers.equalTo((Object)"my_tenant"));
    }

    @Test
    public void shouldReturnInformationAboutTwoExistingTenantsWithWriteAccess() {
        User user = User.forUser((String)"user").requestedTenant("my_tenant").build();
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        ImmutableSet userRoles = ImmutableSet.of((Object)"my_role1", (Object)"myRole2");
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)userRoles);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.accessMapper.mapTenantsAccess(user, false, (Set)userRoles)).thenReturn((Object)ImmutableMap.of((Object)TENANT_1, (Object)true, (Object)TENANT_2, (Object)true));
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenAnswer((Answer)new TenantExistsAnswer(true));
        AvailableTenantData data = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().orElseThrow();
        MatcherAssert.assertThat((Object)data.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)data.userRequestedTenant(), (Matcher)Matchers.equalTo((Object)"my_tenant"));
        Map tenants = data.tenants();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.aMapWithSize((int)2));
        TenantAccessData accessData = (TenantAccessData)tenants.get(TENANT_1);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_2);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotReturnInformationAboutTenantsWithReadOnlyAccessWhichDoesNotExist() {
        User user = new User("user");
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        ImmutableSet userRoles = ImmutableSet.of((Object)"my_nice_role");
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)userRoles);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        ImmutableMap tenantWriteAccess = ImmutableMap.of((Object)TENANT_4, (Object)true, (Object)TENANT_5, (Object)false);
        Mockito.when((Object)this.accessMapper.mapTenantsAccess(user, false, (Set)userRoles)).thenReturn((Object)tenantWriteAccess);
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenAnswer((Answer)new TenantExistsAnswer(false));
        AvailableTenantData data = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().orElseThrow();
        MatcherAssert.assertThat((Object)data.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)data.userRequestedTenant(), (Matcher)Matchers.nullValue());
        Map tenants = data.tenants();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.aMapWithSize((int)1));
        TenantAccessData accessData = (TenantAccessData)tenants.get(TENANT_4);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnInformationAboutFiveVariousTenants_1() {
        User user = new User("user");
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        ImmutableSet userRoles = ImmutableSet.of((Object)"my_nice_role");
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)userRoles);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        ImmutableMap tenantWriteAccess = ImmutableMap.of((Object)TENANT_1, (Object)false, (Object)TENANT_2, (Object)true, (Object)TENANT_3, (Object)true, (Object)TENANT_4, (Object)false, (Object)TENANT_5, (Object)true);
        Mockito.when((Object)this.accessMapper.mapTenantsAccess(user, false, (Set)userRoles)).thenReturn((Object)tenantWriteAccess);
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenReturn((Object)ImmutableSet.of((Object)TENANT_1, (Object[])new String[]{TENANT_2, TENANT_4}));
        AvailableTenantData data = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().orElseThrow();
        MatcherAssert.assertThat((Object)data.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)true));
        Map tenants = data.tenants();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.aMapWithSize((int)5));
        TenantAccessData accessData = (TenantAccessData)tenants.get(TENANT_1);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_2);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_3);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)false));
        accessData = (TenantAccessData)tenants.get(TENANT_4);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_5);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnInformationAboutFiveVariousTenants_2() {
        User user = new User("user");
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        ImmutableSet userRoles = ImmutableSet.of((Object)"my_nice_role");
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)userRoles);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        ImmutableMap tenantWriteAccess = ImmutableMap.of((Object)TENANT_1, (Object)false, (Object)TENANT_2, (Object)false, (Object)TENANT_3, (Object)false, (Object)TENANT_4, (Object)true, (Object)TENANT_5, (Object)true);
        Mockito.when((Object)this.accessMapper.mapTenantsAccess(user, false, (Set)userRoles)).thenReturn((Object)tenantWriteAccess);
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenReturn((Object)ImmutableSet.of((Object)TENANT_1, (Object[])new String[]{TENANT_2, TENANT_4}));
        AvailableTenantData data = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().orElseThrow();
        MatcherAssert.assertThat((Object)data.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)true));
        Map tenants = data.tenants();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.aMapWithSize((int)4));
        TenantAccessData accessData = (TenantAccessData)tenants.get(TENANT_1);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_2);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_4);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
        accessData = (TenantAccessData)tenants.get(TENANT_5);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldDetectAdminUser() {
        User user = new User("user");
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        ImmutableSet userRoles = ImmutableSet.of((Object)"my_nice_role");
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)userRoles);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        ImmutableMap tenantWriteAccess = ImmutableMap.of((Object)TENANT_1, (Object)true);
        boolean adminUser = true;
        Mockito.when((Object)this.accessMapper.mapTenantsAccess(user, adminUser, (Set)userRoles)).thenReturn((Object)tenantWriteAccess);
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenReturn((Object)ImmutableSet.of((Object)TENANT_1));
        Mockito.when((Object)this.authInfoService.isAdmin(user)).thenReturn((Object)adminUser);
        AvailableTenantData data = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().orElseThrow();
        MatcherAssert.assertThat((Object)data.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)true));
        Map tenants = data.tenants();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.aMapWithSize((int)1));
        TenantAccessData accessData = (TenantAccessData)tenants.get(TENANT_1);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldDetectNonAdminUser() {
        User user = new User("user");
        TransportAddress remoteAddress = new TransportAddress(new InetSocketAddress(8901));
        Mockito.when((Object)this.threadContext.getTransient("_sg_user")).thenReturn((Object)user);
        Mockito.when((Object)this.threadContext.getTransient("_sg_remote_address")).thenReturn((Object)remoteAddress);
        ImmutableSet userRoles = ImmutableSet.of((Object)"my_nice_role");
        Mockito.when((Object)this.authorizationService.getMappedRoles(user, remoteAddress)).thenReturn((Object)userRoles);
        Mockito.when((Object)this.configProvider.getTenantAccessMapper()).thenReturn((Object)this.accessMapper);
        Mockito.when((Object)this.configProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        ImmutableMap tenantWriteAccess = ImmutableMap.of((Object)TENANT_1, (Object)true);
        boolean adminUser = false;
        Mockito.when((Object)this.accessMapper.mapTenantsAccess(user, adminUser, (Set)userRoles)).thenReturn((Object)tenantWriteAccess);
        Mockito.when((Object)this.repository.exists((String[])ArgumentMatchers.any(String[].class))).thenReturn((Object)ImmutableSet.of((Object)TENANT_1));
        Mockito.when((Object)this.authInfoService.isAdmin(user)).thenReturn((Object)adminUser);
        AvailableTenantData data = (AvailableTenantData)this.service.findTenantAvailableForCurrentUser().orElseThrow();
        MatcherAssert.assertThat((Object)data.multiTenancyEnabled(), (Matcher)Matchers.equalTo((Object)true));
        Map tenants = data.tenants();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.aMapWithSize((int)1));
        TenantAccessData accessData = (TenantAccessData)tenants.get(TENANT_1);
        MatcherAssert.assertThat((Object)accessData.readAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.writeAccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)accessData.exists(), (Matcher)Matchers.equalTo((Object)true));
    }

    private static class TenantExistsAnswer
    implements Answer<ImmutableSet<String>> {
        private final boolean eachTenantExists;

        public TenantExistsAnswer(boolean eachTenantExists) {
            this.eachTenantExists = eachTenantExists;
        }

        public ImmutableSet<String> answer(InvocationOnMock invocation) {
            if (this.eachTenantExists) {
                ImmutableSet.Builder builder = new ImmutableSet.Builder();
                for (int i = 0; i < invocation.getArguments().length; ++i) {
                    String tenantName = (String)invocation.getArgument(i);
                    builder.add((Object)tenantName);
                }
                return builder.build();
            }
            return ImmutableSet.empty();
        }
    }
}

