/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;

class CreateBackupOfGlobalIndexStep
implements MigrationStep {
    private final StepRepository repository;
    private final IndexSettingsManager indexSettingsManager;

    public CreateBackupOfGlobalIndexStep(StepRepository repository, IndexSettingsManager indexSettingsManager) {
        this.repository = Objects.requireNonNull(repository, "Step repository is required");
        this.indexSettingsManager = Objects.requireNonNull(indexSettingsManager, "Index setting duplicator is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        long documentsInDestination;
        String backupSource = context.getGlobalTenantIndexName();
        context.setBackupCreated(false);
        if (this.indexSettingsManager.isMigrationMarkerPresent(backupSource)) {
            return new StepResult(StepExecutionStatus.OK, "Backup creation omitted", "Index '" + backupSource + "' contains already migrated data");
        }
        String backupDestination = context.getBackupIndexName();
        this.indexSettingsManager.createIndexWithClonedSettings(backupSource, backupDestination, false);
        BulkByScrollResponse response = this.repository.reindexData(backupSource, backupDestination);
        StringBuilder details = new StringBuilder("Backup of ").append(response.getTotal()).append(" documents ").append("from index '").append(backupSource).append("' placed in '").append(backupDestination).append("'. ").append("It took ").append(response.getTook()).append(", ").append("created documents ").append(response.getCreated()).append(", ").append("updated documents ").append(response.getUpdated()).append(", ").append("deleted documents ").append(response.getDeleted()).append(", ").append("version conflicts ").append(response.getVersionConflicts()).append(", ").append(" used ").append(response.getBatches()).append(" batches, ").append("batch retries ").append(response.getBulkRetries()).append(", ").append("search retries ").append(response.getSearchRetries()).append(".");
        List sliceStatuses = response.getStatus().getSliceStatuses();
        boolean errorDetected = false;
        for (int i = 0; i < sliceStatuses.size(); ++i) {
            BulkByScrollTask.StatusOrException currentStatus = (BulkByScrollTask.StatusOrException)sliceStatuses.get(i);
            Exception exception = currentStatus.getException();
            if (exception == null) continue;
            errorDetected = true;
            String stackTraceAsString = Throwables.getStackTraceAsString((Throwable)exception);
            details.append(" Slice no. ").append(i).append(" error detected ").append(stackTraceAsString).append(".");
        }
        if (errorDetected) {
            return new StepResult(StepExecutionStatus.SLICE_PARTIAL_ERROR, "Cannot copy data to backup index", details.toString());
        }
        if (!this.isZero(response.getUpdated(), response.getDeleted(), response.getVersionConflicts())) {
            String message = "Documents should be not updated or deleted, version conflicts are not allowed";
            return new StepResult(StepExecutionStatus.BACKUP_UNEXPECTED_OPERATION_ERROR, message, details.toString());
        }
        long documentInSource = this.repository.countDocuments(backupSource);
        if (documentInSource != (documentsInDestination = this.repository.countDocuments(backupDestination))) {
            String message = "Backup does not contains all required documents.";
            String description = "Expected number of documents " + documentInSource + " in index '" + backupSource + "', actual number of documents " + documentsInDestination + " in index '" + backupDestination + "'.";
            return new StepResult(StepExecutionStatus.MISSING_DOCUMENTS_IN_BACKUP_ERROR, message, description);
        }
        this.repository.writeBlockIndices((ImmutableList<String>)ImmutableList.of((Object)backupDestination));
        context.setBackupCreated(true);
        return new StepResult(StepExecutionStatus.OK, "Backup created", details.toString());
    }

    @Override
    public String name() {
        return "create backup of global tenant index";
    }
}

