/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class EnableMultitenancyStep
implements MigrationStep {
    private static final Logger log = LogManager.getLogger(EnableMultitenancyStep.class);
    private final FeMultiTenancyConfigurationProvider configurationProvider;
    private final ConfigurationRepository configRepository;

    public EnableMultitenancyStep(FeMultiTenancyConfigurationProvider configurationProvider, ConfigurationRepository configRepository) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider, "Configuration provider is required");
        this.configRepository = Objects.requireNonNull(configRepository, "Configuration repository is required");
    }

    @Override
    public StepResult execute(DataMigrationContext dataMigrationContext) throws StepException {
        FeMultiTenancyConfig configuration = this.configurationProvider.getConfig().orElse(FeMultiTenancyConfig.DEFAULT);
        if (configuration.isEnabled()) {
            return new StepResult(StepExecutionStatus.OK, "Multitenancy is already enabled", "Nothing to be done");
        }
        return this.enableMultitenancy(configuration);
    }

    private StepResult enableMultitenancy(FeMultiTenancyConfig configuration) {
        StepResult stepResult;
        block8: {
            FeMultiTenancyConfig newConfig = configuration.withEnabled(true);
            SgDynamicConfiguration config = SgDynamicConfiguration.of(FeMultiTenancyConfig.TYPE, (String)"default", (Object)newConfig);
            try {
                this.configRepository.update(FeMultiTenancyConfig.TYPE, config, null, false);
                stepResult = new StepResult(StepExecutionStatus.OK, "Multitenancy has been enabled.", "New configuration " + newConfig);
                if (config == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (config != null) {
                        try {
                            config.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ConfigValidationException | ConcurrentConfigUpdateException | ConfigUpdateException e) {
                    log.error("Cannot enable multitenancy", e);
                    throw new StepException("Cannot enable multitenancy", StepExecutionStatus.CANNOT_ENABLE_MULTITENANCY, e.getMessage());
                }
            }
            config.close();
        }
        return stepResult;
    }

    @Override
    public String name() {
        return "Enable multitenancy";
    }
}

