/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.tenants.MultitenancyActivationService;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantRepository;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.Constants;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class TenantsTest {
    private static final Logger log = LogManager.getLogger(TenantsTest.class);
    private static final String FRONTEND_INDEX = ".kibana";
    private static final TestSgConfig.Tenant HR_TENANT = new TestSgConfig.Tenant("hr_tenant");
    private static final TestSgConfig.Tenant FINANCE_TENANT = new TestSgConfig.Tenant("finance_tenant");
    private static final TestSgConfig.Tenant SALES_TENANT = new TestSgConfig.Tenant("sales_tenant");
    private static final TestSgConfig.Tenant OPERATIONS_TENANT = new TestSgConfig.Tenant("operations_tenant");
    private static final TestSgConfig.Tenant RD_TENANT = new TestSgConfig.Tenant("r&d_tenant");
    private static final TestSgConfig.Tenant BD_TENANT = new TestSgConfig.Tenant("business_development_tenant");
    private static final TestSgConfig.Tenant LEGAL_TENANT = new TestSgConfig.Tenant("legal_tenant");
    private static final TestSgConfig.Tenant IT_TENANT = new TestSgConfig.Tenant("information_technology_tenant");
    private static final TestSgConfig.Tenant PR_TENANT = new TestSgConfig.Tenant("public_relations_tenant");
    private static final TestSgConfig.Tenant QA_TENANT = new TestSgConfig.Tenant("quality_assurance_tenant");
    private MultitenancyActivationService multitenancyActivationService;
    private static final ImmutableList<TestSgConfig.Tenant> ALL_DEFINED_TENANTS = ImmutableList.of((Object)HR_TENANT, (Object)FINANCE_TENANT, (Object)SALES_TENANT, (Object[])new TestSgConfig.Tenant[]{OPERATIONS_TENANT, RD_TENANT, BD_TENANT, LEGAL_TENANT, IT_TENANT, PR_TENANT, QA_TENANT});
    private static final TestSgConfig.User USER_SINGLE_TENANT = new TestSgConfig.User("user_single_tenant").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("single_tenant_access").withTenantPermission(new String[]{"*"}).on(new String[]{HR_TENANT.getName()}).indexPermissions(new String[]{"*"}).on(new String[]{".kibana*"})});
    private static final TestSgConfig.User FRONTEND_SERVER_USER = new TestSgConfig.User("kibana_server");
    private static final TestSgConfig.User USER_EACH_TENANT_READ = new TestSgConfig.User("user_each_tenant_read").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("each_tenant_read_access").withTenantPermission(new String[]{"SGS_KIBANA_ALL_READ"}).on((String[])ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName).with((Object)"SGS_GLOBAL_TENANT").toArray(String[]::new)).indexPermissions(new String[]{"*"}).on(new String[]{".kibana*"})});
    private static final TestSgConfig.User USER_EACH_TENANT_WRITE = new TestSgConfig.User("user_each_tenant_write").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("each_tenant_write_access").withTenantPermission(new String[]{"SGS_KIBANA_ALL_WRITE"}).on((String[])ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName).with((Object)"SGS_GLOBAL_TENANT").toArray(String[]::new)).indexPermissions(new String[]{"*"}).on(new String[]{".kibana*"})});
    private static final TestSgConfig.User USER_SOME_TENANT_ACCESS = new TestSgConfig.User("user_some_tenant_access").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("some_tenant_access").withTenantPermission(new String[]{"SGS_KIBANA_ALL_WRITE"}).on(new String[]{HR_TENANT.getName(), FINANCE_TENANT.getName(), SALES_TENANT.getName()}).withTenantPermission(new String[]{"SGS_KIBANA_ALL_READ"}).on(new String[]{IT_TENANT.getName(), PR_TENANT.getName(), QA_TENANT.getName()}).indexPermissions(new String[]{"*"}).on(new String[]{".kibana*"})});
    private static final TestSgConfig.User USER_WITH_ACCESS_ONLY_TO_GLOBAL_TENANT = new TestSgConfig.User("user_with_access_only_to_global_tenant").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("global_tenant_access").clusterPermissions(new String[]{"cluster:admin:searchguard:femt:user/available_tenants/get"}).withTenantPermission(new String[]{"*"}).on(new String[]{"SGS_GLOBAL_TENANT"})});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().nodeSettings(new Object[]{"action.destructive_requires_name", false, "searchguard.unsupported.single_index_mt_enabled", true}).enterpriseModulesEnabled().roleMapping(new TestSgConfig.RoleMapping[]{new TestSgConfig.RoleMapping("SGS_KIBANA_USER").users(new String[]{USER_SINGLE_TENANT.getName(), USER_EACH_TENANT_READ.getName(), USER_EACH_TENANT_WRITE.getName(), USER_SOME_TENANT_ACCESS.getName()}), new TestSgConfig.RoleMapping("SGS_KIBANA_SERVER").users(new String[]{FRONTEND_SERVER_USER.getName()})}).users(new TestSgConfig.User[]{FRONTEND_SERVER_USER, USER_SINGLE_TENANT, USER_EACH_TENANT_READ, USER_EACH_TENANT_WRITE, USER_SOME_TENANT_ACCESS, USER_WITH_ACCESS_ONLY_TO_GLOBAL_TENANT}).frontendMultiTenancy(new TestSgConfig.FrontendMultiTenancy(true).index(".kibana").serverUser(FRONTEND_SERVER_USER.getName())).tenants(new TestSgConfig.Tenant[]{HR_TENANT, FINANCE_TENANT, SALES_TENANT, OPERATIONS_TENANT, RD_TENANT, BD_TENANT, LEGAL_TENANT, IT_TENANT, PR_TENANT, QA_TENANT}).embedded().build();

    @Before
    public void setUpIndex() {
        Client client = cluster.getInternalNodeClient();
        DocNode indexMappings = DocNode.of((String)"_doc", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"sg_tenant", (Object)DocNode.of((String)"type", (Object)"keyword"))));
        CreateIndexRequest request = new CreateIndexRequest(FRONTEND_INDEX).settings(Settings.builder().put("index.hidden", true)).mapping((Map)indexMappings);
        CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(request).actionGet();
        MatcherAssert.assertThat((Object)response.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Before
    public void setUpTestedDependencies() {
        TenantRepository tenantRepository = new TenantRepository(PrivilegedConfigClient.adapt((Client)((Client)cluster.getInjectable(NodeClient.class))));
        ConfigurationRepository configurationRepository = (ConfigurationRepository)cluster.getInjectable(ConfigurationRepository.class);
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        this.multitenancyActivationService = new MultitenancyActivationService(tenantRepository, configurationRepository, configurationProvider);
    }

    @After
    public void clearIndices() {
        this.removeKibanaRelatedIndices();
    }

    @Test
    public void getAvailableTenantsAction_shouldFindAccessibleTenantsForSingleTenantUser() throws Exception {
        this.createTenants(FRONTEND_INDEX, (String[])ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName).toArray(String[]::new));
        BasicHeader tenantHeader = new BasicHeader("sg_tenant", "test_tenant");
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_SINGLE_TENANT, new Header[]{tenantHeader});){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.default_tenant", (Object)"SGS_GLOBAL_TENANT"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.username", (Object)USER_SINGLE_TENANT.getName()));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.user_requested_tenant", (Object)tenantHeader.getValue()));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.multi_tenancy_enabled", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.hr_tenant.read_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.hr_tenant.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.hr_tenant.exists", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_single_tenant", (String)"read_access")));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_single_tenant", (String)"write_access")));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_single_tenant", (String)"exists")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.read_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.exists", (Object)false));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsOnlyFields((String)"$.data.tenants", (String[])new String[]{"hr_tenant", "SGS_GLOBAL_TENANT"}));
        }
    }

    @Test
    public void getAvailableTenantsAction_shouldFindAccessibleTenantsForUserAllowedToReadEachTenantData() throws Exception {
        String[] tenantsToBeCreated = (String[])ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName).with((Object)USER_EACH_TENANT_READ.getName()).toArray(String[]::new);
        this.createTenants(FRONTEND_INDEX, tenantsToBeCreated);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_EACH_TENANT_READ, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsOnlyFields((String)"$.data.tenants", (String[])new String[]{"business_development_tenant", "sales_tenant", "quality_assurance_tenant", "finance_tenant", "SGS_GLOBAL_TENANT", "operations_tenant", "public_relations_tenant", "hr_tenant", "legal_tenant", "r&d_tenant", "information_technology_tenant"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.default_tenant", (Object)"SGS_GLOBAL_TENANT"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.username", (Object)USER_EACH_TENANT_READ.getName()));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsNullValue((String)"$.data.user_requested_tenant"));
            for (String tenantName : ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName)) {
                String readAccessPath = "$.data.tenants." + tenantName + ".read_access";
                String writeAccessPath = "$.data.tenants." + tenantName + ".write_access";
                String existPath = "$.data.tenants." + tenantName + ".exists";
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)readAccessPath, (Object)true));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)writeAccessPath, (Object)false));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)existPath, (Object)true));
            }
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_each_tenant_read", (String)"write_access")));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_each_tenant_read", (String)"exists")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.read_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.exists", (Object)false));
        }
    }

    @Test
    public void getAvailableTenantsAction_shouldFindAccessibleTenantsForUserAllowedToWriteEachTenantData() throws Exception {
        String[] tenantsToBeCreated = (String[])ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName).with((Object)USER_EACH_TENANT_WRITE.getName()).toArray(String[]::new);
        this.createTenants(FRONTEND_INDEX, tenantsToBeCreated);
        List<String> tenantsWithoutPrivate = Arrays.stream(tenantsToBeCreated).filter(tenant -> !tenant.equals(USER_EACH_TENANT_WRITE.getName())).toList();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_EACH_TENANT_WRITE, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsOnlyFields((String)"$.data.tenants", (String[])new String[]{"business_development_tenant", "information_technology_tenant", "sales_tenant", "quality_assurance_tenant", "finance_tenant", "SGS_GLOBAL_TENANT", "operations_tenant", "public_relations_tenant", "hr_tenant", "legal_tenant", "r&d_tenant"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.default_tenant", (Object)"SGS_GLOBAL_TENANT"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.username", (Object)USER_EACH_TENANT_WRITE.getName()));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsNullValue((String)"$.data.user_requested_tenant"));
            for (String tenantName : tenantsWithoutPrivate) {
                String readAccessPath = "$.data.tenants." + tenantName + ".read_access";
                String writeAccessPath = "$.data.tenants." + tenantName + ".write_access";
                String existPath = "$.data.tenants." + tenantName + ".exists";
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)readAccessPath, (Object)true));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)writeAccessPath, (Object)true));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)existPath, (Object)true));
            }
        }
    }

    @Test
    public void getAvailableTenantsAction_shouldFindAccessibleTenantsWhichDoesNotExist() throws Exception {
        String[] accessibleTenantsNames = (String[])ALL_DEFINED_TENANTS.map(TestSgConfig.Tenant::getName).toArray(String[]::new);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_EACH_TENANT_WRITE, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsOnlyFields((String)"$.data.tenants", (String[])new String[]{"business_development_tenant", "information_technology_tenant", "sales_tenant", "quality_assurance_tenant", "finance_tenant", "SGS_GLOBAL_TENANT", "operations_tenant", "public_relations_tenant", "hr_tenant", "legal_tenant", "r&d_tenant"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.default_tenant", (Object)"SGS_GLOBAL_TENANT"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.username", (Object)USER_EACH_TENANT_WRITE.getName()));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsNullValue((String)"$.data.user_requested_tenant"));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_each_tenant_write", (String)"read_access")));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_each_tenant_write", (String)"write_access")));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_each_tenant_write", (String)"exists")));
            for (String tenantName : accessibleTenantsNames) {
                String readAccessPath = "$.data.tenants." + tenantName + ".read_access";
                String writeAccessPath = "$.data.tenants." + tenantName + ".write_access";
                String existPath = "$.data.tenants." + tenantName + ".exists";
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)readAccessPath, (Object)true));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)writeAccessPath, (Object)true));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)existPath, (Object)false));
            }
        }
    }

    @Test
    public void getAvailableTenantsAction_shouldReturnInformationIfTenantIsAccessibleAndExist() throws Exception {
        this.createTenants(FRONTEND_INDEX, HR_TENANT.getName(), FINANCE_TENANT.getName(), PR_TENANT.getName(), QA_TENANT.getName());
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_SOME_TENANT_ACCESS, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsOnlyFields((String)"$.data.tenants", (String[])new String[]{"sales_tenant", "quality_assurance_tenant", "finance_tenant", "SGS_GLOBAL_TENANT", "public_relations_tenant", "hr_tenant"}));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.default_tenant", (Object)"SGS_GLOBAL_TENANT"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.username", (Object)USER_SOME_TENANT_ACCESS.getName()));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsNullValue((String)"$.data.user_requested_tenant"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.public_relations_tenant.write_access", (Object)false));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.public_relations_tenant.exists", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.quality_assurance_tenant.write_access", (Object)false));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.quality_assurance_tenant.exists", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.hr_tenant.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.hr_tenant.exists", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.finance_tenant.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.finance_tenant.exists", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.sales_tenant.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.sales_tenant.exists", (Object)false));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_some_tenant_access", (String)"write_access")));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants.user_some_tenant_access", (String)"exists")));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.read_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.exists", (Object)false));
        }
    }

    @Test
    public void getAvailableTenantsAction_shouldNotBeAccessibleForFrontendServerUser() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)FRONTEND_SERVER_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
        }
    }

    @Test
    public void getAvailableTenantsAction_shouldReturnUnauthorized_whenUserDoesNotHaveAccessToAnyTenantAndDefaultTenantCannotBeDetermined() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_WITH_ACCESS_ONLY_TO_GLOBAL_TENANT, new Header[0]);
             GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.default_tenant", (Object)"SGS_GLOBAL_TENANT"));
            cluster.callAndRestoreConfig(FeMultiTenancyConfig.TYPE, () -> {
                GenericRestClient.HttpResponse getConfigResponse = adminClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)getConfigResponse.getBody(), (Object)getConfigResponse, (Matcher)RestMatchers.isOk());
                DocNode config = getConfigResponse.getBodyAsDocNode().getAsNode("content");
                config = config.with("global_tenant_enabled", (Object)false);
                GenericRestClient.HttpResponse putConfigResponse = adminClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)putConfigResponse.getBody(), (Object)putConfigResponse, (Matcher)RestMatchers.isOk());
                GenericRestClient.HttpResponse getTenantsResponse = client.get("/_searchguard/current_user/tenants", new Header[0]);
                log.debug("Response status '{}' and body '{}'.", (Object)getTenantsResponse.getStatusCode(), (Object)getTenantsResponse.getBody());
                MatcherAssert.assertThat((String)getTenantsResponse.getBody(), (Object)getTenantsResponse.getStatusCode(), (Matcher)Matchers.equalTo((Object)401));
                MatcherAssert.assertThat((Object)getTenantsResponse.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.message", (Object)"Cannot determine default tenant for current user"));
                return null;
            });
        }
    }

    @Test
    public void shouldDetectThatGlobalTenantExist() throws Exception {
        this.createTenants(FRONTEND_INDEX, "SGS_GLOBAL_TENANT");
        BasicHeader tenantHeader = new BasicHeader("sg_tenant", "test_tenant");
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_SINGLE_TENANT, new Header[]{tenantHeader});){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/current_user/tenants", new Header[0]);
            log.debug("Response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.read_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.write_access", (Object)true));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.data.tenants.SGS_GLOBAL_TENANT.exists", (Object)true));
        }
    }

    @Test
    public void tenantIndexMappingsExtender_shouldAddSgTenantFieldToMappingsWhenAllKibanaIndicesExist() {
        DocNode mappings;
        this.removeKibanaRelatedIndices();
        this.multitenancyActivationService.activate();
        GetMappingsResponse getMappingsResponse = this.getKibanaIndicesMappings();
        MatcherAssert.assertThat((Object)getMappingsResponse.getMappings(), (Matcher)Matchers.anEmptyMap());
        this.createKibanaIndicesAndAliases();
        this.multitenancyActivationService.activate();
        getMappingsResponse = this.getKibanaIndicesMappings();
        MatcherAssert.assertThat(getMappingsResponse.getMappings().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{".kibana_1.2.3", ".kibana_analytics_1.2.3", ".kibana_ingest_1.2.3", ".kibana_security_solution_1.2.3", ".kibana_alerting_cases_1.2.3"}));
        for (MappingMetadata indexMapping : getMappingsResponse.getMappings().values()) {
            mappings = DocNode.wrap((Object)indexMapping.sourceAsMap());
            MatcherAssert.assertThat((Object)mappings, (Matcher)Matchers.hasKey((Object)"properties"));
            MatcherAssert.assertThat((Object)mappings.getAsNode("properties"), (Matcher)Matchers.hasKey((Object)"sg_tenant"));
            MatcherAssert.assertThat((Object)mappings.getAsNode("properties").getAsNode("sg_tenant"), (Matcher)Matchers.equalTo((Object)DocNode.of((String)"type", (Object)"keyword")));
        }
        this.multitenancyActivationService.activate();
        getMappingsResponse = this.getKibanaIndicesMappings();
        MatcherAssert.assertThat(getMappingsResponse.getMappings().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{".kibana_1.2.3", ".kibana_analytics_1.2.3", ".kibana_ingest_1.2.3", ".kibana_security_solution_1.2.3", ".kibana_alerting_cases_1.2.3"}));
        for (MappingMetadata indexMapping : getMappingsResponse.getMappings().values()) {
            mappings = DocNode.wrap((Object)indexMapping.sourceAsMap());
            MatcherAssert.assertThat((Object)mappings, (Matcher)Matchers.hasKey((Object)"properties"));
            MatcherAssert.assertThat((Object)mappings.getAsNode("properties"), (Matcher)Matchers.hasKey((Object)"sg_tenant"));
            MatcherAssert.assertThat((Object)mappings.getAsNode("properties").getAsNode("sg_tenant"), (Matcher)Matchers.equalTo((Object)DocNode.of((String)"type", (Object)"keyword")));
        }
    }

    @Test
    public void tenantIndexMappingsExtender_shouldAddSgTenantFieldToMappingsWhenSomeKibaneRelatedIndicesDoesNotExist() {
        this.removeKibanaRelatedIndices();
        this.createKibanaIndicesAndAliases(FRONTEND_INDEX, ".kibana_analytics");
        this.multitenancyActivationService.activate();
        GetMappingsResponse getMappingsResponse = this.getKibanaIndicesMappings();
        MatcherAssert.assertThat(getMappingsResponse.getMappings().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{".kibana_1.2.3", ".kibana_analytics_1.2.3"}));
        for (MappingMetadata indexMapping : getMappingsResponse.getMappings().values()) {
            DocNode mappings = DocNode.wrap((Object)indexMapping.sourceAsMap());
            MatcherAssert.assertThat((Object)mappings, (Matcher)Matchers.hasKey((Object)"properties"));
            MatcherAssert.assertThat((Object)mappings.getAsNode("properties"), (Matcher)Matchers.hasKey((Object)"sg_tenant"));
            MatcherAssert.assertThat((Object)mappings.getAsNode("properties").getAsNode("sg_tenant"), (Matcher)Matchers.equalTo((Object)DocNode.of((String)"type", (Object)"keyword")));
        }
    }

    public void createTenants(String indexName, String ... tenantNames) {
        Client client = cluster.getInternalNodeClient();
        for (String currentTenant : tenantNames) {
            ImmutableMap source = ImmutableMap.of((Object)"type", (Object)"space");
            Object spaceId = "space:default";
            if (!"SGS_GLOBAL_TENANT".equals(currentTenant)) {
                String internal = TenantManager.toInternalTenantName((String)currentTenant);
                source = source.with((Object)"sg_tenant", (Object)internal);
                spaceId = (String)spaceId + "__sg_ten__" + internal;
            }
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(indexName).id((String)spaceId).source((Map)source).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            DocWriteResponse response = (DocWriteResponse)client.index(indexRequest).actionGet();
            MatcherAssert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)RestStatus.CREATED));
        }
    }

    private void removeKibanaRelatedIndices() {
        Client client = cluster.getInternalNodeClient();
        AcknowledgedResponse deleteResponse = (AcknowledgedResponse)client.admin().indices().delete(new DeleteIndexRequest(".kibana*")).actionGet();
        MatcherAssert.assertThat((Object)deleteResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    private GetMappingsResponse getKibanaIndicesMappings() {
        Client client = cluster.getInternalNodeClient();
        return (GetMappingsResponse)client.admin().indices().getMappings((GetMappingsRequest)new GetMappingsRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{".kibana*"})).actionGet();
    }

    private void createKibanaIndicesAndAliases(String ... indices_names) {
        Client client = cluster.getInternalNodeClient();
        IndicesAliasesRequest addAliasesRequest = new IndicesAliasesRequest();
        for (String alias : indices_names) {
            String indexName = alias + "_1.2.3";
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)client.admin().indices().create(new CreateIndexRequest(indexName)).actionGet();
            MatcherAssert.assertThat((Object)createIndexResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
            addAliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().alias(alias).index(indexName));
        }
        AcknowledgedResponse addAliasesResponse = (AcknowledgedResponse)client.admin().indices().aliases(addAliasesRequest).actionGet();
        MatcherAssert.assertThat((Object)addAliasesResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void createKibanaIndicesAndAliases() {
        this.createKibanaIndicesAndAliases(TenantRepository.FRONTEND_MULTI_TENANCY_ALIASES);
    }
}

