/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.mapper;

import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.request.mapper.BulkMapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.Unscoper;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public class UpdateByQueryMapper
implements Unscoper<BulkByScrollResponse> {
    private final BulkMapper bulkMapper;
    private static final Logger log = LogManager.getLogger(UpdateByQueryMapper.class);

    public UpdateByQueryMapper(BulkMapper bulkMapper) {
        this.bulkMapper = Objects.requireNonNull(bulkMapper, "bulkMapper is required");
    }

    public UpdateByQueryRequest toScopedUpdateByQueryRequest(UpdateByQueryRequest request, String tenant) {
        log.debug("Rewriting update by query request - adding tenant scope");
        BoolQueryBuilder queryBuilder = RequestResponseTenantData.sgTenantFieldQuery(tenant);
        SearchRequest searchRequest = request.getSearchRequest();
        if (searchRequest.source().query() != null) {
            queryBuilder.must(searchRequest.source().query());
        }
        request.setQuery((QueryBuilder)queryBuilder);
        if (log.isDebugEnabled()) {
            log.debug("Query to indices '{}' was intercepted to limit access only to tenant '{}', extended query version '{}'", (Object)String.join((CharSequence)", ", request.indices()), (Object)tenant, (Object)queryBuilder);
        }
        return request;
    }

    @Override
    public BulkByScrollResponse unscopeResponse(BulkByScrollResponse response) {
        log.debug("Rewriting bulk by scroll response - removing tenant scope");
        List<BulkItemResponse.Failure> unscopedFailures = response.getBulkFailures().stream().map(this.bulkMapper::toUnscopedFailure).toList();
        return new BulkByScrollResponse(response.getTook(), response.getStatus(), unscopedFailures, response.getSearchFailures(), response.isTimedOut());
    }
}

