/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.MultiGetMapper;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class MultiGetRequestHandler
extends RequestHandler<MultiGetRequest> {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final MultiGetMapper multiGetMapper;

    public MultiGetRequestHandler(Client nodeClient, ThreadContext threadContext, MultiGetMapper multiGetMapper) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.multiGetMapper = Objects.requireNonNull(multiGetMapper, "multiGetMapper is required");
    }

    @Override
    public SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, String requestedTenant, MultiGetRequest request, ActionListener<?> listener) {
        this.log.debug("Handle multi get request");
        try (ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();){
            this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
            MultiGetRequest scopedRequest = this.multiGetMapper.toScopedMultiGetRequest(request, requestedTenant);
            TenantScopedActionListenerWrapper<MultiGetResponse> listenerWrapper = new TenantScopedActionListenerWrapper<MultiGetResponse>(listener, storedContext, this.multiGetMapper);
            this.nodeClient.multiGet(scopedRequest, listenerWrapper);
            SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
            return result;
        }
    }
}

