/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class MultitenancyTests {
    private static final Logger log = LogManager.getLogger(MultitenancyTests.class);
    private static final TestSgConfig.User USER_DEPT_01 = new TestSgConfig.User("user_dept_01").attr("dept_no", (Object)"01").roles(new String[]{"sg_tenant_user_attrs"});
    private static final TestSgConfig.User USER_DEPT_02 = new TestSgConfig.User("user_dept_02").attr("dept_no", (Object)"02").roles(new String[]{"sg_tenant_user_attrs"});
    private static final TestSgConfig.User USER_WITH_ACCESS_TO_GLOBAL_TENANT = new TestSgConfig.User("user_with_access_to_global_tenant").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("access_to_global_tenant").clusterPermissions(new String[]{"cluster:admin:searchguard:femt:user/available_tenants/get"}).withTenantPermission(new String[]{"SGS_KIBANA_ALL_WRITE"}).on(new String[]{"SGS_GLOBAL_TENANT"})});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.unsupported.single_index_mt_enabled", true}).nodeSettings(new Object[]{"action.destructive_requires_name", false}).sslEnabled().resources("multitenancy").enterpriseModulesEnabled().users(new TestSgConfig.User[]{USER_DEPT_01, USER_DEPT_02, USER_WITH_ACCESS_TO_GLOBAL_TENANT}).embedded().build();

    @Before
    public void setUp() {
        Client client = cluster.getInternalNodeClient();
        AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().delete(new DeleteIndexRequest("*")).actionGet();
        MatcherAssert.assertThat((Object)response.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMt() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("hr_employee", "hr_employee", new Header[0]);
             GenericRestClient adminClient = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
            GenericRestClient.HttpResponse response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "blafasel")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "business_intelligence")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            String tenantName = "human_resources";
            String internalTenantName = tenantName.hashCode() + "_humanresources";
            response = client.putJson(".kibana/_doc/5.6.0?pretty&refresh", body, new Header[]{new BasicHeader("sgtenant", tenantName)});
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)".kibana", (Object)response.getBodyAsDocNode().get("_index"));
            Assert.assertEquals((String)response.getBody(), (Object)"5.6.0", (Object)response.getBodyAsDocNode().get("_id"));
            response = adminClient.get(".kibana/_doc/5.6.0__sg_ten__" + internalTenantName, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = client.get(".kibana/_doc/5.6.0?pretty", new Header[]{new BasicHeader("sgtenant", tenantName)});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)".kibana", (Object)response.getBodyAsDocNode().get("_index"));
            Assert.assertEquals((String)response.getBody(), (Object)"5.6.0", (Object)response.getBodyAsDocNode().get("_id"));
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBodyAsDocNode().hasNonNull("_primary_term"));
        }
        finally {
            try {
                Client tc = cluster.getInternalNodeClient();
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMt_search() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("hr_employee", "hr_employee", new Header[0]);){
            String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
            GenericRestClient.HttpResponse response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "blafasel")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            response = client.putJson(".kibana/_doc/5.6.0?pretty", body, new Header[]{new BasicHeader("sgtenant", "business_intelligence")});
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            response = client.putJson(".kibana/_doc/5.6.0?pretty&refresh", body, new Header[]{new BasicHeader("sgtenant", "human_resources")});
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)".kibana", (Object)response.getBodyAsDocNode().get("_index"));
            Assert.assertEquals((String)response.getBody(), (Object)"5.6.0", (Object)response.getBodyAsDocNode().get("_id"));
            response = client.get(".kibana/_search", new Header[]{new BasicHeader("sgtenant", "human_resources")});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (long)1L, (long)response.getBodyAsDocNode().getAsNode("hits", new String[]{"hits"}).toList().size());
            Assert.assertEquals((String)response.getBody(), (Object)"5.6.0", (Object)((DocNode)response.getBodyAsDocNode().getAsNode("hits", new String[]{"hits"}).toListOfNodes().get(0)).get("_id"));
        }
        finally {
            try {
                Client tc = cluster.getInternalNodeClient();
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void shouldFilterTenantDocumentsDuringSearching() throws Exception {
        GenericRestClient.HttpResponse response;
        Client tc = cluster.getInternalNodeClient();
        DocNode indexMappings = DocNode.of((String)"_doc", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"sg_tenant", (Object)DocNode.of((String)"type", (Object)"keyword"))));
        ImmutableMap settings = ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0);
        tc.admin().indices().create(new CreateIndexRequest(".kibana").settings((Map)settings).mapping((Map)indexMappings)).actionGet();
        DocNode body = DocNode.of((String)"type", (Object)"custom-saved-object", (String)"updated_at", (Object)"2018-09-29T08:56:59.066Z", (String)"details.title", (Object)"humanresources", (String)"sg_tenant", (Object)"1592542611_humanresources");
        tc.index(((IndexRequest)new IndexRequest(".kibana").id("custom:hr__sg_ten__1592542611_humanresources").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source((Map)body)).actionGet();
        body = DocNode.of((String)"type", (Object)"custom-saved-object", (String)"updated_at", (Object)"2018-09-29T08:56:59.066Z", (String)"details.title", (Object)"global tenant");
        tc.index(((IndexRequest)new IndexRequest(".kibana").id("custom-saved-object:global").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source((Map)body)).actionGet();
        body = DocNode.of((String)"query.term", (Object)ImmutableMap.of((Object)"type.keyword", (Object)"custom-saved-object"));
        try (GenericRestClient client = cluster.getRestClient("admin", "admin", "SGS_GLOBAL_TENANT");){
            response = client.postJson(".kibana/_search/?pretty", (Map)body, new Header[0]);
            log.info("Search response status code '{}' and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._id", (Object)"custom-saved-object:global"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.details.title", (Object)"global tenant"));
        }
        client = cluster.getRestClient("hr_employee", "hr_employee", "human_resources");
        try {
            response = client.postJson(".kibana/_search/?pretty", (Map)body, new Header[0]);
            log.info("Search response status code '{}' and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._id", (Object)"custom:hr"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.details.title", (Object)"humanresources"));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void shouldChooseCorrectTenantDuringDocumentGet() throws Exception {
        GenericRestClient.HttpResponse response;
        BasicHeader header;
        Client tc = cluster.getInternalNodeClient();
        DocNode indexMappings = DocNode.of((String)"_doc", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"sg_tenant", (Object)DocNode.of((String)"type", (Object)"keyword"))));
        ImmutableMap settings = ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0);
        tc.admin().indices().create(new CreateIndexRequest(".kibana").settings((Map)settings).mapping((Map)indexMappings)).actionGet();
        String body = "{\"type\" : \"custom-saved-object\",\"updated_at\" : \"2018-09-29T08:56:59.066Z\",\"details\" : {\"title\" : \"humanresources\"},\"sg_tenant\":\"1592542611_humanresources\"}";
        tc.index(((IndexRequest)new IndexRequest(".kibana").id("custom:hr__sg_ten__1592542611_humanresources").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
        body = "{\"type\" : \"custom-saved-object\",\"updated_at\" : \"2018-09-29T08:56:59.066Z\",\"details\" : {\"title\" : \"global tenant\"}}";
        tc.index(((IndexRequest)new IndexRequest(".kibana").id("custom-saved-object:global").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
        try (GenericRestClient client = cluster.getRestClient("admin", "admin", new Header[0]);){
            header = new BasicHeader("sgtenant", "SGS_GLOBAL_TENANT");
            response = client.get(".kibana/_doc/custom-saved-object:global?pretty", new Header[]{header});
            log.info("Search response status code '{}' and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$._source.details.title", (Object)"global tenant"));
        }
        client = cluster.getRestClient("hr_employee", "hr_employee", new Header[0]);
        try {
            header = new BasicHeader("sgtenant", "human_resources");
            response = client.get(".kibana/_doc/custom:hr?pretty", new Header[]{header});
            log.info("Search response status code '{}' and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$._source.details.title", (Object)"humanresources"));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKibanaAlias() throws Exception {
        try {
            String tenantName = "human_resources";
            String internalTenantName = tenantName.hashCode() + "_humanresources";
            Client tc = cluster.getInternalNodeClient();
            String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\", \"sg_tenant\": \"human_resources\"}";
            tc.admin().indices().create(new CreateIndexRequest(".kibana_8.8.0_001").alias(new Alias(".kibana")).settings((Map)ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0))).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_8.8.0_001").id("6.2.2__sg_ten__" + internalTenantName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
            try (GenericRestClient client = cluster.getRestClient("hr_employee", "hr_employee", new Header[0]);){
                GenericRestClient.HttpResponse res = client.get(".kibana/_doc/6.2.2?pretty", new Header[]{new BasicHeader("sgtenant", tenantName)});
                Assert.assertEquals((long)200L, (long)res.getStatusCode());
            }
        }
        finally {
            try {
                Client tc = cluster.getInternalNodeClient();
                tc.admin().indices().prepareAliases().removeAlias(".kibana_8.8.0_001", ".kibana").get();
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana_8.8.0_001")).actionGet();
            }
            catch (Exception ignored) {
                Assert.fail((String)("Unexpected exception " + String.valueOf(ignored)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKibanaAlias65() throws Exception {
        Client tc;
        try {
            tc = cluster.getInternalNodeClient();
            String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}";
            HashMap<String, Integer> indexSettings = new HashMap<String, Integer>();
            indexSettings.put("number_of_shards", 1);
            indexSettings.put("number_of_replicas", 0);
            tc.admin().indices().create(new CreateIndexRequest(".kibana_1").alias(new Alias(".kibana")).settings(indexSettings)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_1").id("6.2.2__sg_ten__-900636979_kibanaro").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
            try (GenericRestClient client = cluster.getRestClient("kibanaro", "kibanaro", new Header[0]);){
                GenericRestClient.HttpResponse res = client.get(".kibana/_doc/6.2.2?pretty", new Header[]{new BasicHeader("sgtenant", "__user__")});
                Assert.assertEquals((long)403L, (long)res.getStatusCode());
            }
        }
        finally {
            try {
                tc = cluster.getInternalNodeClient();
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana_1")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKibanaAliasKibana_7_12() throws Exception {
        try {
            String tenant = "kibana_7_12_alias_test";
            String internalTenantName = tenant.hashCode() + "_kibana712aliastest";
            Client tc = cluster.getInternalNodeClient();
            String body = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\", \"sg_tenant\": \"kibana_7_12_alias_test\"}";
            tc.admin().indices().create(new CreateIndexRequest(".kibana_7.12.0_001").alias(new Alias(".kibana_7.12.0")).settings((Map)ImmutableMap.of((Object)"number_of_shards", (Object)1, (Object)"number_of_replicas", (Object)0))).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_7.12.0").id("test__sg_ten__" + internalTenantName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(body, XContentType.JSON)).actionGet();
            try (GenericRestClient client = cluster.getRestClient("admin", "admin", tenant);){
                GenericRestClient.HttpResponse response = client.get(".kibana_7.12.0/_doc/test", new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertEquals((String)response.getBody(), (Object)".kibana_7.12.0_001", (Object)response.getBodyAsDocNode().getAsString("_index"));
            }
        }
        finally {
            try {
                Client tc = cluster.getInternalNodeClient();
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana_7.12.0_001")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMgetWithKibanaAlias() throws Exception {
        String indexName = ".kibana";
        String testDoc = "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\", \"sg_tenant\": \"human_resources\"}";
        try (GenericRestClient restClient = cluster.getRestClient("hr_employee", "hr_employee", new Header[]{new BasicHeader("sgtenant", "human_resources")});){
            Client client = cluster.getInternalNodeClient();
            HashMap<String, Integer> indexSettings = new HashMap<String, Integer>();
            indexSettings.put("number_of_shards", 3);
            indexSettings.put("number_of_replicas", 0);
            client.admin().indices().create(new CreateIndexRequest(indexName + "_2").alias(new Alias(indexName)).settings(indexSettings)).actionGet();
            ArrayList<CallSite> mgetIds = new ArrayList<CallSite>(100);
            for (int i = 0; i < 100; ++i) {
                String id = "d" + i;
                String idInTenantScope = id + "__sg_ten__" + "human_resources".hashCode() + "_humanresources";
                client.index(((IndexRequest)new IndexRequest(indexName).id(idInTenantScope).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(testDoc, XContentType.JSON)).actionGet();
                mgetIds.add((CallSite)((Object)id));
            }
            GenericRestClient.HttpResponse response = restClient.postJson(".kibana/_mget", (Map)DocNode.of((String)"ids", mgetIds), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            com.floragunn.fluent.collections.ImmutableList docs = response.getBodyAsDocNode().getAsListOfNodes("docs");
            Assert.assertEquals((long)100L, (long)docs.size());
            for (DocNode doc : docs) {
                MatcherAssert.assertThat((Object)doc, (Matcher)DocNodeMatchers.containsValue((String)"found", (Object)true));
                MatcherAssert.assertThat((Object)doc, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$", (String)"error")));
            }
        }
        finally {
            try {
                Client tc = cluster.getInternalNodeClient();
                tc.admin().indices().delete(new DeleteIndexRequest(indexName + "_2")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserAttributesInTenantPattern() throws Exception {
        try {
            GenericRestClient.HttpResponse response;
            try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_DEPT_01, new Header[0]);){
                response = restClient.get("_searchguard/authinfo", new Header[0]);
                Assert.assertEquals((String)response.getBody(), (Object)"true", (Object)response.getBodyAsDocNode().getAsNode("sg_tenants", new String[]{"dept_01"}).toString());
                Assert.assertNull((Object)response.getBodyAsDocNode().get("sg_tenants", new String[]{"dept_02"}));
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_01")});
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_02")});
                Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            }
            restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_DEPT_02, new Header[0]);
            try {
                response = restClient.get("_searchguard/authinfo", new Header[0]);
                Assert.assertNull((Object)response.getBodyAsDocNode().get("sg_tenants", new String[]{"dept_01"}));
                Assert.assertEquals((Object)"true", (Object)response.getBodyAsDocNode().getAsNode("sg_tenants", new String[]{"dept_02"}).toString());
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_01")});
                Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
                response = restClient.putJson(".kibana/_doc/user_attr_test", "{\"buildNum\": 15460, \"defaultIndex\": \"humanresources\", \"tenant\": \"human_resources\"}", new Header[]{new BasicHeader("sgtenant", "dept_02")});
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            }
            finally {
                if (restClient != null) {
                    restClient.close();
                }
            }
        }
        finally {
            try {
                Client tc = cluster.getInternalNodeClient();
                tc.admin().indices().delete(new DeleteIndexRequest(".kibana")).actionGet();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testMultitenancyConfigApi_configShouldGetUpdated() throws Exception {
        try (GenericRestClient userClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_WITH_ACCESS_TO_GLOBAL_TENANT, new Header[0]);
             GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            cluster.callAndRestoreConfig(FeMultiTenancyConfig.TYPE, () -> {
                GenericRestClient.HttpResponse response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                DocNode config = DocNode.of((String)"enabled", (Object)true, (String)"index", (Object)"kibana_index", (String)"server_user", (Object)"kibana_user", (String)"global_tenant_enabled", (Object)true, (String)"private_tenant_enabled", (Object)false, (Object[])new Object[]{"preferred_tenants", ImmutableList.of((Object)"tenant-1")});
                response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.details.private_tenant_enabled.[0].error", (Object)"Unsupported attribute"));
                config = config.without(new String[]{"private_tenant_enabled"});
                response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = adminCertClient.get("/_searchguard/config/frontend_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = response.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.enabled", (Object)true));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.index", (Object)"kibana_index"));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.server_user", (Object)"kibana_user"));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.global_tenant_enabled", (Object)true));
                MatcherAssert.assertThat((Object)config, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.content", (String)"private_tenant_enabled")));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.content.preferred_tenants", (int)1));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.preferred_tenants[0]", (Object)"tenant-1"));
                response = userClient.get("/_searchguard/current_user/tenants", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants", (String)"SGS_GLOBAL_TENANT"));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data.tenants", (String)USER_WITH_ACCESS_TO_GLOBAL_TENANT.getName())));
                config = DocNode.of((String)"enabled", (Object)true, (String)"index", (Object)"kibana_index_v2", (String)"server_user", (Object)"kibana_user_v2", (String)"global_tenant_enabled", (Object)false, (String)"preferred_tenants", (Object)ImmutableList.of(), (Object[])new Object[0]);
                response = adminCertClient.putJson("/_searchguard/config/frontend_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = response.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.enabled", (Object)true));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.index", (Object)"kibana_index_v2"));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.server_user", (Object)"kibana_user_v2"));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.global_tenant_enabled", (Object)false));
                MatcherAssert.assertThat((Object)config, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.content", (String)"private_tenant_enabled")));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.content.preferred_tenants", (int)0));
                response = userClient.get("/_searchguard/current_user/tenants", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)401));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.message", (Object)"Cannot determine default tenant for current user"));
                config = DocNode.of((String)"enabled", (Object)true, (String)"global_tenant_enabled", (Object)true, (String)"preferred_tenants", (Object)ImmutableList.of((Object)"tenant-2"));
                response = adminCertClient.patchJsonMerge("/_searchguard/config/fe_multi_tenancy", (Document)config, new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = response.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.enabled", (Object)true));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.index", (Object)"kibana_index_v2"));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.server_user", (Object)"kibana_user_v2"));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.global_tenant_enabled", (Object)true));
                MatcherAssert.assertThat((Object)config, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.content", (String)"private_tenant_enabled")));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.content.preferred_tenants", (int)1));
                MatcherAssert.assertThat((Object)config, (Matcher)DocNodeMatchers.containsValue((String)"$.content.preferred_tenants[0]", (Object)"tenant-2"));
                return null;
            });
        }
    }

    @Test
    public void testMultitenancyConfigApi_shouldNotAllowToChangeEnabledFlag_whenThereAreKibanaIndices() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            cluster.callAndRestoreConfig(FeMultiTenancyConfig.TYPE, () -> {
                GenericRestClient.HttpResponse response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                DocNode config = DocNode.of((String)"enabled", (Object)true);
                response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = DocNode.of((String)"enabled", (Object)false);
                response = adminCertClient.patchJsonMerge("/_searchguard/config/fe_multi_tenancy", (Document)config, new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = DocNode.of((String)"enabled", (Object)true);
                DocNode bulkBody = DocNode.of((String)"frontend_multi_tenancy.content", (Object)config);
                response = adminCertClient.putJson("/_searchguard/config", (Document)bulkBody);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = DocNode.of((String)"enabled", (Object)false);
                bulkBody = DocNode.of((String)"frontend_multi_tenancy.content", (Object)config);
                response = adminCertClient.putJson("/_searchguard/config", (Document)bulkBody);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = adminCertClient.put("/.kibana");
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = DocNode.of((String)"enabled", (Object)true);
                response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.['frontend_multi_tenancy.default'].[0].error", (Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
                config = DocNode.of((String)"enabled", (Object)true);
                response = adminCertClient.patchJsonMerge("/_searchguard/config/fe_multi_tenancy", (Document)config, new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.details._.[0].error", (Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
                config = DocNode.of((String)"enabled", (Object)false);
                response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = DocNode.of((String)"enabled", (Object)false);
                response = adminCertClient.patchJsonMerge("/_searchguard/config/fe_multi_tenancy", (Document)config, new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                config = DocNode.of((String)"enabled", (Object)true);
                bulkBody = DocNode.of((String)"frontend_multi_tenancy.content", (Object)config);
                response = adminCertClient.putJson("/_searchguard/config", (Document)bulkBody);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.details.['frontend_multi_tenancy.default'].[0].error", (Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
                config = DocNode.of((String)"enabled", (Object)false);
                bulkBody = DocNode.of((String)"frontend_multi_tenancy.content", (Object)config);
                response = adminCertClient.putJson("/_searchguard/config", (Document)bulkBody);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                return null;
            });
        }
    }

    @Test
    public void shouldExtendsMappingsWhenMultiTenancyIsEnabled() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            cluster.callAndRestoreConfig(FeMultiTenancyConfig.TYPE, () -> {
                GenericRestClient.HttpResponse response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                Client client = cluster.getInternalNodeClient();
                List<String> indices = Arrays.asList(".kibana", ".kibana_analytics", ".kibana_ingest", ".kibana_security_solution", ".kibana_alerting_cases");
                DocNode config = DocNode.of((String)"enabled", (Object)false);
                response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                for (String indexName2 : indices) {
                    response = adminCertClient.put("/" + indexName2);
                    MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                }
                response = adminCertClient.put("/_searchguard/config/fe_multi_tenancy/activation");
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                GetMappingsRequest request = (GetMappingsRequest)new GetMappingsRequest().indices((String[])indices.toArray(String[]::new));
                GetMappingsResponse mappingsResponse = (GetMappingsResponse)client.admin().indices().getMappings(request).actionGet();
                Map mappings = mappingsResponse.getMappings();
                long numberOfIndicesWithExtendedMappings = indices.stream().map(indexName -> (MappingMetadata)mappings.get(indexName)).filter(Objects::nonNull).map(metadata -> metadata.sourceAsMap()).map(mappingsMap -> (Map)mappingsMap.get("properties")).filter(Objects::nonNull).map(mappingProperties -> (Map)mappingProperties.get("sg_tenant")).filter(Objects::nonNull).map(fieldMappings -> fieldMappings.get("type")).filter(fieldType -> "keyword".equals(fieldType)).count();
                MatcherAssert.assertThat((Object)numberOfIndicesWithExtendedMappings, (Matcher)Matchers.equalTo((Object)indices.size()));
                return null;
            });
        }
    }

    @Test
    public void shouldEnableMultitenancy() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            cluster.callAndRestoreConfig(FeMultiTenancyConfig.TYPE, () -> {
                DocNode config = DocNode.of((String)"enabled", (Object)false);
                GenericRestClient.HttpResponse response = adminCertClient.putJson("/_searchguard/config/fe_multi_tenancy", (Document)config);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.content.enabled", (Object)false));
                List<String> indices = Arrays.asList(".kibana", ".kibana_analytics", ".kibana_ingest", ".kibana_security_solution", ".kibana_alerting_cases");
                for (String indexName : indices) {
                    response = adminCertClient.put("/" + indexName);
                    MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                }
                response = adminCertClient.put("/_searchguard/config/fe_multi_tenancy/activation");
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                response = adminCertClient.get("/_searchguard/config/fe_multi_tenancy", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.content.enabled", (Object)true));
                return null;
            });
        }
    }
}

