/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.IndexNameDataFormatter;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class DataMigrationContext {
    private static final AtomicInteger instanceCounter = new AtomicInteger(0);
    public static final String BACKUP_INDEX_NAME_PREFIX = "backup_fe_migration_to_8_8_0_";
    private final MigrationConfig config;
    private final LocalDateTime startTime;
    private final String migrationId;
    private ImmutableList<TenantIndex> tenantIndices;
    private ImmutableList<String> backupIndices;
    private Boolean backupCreated;

    public DataMigrationContext(MigrationConfig config, Clock clock) {
        this.config = Objects.requireNonNull(config, "Migration config is required");
        this.startTime = LocalDateTime.now(clock);
        int instanceNumber = instanceCounter.incrementAndGet();
        String time = IndexNameDataFormatter.format(this.startTime);
        this.migrationId = "number-" + instanceNumber + "-" + time + "-" + String.valueOf(UUID.randomUUID());
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public String getTempIndexName() {
        return "data_migration_temp_fe_" + IndexNameDataFormatter.format(this.startTime);
    }

    public String getBackupIndexName() {
        return BACKUP_INDEX_NAME_PREFIX + IndexNameDataFormatter.format(this.startTime);
    }

    public String getMigrationId() {
        return this.migrationId;
    }

    public ImmutableList<TenantIndex> getTenantIndices() {
        return this.tenantIndices;
    }

    public void setTenantIndices(ImmutableList<TenantIndex> tenantIndices) {
        Objects.requireNonNull(tenantIndices, "Tenants list must not be null");
        this.tenantIndices = tenantIndices;
    }

    public ImmutableList<String> getDataIndicesNames() {
        return Optional.ofNullable(this.tenantIndices).orElse((ImmutableList<TenantIndex>)ImmutableList.empty()).map(TenantIndex::indexName);
    }

    public String getGlobalTenantIndexName() {
        return this.tenantIndices.stream().filter(TenantIndex::belongsToGlobalTenant).map(TenantIndex::indexName).findAny().orElseThrow(() -> new IllegalStateException("Global tenant not found!"));
    }

    public boolean areYellowDataIndicesAllowed() {
        return this.config.allowYellowIndices();
    }

    public ImmutableList<String> getBackupIndices() {
        return this.backupIndices == null ? ImmutableList.empty() : this.backupIndices;
    }

    public void setBackupIndices(ImmutableList<String> backupIndices) {
        this.backupIndices = backupIndices;
    }

    public Optional<String> getNewestExistingBackupIndex() {
        return Optional.ofNullable(this.backupIndices).filter(list -> !list.isEmpty()).map(list -> (String)list.get(0));
    }

    public Boolean getBackupCreated() {
        return this.backupCreated;
    }

    public void setBackupCreated(Boolean backupCreated) {
        this.backupCreated = backupCreated;
    }

    public ImmutableList<TenantIndex> getTenantIndicesWithoutGlobalTenant() {
        List<TenantIndex> mutableList = this.getTenantIndices().stream().filter(tenantIndex -> !tenantIndex.belongsToGlobalTenant()).toList();
        return ImmutableList.of(mutableList);
    }
}

