/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.mapper;

import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.request.mapper.Unscoper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class SearchMapper
implements Unscoper<SearchResponse> {
    private static final Logger log = LogManager.getLogger(SearchMapper.class);

    public SearchRequest toScopedSearchRequest(SearchRequest request, String tenant) {
        log.debug("Rewriting search request - adding tenant scope");
        BoolQueryBuilder queryBuilder = RequestResponseTenantData.sgTenantFieldQuery(tenant);
        if (request.source().query() != null) {
            queryBuilder.must(request.source().query());
        }
        log.trace("handling search request: {}", (Object)queryBuilder);
        request.source().query((QueryBuilder)queryBuilder);
        if (log.isDebugEnabled()) {
            log.debug("Query to indices '{}' was intercepted to limit access only to tenant '{}', extended query version '{}'", (Object)String.join((CharSequence)", ", request.indices()), (Object)tenant, (Object)queryBuilder);
        }
        return request;
    }

    @Override
    public SearchResponse unscopeResponse(SearchResponse response) {
        log.debug("Rewriting search response - removing tenant scope");
        SearchHits originalSearchHits = response.getHits().asUnpooled();
        SearchHit[] originalSearchHitArray = originalSearchHits.getHits();
        SearchHit[] rewrittenSearchHitArray = new SearchHit[originalSearchHitArray.length];
        for (int i = 0; i < originalSearchHitArray.length; ++i) {
            rewrittenSearchHitArray[i] = SearchHit.unpooled((int)originalSearchHitArray[i].docId(), (String)RequestResponseTenantData.unscopedId(originalSearchHitArray[i].getId()), (SearchHit.NestedIdentity)originalSearchHitArray[i].getNestedIdentity());
            rewrittenSearchHitArray[i].sourceRef(originalSearchHitArray[i].getSourceRef());
            rewrittenSearchHitArray[i].addDocumentFields(originalSearchHitArray[i].getDocumentFields(), originalSearchHitArray[i].getMetadataFields());
            rewrittenSearchHitArray[i].setPrimaryTerm(originalSearchHitArray[i].getPrimaryTerm());
            rewrittenSearchHitArray[i].setSeqNo(originalSearchHitArray[i].getSeqNo());
            rewrittenSearchHitArray[i].setRank(originalSearchHitArray[i].getRank());
            rewrittenSearchHitArray[i].shard(originalSearchHitArray[i].getShard());
            rewrittenSearchHitArray[i].version(originalSearchHitArray[i].getVersion());
            rewrittenSearchHitArray[i].score(originalSearchHitArray[i].getScore());
            rewrittenSearchHitArray[i].explanation(originalSearchHitArray[i].getExplanation());
        }
        SearchHits rewrittenSearchHits = SearchHits.unpooled((SearchHit[])rewrittenSearchHitArray, (TotalHits)originalSearchHits.getTotalHits(), (float)originalSearchHits.getMaxScore());
        SearchResponseSections rewrittenSections = new SearchResponseSections(rewrittenSearchHits, response.getAggregations(), response.getSuggest(), response.isTimedOut(), response.isTerminatedEarly(), null, response.getNumReducePhases());
        SearchResponse pooledSearchResponse = new SearchResponse(rewrittenSections, response.getScrollId(), response.getTotalShards(), response.getSuccessfulShards(), response.getSkippedShards(), response.getTook().millis(), response.getShardFailures(), response.getClusters(), response.pointInTimeId());
        return pooledSearchResponse;
    }
}

